/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;

public final class OracleSchemaHelper {
    private static final String DEFAULT_PASSWORD = "testPassword";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    private OracleSchemaHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initOracleSchema(DataSource dataSource, String schemaName) throws SystemException {
        JoinPoint joinPoint;
        block21: {
            DataSource dataSource2 = dataSource;
            String string = schemaName;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)dataSource2, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            try {
                Throwable throwable = null;
                Object var3_8 = null;
                try {
                    Connection connection = dataSource.getConnection();
                    try {
                        block20: {
                            Connection conn = DriverManager.getConnection(connection.getMetaData().getURL(), "SYSTEM", DEFAULT_PASSWORD);
                            try {
                                try (Statement stmt = conn.createStatement();){
                                    stmt.execute("GRANT ALL PRIVILEGES TO TEST_USER");
                                    OracleSchemaHelper.dropExistingSchema(schemaName, stmt);
                                    stmt.addBatch(String.format("create tablespace %s datafile '%s.dat' size 5M autoextend on NEXT 5M MAXSIZE UNLIMITED", schemaName, schemaName));
                                    stmt.addBatch(String.format("create temporary tablespace %s_TMP tempfile '%s_tmp.dat' size 5M autoextend on NEXT 5M MAXSIZE UNLIMITED", schemaName, schemaName));
                                    stmt.addBatch(String.format("create user %s identified by %s default tablespace %s temporary tablespace %s_TMP", schemaName, DEFAULT_PASSWORD, schemaName, schemaName));
                                    stmt.addBatch(String.format("ALTER USER %s quota unlimited on %s", schemaName, schemaName));
                                    stmt.addBatch(String.format("GRANT UNLIMITED TABLESPACE TO %s", schemaName));
                                    stmt.executeBatch();
                                }
                                if (conn == null) break block20;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (conn == null) throw throwable;
                                conn.close();
                                throw throwable;
                            }
                            conn.close();
                        }
                        if (connection == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (connection == null) throw throwable;
                        connection.close();
                        throw throwable;
                    }
                    connection.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new SystemException("Failed to setup ORACLE Schema", (Throwable)e);
            }
        }
        Object var10_15 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_15);
    }

    private static void dropExistingSchema(String schemaName, Statement stmt) {
        String string = schemaName;
        Statement statement = stmt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string, (Object)statement);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            stmt.addBatch(String.format("DROP USER %s CASCADE", schemaName));
            stmt.addBatch(String.format("DROP TABLESPACE %s_TMP INCLUDING CONTENTS AND DATAFILES CASCADE CONSTRAINTS", schemaName));
            stmt.addBatch(String.format("DROP TABLESPACE %s INCLUDING CONTENTS AND DATAFILES CASCADE CONSTRAINTS", schemaName));
            stmt.executeBatch();
        }
        catch (Exception exception) {
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    static {
        OracleSchemaHelper.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OracleSchemaHelper.java", OracleSchemaHelper.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "initOracleSchema", "pro.taskana.common.test.OracleSchemaHelper", "javax.sql.DataSource:java.lang.String", "dataSource:schemaName", "pro.taskana.common.api.exceptions.SystemException", "void"), 18);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "dropExistingSchema", "pro.taskana.common.test.OracleSchemaHelper", "java.lang.String:java.sql.Statement", "schemaName:stmt", "", "void"), 53);
    }
}

