/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.test.config;

import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.test.DockerContainerCreator;
import pro.taskana.common.test.OracleSchemaHelper;

public final class DataSourceGenerator {
    private static final DataSource DATA_SOURCE;
    private static final String SCHEMA_NAME;
    private static final int POOL_TIME_TO_WAIT = 50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        DataSourceGenerator.ajc$preClinit();
        DB db = DataSourceGenerator.retrieveDatabaseFromEnv();
        Optional<JdbcDatabaseContainer<?>> dockerContainer = DockerContainerCreator.createDockerContainer(db);
        SCHEMA_NAME = DataSourceGenerator.determineSchemaName(db);
        if (dockerContainer.isPresent()) {
            dockerContainer.get().start();
            DATA_SOURCE = DockerContainerCreator.createDataSource(dockerContainer.get());
            if (DB.isOracle((String)db.dbProductId)) {
                OracleSchemaHelper.initOracleSchema(DATA_SOURCE, SCHEMA_NAME);
            }
        } else {
            DATA_SOURCE = DataSourceGenerator.createDataSourceForH2();
        }
    }

    private DataSourceGenerator() {
    }

    public static DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = DATA_SOURCE);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public static String getSchemaName() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = SCHEMA_NAME);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static DataSource createDataSourceForH2() {
        PooledDataSource pooledDataSource;
        PooledDataSource pooledDataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String jdbcDriver = "org.h2.Driver";
        String jdbcUrl = "jdbc:h2:mem:taskana;NON_KEYWORDS=KEY,VALUE;LOCK_MODE=0;INIT=CREATE SCHEMA IF NOT EXISTS TASKANA\\;SET COLLATION DEFAULT_de_DE ";
        String dbUserName = "sa";
        String dbPassword = "sa";
        PooledDataSource ds = new PooledDataSource(Thread.currentThread().getContextClassLoader(), jdbcDriver, jdbcUrl, dbUserName, dbPassword);
        ds.setPoolTimeToWait(50);
        ds.forceCloseAll();
        PooledDataSource pooledDataSource3 = pooledDataSource2 = (pooledDataSource = ds);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)pooledDataSource2);
        return pooledDataSource;
    }

    private static String determineSchemaName(DB db) {
        String string;
        DB dB = db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)dB);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string2 = db == DB.POSTGRES ? "taskana" : "TASKANA";
        String string3 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    private static DB retrieveDatabaseFromEnv() {
        DB dB;
        DB dB2;
        DB db;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String property = System.getenv("DB");
        try {
            db = DB.valueOf((String)property);
        }
        catch (Exception exception) {
            db = DB.H2;
        }
        DB dB3 = dB2 = (dB = db);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DataSourceGenerator.java", DataSourceGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDataSource", "pro.taskana.common.test.config.DataSourceGenerator", "", "", "", "javax.sql.DataSource"), 45);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSchemaName", "pro.taskana.common.test.config.DataSourceGenerator", "", "", "", "java.lang.String"), 49);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "createDataSourceForH2", "pro.taskana.common.test.config.DataSourceGenerator", "", "", "", "javax.sql.DataSource"), 53);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "determineSchemaName", "pro.taskana.common.test.config.DataSourceGenerator", "pro.taskana.common.internal.configuration.DB", "db", "", "java.lang.String"), 74);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "retrieveDatabaseFromEnv", "pro.taskana.common.test.config.DataSourceGenerator", "", "", "", "pro.taskana.common.internal.configuration.DB"), 78);
    }
}

