/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.LocalTimeInterval;
import pro.taskana.common.api.WorkingDaysToDaysConverter;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.internal.logging.LoggingAspect;

public class WorkingTimeCalculator {
    public static final Map<DayOfWeek, LocalTimeInterval> WORKING_TIME;
    private final ZoneId zone;
    private final WorkingDaysToDaysConverter converter;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        WorkingTimeCalculator.ajc$preClinit();
        WORKING_TIME = new EnumMap<DayOfWeek, LocalTimeInterval>(DayOfWeek.class);
        WORKING_TIME.put(DayOfWeek.MONDAY, new LocalTimeInterval(LocalTime.of(6, 0), LocalTime.of(18, 0)));
        WORKING_TIME.put(DayOfWeek.TUESDAY, new LocalTimeInterval(LocalTime.of(6, 0), LocalTime.of(18, 0)));
        WORKING_TIME.put(DayOfWeek.WEDNESDAY, new LocalTimeInterval(LocalTime.of(6, 0), LocalTime.of(18, 0)));
        WORKING_TIME.put(DayOfWeek.THURSDAY, new LocalTimeInterval(LocalTime.of(6, 0), LocalTime.of(18, 0)));
        WORKING_TIME.put(DayOfWeek.FRIDAY, new LocalTimeInterval(LocalTime.of(6, 0), LocalTime.of(18, 0)));
        WORKING_TIME.put(DayOfWeek.SATURDAY, null);
        WORKING_TIME.put(DayOfWeek.SUNDAY, null);
    }

    public WorkingTimeCalculator(WorkingDaysToDaysConverter converter) {
        this.converter = converter;
        this.zone = ZoneId.of("UTC");
    }

    public Duration workingTimeBetweenTwoTimestamps(Instant from, Instant to) throws InvalidArgumentException {
        Duration duration;
        Duration duration2;
        Duration duration3;
        Instant instant = from;
        Instant instant2 = to;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.checkValidInput(from, to);
        Instant currentTime = from;
        LocalDate currentDate = LocalDateTime.ofInstant(from, this.zone).toLocalDate();
        LocalDate untilDate = LocalDateTime.ofInstant(to, this.zone).toLocalDate();
        DayOfWeek weekDay = currentDate.getDayOfWeek();
        if (currentDate.isEqual(untilDate)) {
            duration2 = duration3 = this.calculateDurationWithinOneDay(from, to, weekDay, currentDate);
        } else {
            Duration duration4 = Duration.ZERO;
            duration4 = duration4.plus(this.calculateDurationOfStartDay(currentTime, weekDay, currentDate));
            currentTime = currentTime.plus(1L, ChronoUnit.DAYS);
            currentDate = currentDate.plusDays(1L);
            weekDay = weekDay.plus(1L);
            while (!currentDate.isEqual(untilDate)) {
                duration4 = duration4.plus(this.calculateDurationOfOneWorkDay(weekDay, currentDate));
                weekDay = weekDay.plus(1L);
                currentDate = currentDate.plusDays(1L);
                currentTime = currentTime.plus(1L, ChronoUnit.DAYS);
            }
            duration2 = duration3 = duration4.plus(this.calculateDurationOnEndDay(to, weekDay, currentDate));
        }
        Duration duration5 = duration = duration2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration);
        return duration3;
    }

    /*
     * Unable to fully structure code
     */
    private Duration calculateDurationWithinOneDay(Instant from, Instant to, DayOfWeek weekday, LocalDate currentDate) {
        block3: {
            block4: {
                block5: {
                    block2: {
                        var12_5 = from;
                        var13_6 = to;
                        var14_7 = weekday;
                        var15_8 = currentDate;
                        var11_9 = new Object[]{var12_5, var13_6, var14_7, var15_8};
                        var10_10 = Factory.makeJP((JoinPoint.StaticPart)WorkingTimeCalculator.ajc$tjp_1, (Object)this, (Object)this, (Object[])var11_9);
                        LoggingAspect.aspectOf().beforeMethodExecuted(var10_10);
                        workHours = WorkingTimeCalculator.WORKING_TIME.get(weekday);
                        if (WorkingTimeCalculator.WORKING_TIME.get(weekday) == null || this.converter.isHoliday(currentDate)) ** GOTO lbl-1000
                        start = workHours.getBegin();
                        end = workHours.getEnd();
                        fromTime = from.atZone(this.zone).toLocalTime();
                        toTime = to.atZone(this.zone).toLocalTime();
                        if (fromTime.isBefore(start) || !toTime.isBefore(end)) break block2;
                        v0 = var16_16 = Duration.between(from, to);
                        break block3;
                    }
                    if (!fromTime.isBefore(start)) break block4;
                    if (!toTime.isAfter(end)) break block5;
                    v0 = var16_16 = this.addWorkingHoursOfOneDay(weekday);
                    break block3;
                }
                if (toTime.isBefore(start)) ** GOTO lbl-1000
                v0 = var16_16 = Duration.between(start, toTime);
                break block3;
            }
            if (fromTime.isBefore(end)) {
                v0 = var16_16 = Duration.between(fromTime, end);
            } else lbl-1000:
            // 3 sources

            {
                v0 = var16_16 = Duration.ZERO;
            }
        }
        v1 = var17_17 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var10_10, (Object)var17_17);
        return var16_16;
    }

    private Duration calculateDurationOfOneWorkDay(DayOfWeek weekday, LocalDate date) {
        Duration duration;
        Duration duration2;
        DayOfWeek dayOfWeek = weekday;
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)dayOfWeek, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Duration duration3 = duration2 = WORKING_TIME.get(weekday) != null && !this.converter.isHoliday(date) ? (duration = this.addWorkingHoursOfOneDay(weekday)) : (duration = Duration.ZERO);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    /*
     * Unable to fully structure code
     */
    private Duration calculateDurationOfStartDay(Instant startDay, DayOfWeek weekday, LocalDate date) {
        var9_4 = startDay;
        var10_5 = weekday;
        var11_6 = date;
        var8_7 = new Object[]{var9_4, var10_5, var11_6};
        var7_8 = Factory.makeJP((JoinPoint.StaticPart)WorkingTimeCalculator.ajc$tjp_3, (Object)this, (Object)this, (Object[])var8_7);
        LoggingAspect.aspectOf().beforeMethodExecuted(var7_8);
        workHours = WorkingTimeCalculator.WORKING_TIME.get(weekday);
        if (WorkingTimeCalculator.WORKING_TIME.get(weekday) == null || this.converter.isHoliday(date)) ** GOTO lbl-1000
        fromTime = startDay.atZone(this.zone).toLocalTime();
        end = workHours.getEnd();
        if (fromTime.isBefore(workHours.getBegin())) {
            v0 = var12_12 = this.addWorkingHoursOfOneDay(weekday);
        } else if (fromTime.isBefore(end)) {
            v0 = var12_12 = Duration.between(fromTime, end);
        } else lbl-1000:
        // 2 sources

        {
            v0 = var12_12 = Duration.ZERO;
        }
        v1 = var13_13 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var7_8, (Object)var13_13);
        return var12_12;
    }

    /*
     * Unable to fully structure code
     */
    private Duration calculateDurationOnEndDay(Instant endDate, DayOfWeek weekday, LocalDate date) {
        var9_4 = endDate;
        var10_5 = weekday;
        var11_6 = date;
        var8_7 = new Object[]{var9_4, var10_5, var11_6};
        var7_8 = Factory.makeJP((JoinPoint.StaticPart)WorkingTimeCalculator.ajc$tjp_4, (Object)this, (Object)this, (Object[])var8_7);
        LoggingAspect.aspectOf().beforeMethodExecuted(var7_8);
        workHours = WorkingTimeCalculator.WORKING_TIME.get(weekday);
        if (WorkingTimeCalculator.WORKING_TIME.get(weekday) == null || this.converter.isHoliday(date)) ** GOTO lbl-1000
        start = workHours.getBegin();
        toTime = endDate.atZone(this.zone).toLocalTime();
        if (toTime.isAfter(workHours.getEnd())) {
            v0 = var12_12 = this.addWorkingHoursOfOneDay(weekday);
        } else if (!toTime.isBefore(start)) {
            v0 = var12_12 = Duration.between(start, toTime);
        } else lbl-1000:
        // 2 sources

        {
            v0 = var12_12 = Duration.ZERO;
        }
        v1 = var13_13 = v0;
        LoggingAspect.aspectOf().afterMethodExecuted(var7_8, (Object)var13_13);
        return var12_12;
    }

    private void checkValidInput(Instant from, Instant to) throws InvalidArgumentException {
        Instant instant = from;
        Instant instant2 = to;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (from == null || to == null || from.compareTo(to) > 0) {
            throw new InvalidArgumentException("Instants are invalid.");
        }
        for (LocalTimeInterval interval : WORKING_TIME.values()) {
            if (interval == null || interval.isValid()) continue;
            throw new InvalidArgumentException("The work period doesn't have two LocalTimes for start and end.");
        }
        Object var8_8 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var8_8);
    }

    private Duration addWorkingHoursOfOneDay(DayOfWeek weekday) {
        Duration duration;
        Duration duration2;
        DayOfWeek dayOfWeek = weekday;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)dayOfWeek);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalTimeInterval workHours = WORKING_TIME.get(weekday);
        Duration duration3 = duration2 = workHours.isValid() ? (duration = Duration.between(workHours.getBegin(), workHours.getEnd())) : (duration = Duration.ZERO);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)duration2);
        return duration;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingTimeCalculator.java", WorkingTimeCalculator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "workingTimeBetweenTwoTimestamps", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.Instant:java.time.Instant", "from:to", "pro.taskana.common.api.exceptions.InvalidArgumentException", "java.time.Duration"), 44);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDurationWithinOneDay", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.Instant:java.time.Instant:java.time.DayOfWeek:java.time.LocalDate", "from:to:weekday:currentDate", "", "java.time.Duration"), 72);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDurationOfOneWorkDay", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.DayOfWeek:java.time.LocalDate", "weekday:date", "", "java.time.Duration"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDurationOfStartDay", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.Instant:java.time.DayOfWeek:java.time.LocalDate", "startDay:weekday:date", "", "java.time.Duration"), 103);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDurationOnEndDay", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.Instant:java.time.DayOfWeek:java.time.LocalDate", "endDate:weekday:date", "", "java.time.Duration"), 118);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkValidInput", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.Instant:java.time.Instant", "from:to", "pro.taskana.common.api.exceptions.InvalidArgumentException", "void"), 132);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addWorkingHoursOfOneDay", "pro.taskana.common.api.WorkingTimeCalculator", "java.time.DayOfWeek", "weekday", "", "java.time.Duration"), 145);
    }
}

