/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.internal.logging.LoggingAspect;

public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ReflectionUtil.ajc$preClinit();
        PRIMITIVES_TO_WRAPPERS = new HashMap();
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
    }

    private ReflectionUtil() {
        throw new IllegalStateException("utility class");
    }

    public static List<Field> retrieveAllFields(Class<?> currentClass) {
        List<Field> list;
        List<Field> list2;
        Class<?> clazz = currentClass;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, clazz);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ArrayList<Field> fields = new ArrayList<Field>();
        while (currentClass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
        List<Field> list3 = list2 = (list = fields.stream().filter(f -> !f.isSynthetic()).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    public static <T> Class<T> wrap(Class<T> c) {
        Class<T> clazz;
        Class<T> clazz2 = c;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, clazz2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Class<T> clazz3 = c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
        Class<T> clazz4 = clazz = clazz3;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, clazz);
        return clazz3;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ReflectionUtil.java", ReflectionUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "retrieveAllFields", "pro.taskana.common.internal.util.ReflectionUtil", "java.lang.Class", "currentClass", "", "java.util.List"), 31);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "wrap", "pro.taskana.common.internal.util.ReflectionUtil", "java.lang.Class", "c", "", "java.lang.Class"), 42);
    }
}

