/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api.security;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class GroupPrincipal
implements Principal {
    private final String name;
    private final Set<Principal> members;

    public GroupPrincipal(String name) {
        this.name = name;
        this.members = new HashSet<Principal>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    public boolean isMember(Principal member) {
        return this.members.contains(member);
    }

    public Enumeration<Principal> members() {
        return Collections.enumeration(this.members);
    }

    @Override
    public String toString() {
        return "GroupPrincipal [name=" + this.name + ", members=" + this.members + "]";
    }
}

