/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.UnsupportedDatabaseException;

public enum DB {
    H2("H2", "h2"),
    DB2("DB2", "db2"),
    POSTGRES("PostgreSQL", "postgres");

    public final String dbProductName;
    public final String dbProductId;

    private DB(String dbProductName, String dbProductId) {
        this.dbProductName = dbProductName;
        this.dbProductId = dbProductId;
    }

    public static boolean isH2(String dbProductId) {
        return DB.H2.dbProductId.equals(dbProductId);
    }

    public static boolean isDb2(String dbProductId) {
        return DB.DB2.dbProductId.equals(dbProductId);
    }

    public static boolean isPostgres(String dbProductId) {
        return DB.POSTGRES.dbProductId.equals(dbProductId);
    }

    public static DB getDbForId(String databaseId) {
        if (DB.isH2(databaseId)) {
            return H2;
        }
        if (DB.isDb2(databaseId)) {
            return DB2;
        }
        if (DB.isPostgres(databaseId)) {
            return POSTGRES;
        }
        throw new SystemException("Unknown database id: " + databaseId);
    }

    public static String getDatabaseProductId(String dbProductName) {
        if (dbProductName.contains(DB.H2.dbProductName)) {
            return DB.H2.dbProductId;
        }
        if (dbProductName.contains(DB.DB2.dbProductName)) {
            return DB.DB2.dbProductId;
        }
        if (DB.POSTGRES.dbProductName.equals(dbProductName)) {
            return DB.POSTGRES.dbProductId;
        }
        throw new UnsupportedDatabaseException(dbProductName);
    }

    public String getProductId() {
        return this.dbProductId;
    }
}

