/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.util.List;

public interface BaseQuery<T, U extends Enum<U>> {
    public List<T> list();

    public List<T> list(int var1, int var2);

    public List<String> listValues(U var1, SortDirection var2);

    default public List<T> listPage(int pageNumber, int pageSize) {
        int offset = pageNumber < 1 ? 0 : (pageNumber - 1) * pageSize;
        int limit = Math.max(pageSize, 0);
        return this.list(offset, limit);
    }

    public T single();

    public long count();

    default public String[] toUpperCopy(String ... source) {
        if (source == null || source.length == 0) {
            return null;
        }
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    public static enum SortDirection {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String direction;

        private SortDirection(String sortDirection) {
            this.direction = sortDirection;
        }

        public String toString() {
            return this.direction;
        }
    }
}

