/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.Triplet;

public class ObjectAttributeChangeDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectAttributeChangeDetector.class);

    private ObjectAttributeChangeDetector() {
    }

    public static <T> String determineChangesInAttributes(T oldObject, T newObject) {
        LOGGER.debug("Entry to determineChangesInAttributes (oldObject = {}, newObject = {}", oldObject, newObject);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (Objects.isNull(oldObject) || Objects.isNull(newObject)) {
            throw new SystemException("Null was provided as a parameter. Please provide two objects of the same type");
        }
        Class<?> currentClass = oldObject.getClass();
        if (List.class.isAssignableFrom(currentClass)) {
            return ObjectAttributeChangeDetector.compareLists(oldObject, newObject);
        }
        ObjectAttributeChangeDetector.retrieveFields(fields, currentClass);
        Predicate<Triplet> areFieldsNotEqual = fieldAndValuePairTriplet -> !Objects.equals(fieldAndValuePairTriplet.getMiddle(), fieldAndValuePairTriplet.getRight());
        Predicate<Triplet> isFieldNotCustomAttributes = fieldAndValuePairTriplet -> !((Field)fieldAndValuePairTriplet.getLeft()).getName().equals("customAttributes");
        List changedAttributes = fields.stream().peek(field -> field.setAccessible(true)).map(CheckedFunction.wrap(field -> new Triplet<Field, Object, Object>((Field)field, field.get(oldObject), field.get(newObject)))).filter(areFieldsNotEqual.and(isFieldNotCustomAttributes)).map(fieldAndValuePairTriplet -> {
            JSONObject changedAttribute = new JSONObject();
            changedAttribute.put("fieldName", (Object)((Field)fieldAndValuePairTriplet.getLeft()).getName());
            changedAttribute.put("oldValue", (Object)Optional.ofNullable(fieldAndValuePairTriplet.getMiddle()).orElse(""));
            changedAttribute.put("newValue", (Object)Optional.ofNullable(fieldAndValuePairTriplet.getRight()).orElse(""));
            return changedAttribute;
        }).collect(Collectors.toList());
        JSONObject changes = new JSONObject();
        changes.put("changes", changedAttributes);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exit from determineChangesInAttributes(), returning {}", (Object)changes);
        }
        return changes.toString();
    }

    private static void retrieveFields(List<Field> fields, Class<?> currentClass) {
        while (currentClass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(currentClass.getDeclaredFields()));
            currentClass = currentClass.getSuperclass();
        }
    }

    private static <T> String compareLists(T oldObject, T newObject) {
        LOGGER.debug("Entry to determineChangesInAttributes (oldObject = {}, newObject = {}", oldObject, newObject);
        if (!oldObject.equals(newObject)) {
            JSONObject changedAttribute = new JSONObject();
            changedAttribute.put("oldValue", oldObject);
            changedAttribute.put("newValue", newObject);
            JSONObject changes = new JSONObject();
            changes.put("changes", (Object)changedAttribute);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from determineChangesInAttributes(), returning {}", (Object)changes);
            }
            return changes.toString();
        }
        LOGGER.debug("Exit from determineChangesInAttributes(), returning empty String because there are no changed attributes");
        return "";
    }
}

