/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.SqlRunner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;

public class SecurityVerifier {
    public static final String SECURITY_FLAG_COLUMN_NAME = "ENFORCE_SECURITY";
    public static final String INSERT_SECURITY_FLAG_SQL = "INSERT INTO %s.CONFIGURATION (ENFORCE_SECURITY ) VALUES (%b)";
    public static final String SELECT_SECURITY_FLAG_SQL = "SELECT %s FROM %s.CONFIGURATION";
    private static final Logger LOGGER;
    private final String schemaName;
    private final DataSource dataSource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        SecurityVerifier.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SecurityVerifier.class);
    }

    public SecurityVerifier(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.schemaName = schema;
    }

    public void checkSecureAccess(boolean securityEnabled) {
        boolean bl = securityEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (Connection connection = this.dataSource.getConnection();){
                String querySecurity;
                SqlRunner sqlRunner;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(connection.getMetaData().toString());
                }
                if (((Boolean)(sqlRunner = new SqlRunner(connection)).selectOne(querySecurity = String.format(SELECT_SECURITY_FLAG_SQL, SECURITY_FLAG_COLUMN_NAME, this.schemaName), new Object[0]).get(SECURITY_FLAG_COLUMN_NAME)).booleanValue() && !securityEnabled) {
                    LOGGER.error("Tried to start TASKANA in unsecured mode while secured mode is enforced!");
                    throw new SystemException("Secured TASKANA mode is enforced, can't start in unsecured mode");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Security-mode is not yet set. Setting security flag to %b", securityEnabled));
            }
            this.setInitialSecurityMode(securityEnabled);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security-mode is enabled");
        }
        Object var9_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_11);
    }

    private void setInitialSecurityMode(boolean securityEnabled) {
        boolean bl = securityEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (Connection connection = this.dataSource.getConnection();){
                String setSecurityFlagSql = String.format(INSERT_SECURITY_FLAG_SQL, this.schemaName, securityEnabled);
                try {
                    Throwable throwable2 = null;
                    Object var7_14 = null;
                    try (PreparedStatement preparedStatement = connection.prepareStatement(setSecurityFlagSql);){
                        preparedStatement.execute();
                        if (!connection.getAutoCommit()) {
                            connection.commit();
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("Successfully set security-mode to %b", securityEnabled));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException ex) {
                    LOGGER.error("Caught exception while trying to set the initial TASKANA security mode. Aborting start-up process!", (Throwable)ex);
                    throw new SystemException("Couldn't set initial TASKANA security mode. Aborting start-up process!");
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            LOGGER.error("Caught exception while trying to retrieve connection from datasource ", (Throwable)ex);
        }
        Object var11_17 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_17);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SecurityVerifier.java", SecurityVerifier.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkSecureAccess", "pro.taskana.common.internal.configuration.SecurityVerifier", "boolean", "securityEnabled", "", "void"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setInitialSecurityMode", "pro.taskana.common.internal.configuration.SecurityVerifier", "boolean", "securityEnabled", "", "void"), 65);
    }
}

