/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.LongStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;

public class WorkingDaysToDaysConverter {
    private static final long OFFSET_GOOD_FRIDAY = -2L;
    private static final long OFFSET_EASTER_MONDAY = 1L;
    private static final long OFFSET_ASCENSION_DAY = 39L;
    private static final long OFFSET_WHIT_MONDAY = 50L;
    private static final long OFFSET_CORPUS_CHRISTI = 60L;
    private static final Set<CustomHoliday> GERMAN_HOLIDAYS;
    private final boolean germanHolidaysEnabled;
    private final boolean corpusChristiEnabled;
    private final Set<CustomHoliday> customHolidays;
    private final EasterCalculator easterCalculator;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        WorkingDaysToDaysConverter.ajc$preClinit();
        GERMAN_HOLIDAYS = new HashSet<CustomHoliday>(Arrays.asList(CustomHoliday.of(1, 1), CustomHoliday.of(1, 5), CustomHoliday.of(3, 10), CustomHoliday.of(25, 12), CustomHoliday.of(26, 12)));
    }

    public WorkingDaysToDaysConverter(boolean germanHolidaysEnabled, boolean corpusChristiEnabled) {
        this(germanHolidaysEnabled, corpusChristiEnabled, Collections.emptySet());
    }

    public WorkingDaysToDaysConverter(boolean germanHolidaysEnabled, boolean corpusChristiEnabled, Collection<CustomHoliday> customHolidays) {
        this.germanHolidaysEnabled = germanHolidaysEnabled;
        this.corpusChristiEnabled = corpusChristiEnabled;
        this.customHolidays = new HashSet<CustomHoliday>(customHolidays);
        this.easterCalculator = new EasterCalculator();
    }

    public Instant addWorkingDaysToInstant(Instant instant, Duration workingDays) {
        Instant instant2;
        Instant instant3;
        Instant instant4 = instant;
        Duration duration = workingDays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)instant4, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = this.convertWorkingDaysToDays(instant, workingDays.toDays(), ZeroDirection.ADD_DAYS);
        Instant instant5 = instant3 = (instant2 = instant.plus(Duration.ofDays(days)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant3);
        return instant2;
    }

    public Instant subtractWorkingDaysFromInstant(Instant instant, Duration workingDays) {
        Instant instant2;
        Instant instant3;
        Instant instant4 = instant;
        Duration duration = workingDays;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)instant4, (Object)duration);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = this.convertWorkingDaysToDays(instant, -workingDays.toDays(), ZeroDirection.SUB_DAYS);
        Instant instant5 = instant3 = (instant2 = instant.plus(Duration.ofDays(days)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)instant3);
        return instant2;
    }

    public boolean hasWorkingDaysInBetween(Instant left, Instant right) {
        boolean bl;
        boolean bl2;
        Instant instant = left;
        Instant instant2 = right;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)instant, (Object)instant2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        long days = Duration.between(left, right).abs().toDays();
        Instant firstInstant = left.isBefore(right) ? left : right;
        boolean bl3 = bl2 = (bl = LongStream.range(1L, days).anyMatch(day -> this.isWorkingDay(firstInstant.plus(day, ChronoUnit.DAYS))));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isWorkingDay(Instant referenceDate) {
        boolean bl;
        boolean bl2;
        Instant instant = referenceDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)instant);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        LocalDate dateToCheck = LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).toLocalDate();
        boolean bl3 = bl2 = !this.isWeekend(dateToCheck) && !this.isHoliday(dateToCheck) ? (bl = true) : (bl = false);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isWeekend(LocalDate dateToCheck) {
        boolean bl;
        boolean bl2;
        LocalDate localDate = dateToCheck;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = !dateToCheck.getDayOfWeek().equals(DayOfWeek.SATURDAY) && !dateToCheck.getDayOfWeek().equals(DayOfWeek.SUNDAY) ? (bl = false) : (bl = true);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isHoliday(LocalDate date) {
        boolean bl;
        boolean bl2;
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = this.germanHolidaysEnabled && this.isGermanHoliday(date) ? (bl = true) : (bl = this.customHolidays.contains(CustomHoliday.of(date.getDayOfMonth(), date.getMonthValue())));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public boolean isGermanHoliday(LocalDate date) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        LocalDate localDate = date;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)localDate);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (GERMAN_HOLIDAYS.contains(CustomHoliday.of(date.getDayOfMonth(), date.getMonthValue()))) {
            bl2 = bl3 = true;
        } else {
            long diffFromEasterSunday = ChronoUnit.DAYS.between(this.easterCalculator.getEasterSunday(date.getYear()), date);
            LongStream.Builder builder = LongStream.builder().add(-2L).add(1L).add(39L).add(50L);
            if (this.corpusChristiEnabled) {
                builder.add(60L);
            }
            bl2 = bl3 = builder.build().anyMatch(c -> c == diffFromEasterSunday);
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private long convertWorkingDaysToDays(Instant startTime, long numberOfDays, ZeroDirection zeroDirection) {
        long l;
        long l2;
        Instant instant = startTime;
        long l3 = numberOfDays;
        ZeroDirection zeroDirection2 = zeroDirection;
        Object[] objectArray = new Object[]{instant, Conversions.longObject((long)l3), zeroDirection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (startTime == null) {
            throw new SystemException("Internal Error: convertWorkingDaysToDays was called with a null startTime");
        }
        int direction = this.calculateDirection(numberOfDays, zeroDirection);
        long limit = Math.abs(numberOfDays);
        long l4 = l2 = (l = LongStream.iterate(0L, i -> i + (long)direction).filter(day -> this.isWorkingDay(startTime.plus(day, ChronoUnit.DAYS))).skip(limit).findFirst().orElse(0L));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.longObject((long)l2));
        return l;
    }

    private int calculateDirection(long numberOfDays, ZeroDirection zeroDirection) {
        int n;
        int n2;
        long l = numberOfDays;
        ZeroDirection zeroDirection2 = zeroDirection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)((Object)zeroDirection2));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        int n3 = n2 = numberOfDays == 0L ? (n = zeroDirection.getDirection()) : (n = numberOfDays >= 0L ? 1 : -1);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
        return n;
    }

    public String toString() {
        return "WorkingDaysToDaysConverter [germanHolidaysEnabled=" + this.germanHolidaysEnabled + ", corpusChristiEnabled=" + this.corpusChristiEnabled + ", customHolidays=" + this.customHolidays + ", easterCalculator=" + this.easterCalculator + "]";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WorkingDaysToDaysConverter.java", WorkingDaysToDaysConverter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addWorkingDaysToInstant", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.Instant:java.time.Duration", "instant:workingDays", "", "java.time.Instant"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "subtractWorkingDaysFromInstant", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.Instant:java.time.Duration", "instant:workingDays", "", "java.time.Instant"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasWorkingDaysInBetween", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.Instant:java.time.Instant", "left:right", "", "boolean"), 81);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWorkingDay", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.Instant", "referenceDate", "", "boolean"), 87);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWeekend", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.LocalDate", "dateToCheck", "", "boolean"), 93);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isHoliday", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.LocalDate", "date", "", "boolean"), 98);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isGermanHoliday", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.LocalDate", "date", "", "boolean"), 106);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "convertWorkingDaysToDays", "pro.taskana.common.api.WorkingDaysToDaysConverter", "java.time.Instant:long:pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection", "startTime:numberOfDays:zeroDirection", "", "long"), 129);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateDirection", "pro.taskana.common.api.WorkingDaysToDaysConverter", "long:pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection", "numberOfDays:zeroDirection", "", "int"), 144);
    }

    static class EasterCalculator {
        LocalDate cachedEasterDay;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        EasterCalculator() {
        }

        LocalDate getEasterSunday(int year) {
            LocalDate localDate;
            LocalDate localDate2;
            LocalDate localDate3;
            int n = year;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (this.cachedEasterDay != null && this.cachedEasterDay.getYear() == year) {
                localDate2 = localDate3 = this.cachedEasterDay;
            } else {
                int a = year % 19;
                int b = year / 100;
                int c = year % 100;
                int d = b / 4;
                int e = b % 4;
                int f = (b + 8) / 25;
                int g = (b - f + 1) / 3;
                int h = (19 * a + b - d - g + 15) % 30;
                int i = c / 4;
                int k = c % 4;
                int l = (32 + 2 * e + 2 * i - h - k) % 7;
                int m = (a + 11 * h + 22 * l) / 451;
                int n2 = h + l - 7 * m + 114;
                int month = n2 / 31;
                int day = n2 % 31 + 1;
                localDate2 = localDate3 = (this.cachedEasterDay = LocalDate.of(year, month, day));
            }
            LocalDate localDate4 = localDate = localDate2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)localDate);
            return localDate3;
        }

        static {
            EasterCalculator.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkingDaysToDaysConverter.java", EasterCalculator.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getEasterSunday", "pro.taskana.common.api.WorkingDaysToDaysConverter$EasterCalculator", "int", "year", "", "java.time.LocalDate"), 189);
        }
    }

    private static final class ZeroDirection
    extends Enum<ZeroDirection> {
        public static final /* enum */ ZeroDirection SUB_DAYS;
        public static final /* enum */ ZeroDirection ADD_DAYS;
        private final int direction;
        private static final /* synthetic */ ZeroDirection[] ENUM$VALUES;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        static {
            ZeroDirection.ajc$preClinit();
            SUB_DAYS = new ZeroDirection(-1);
            ADD_DAYS = new ZeroDirection(1);
            ENUM$VALUES = new ZeroDirection[]{SUB_DAYS, ADD_DAYS};
        }

        private ZeroDirection(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            int n;
            int n2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            int n3 = n2 = (n = this.direction);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.intObject((int)n2));
            return n;
        }

        public static ZeroDirection[] values() {
            ZeroDirection[] zeroDirectionArray;
            ZeroDirection[] zeroDirectionArray2;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZeroDirection[] zeroDirectionArray3 = ENUM$VALUES;
            int n = zeroDirectionArray3.length;
            ZeroDirection[] zeroDirectionArray4 = new ZeroDirection[n];
            System.arraycopy(ENUM$VALUES, 0, zeroDirectionArray4, 0, n);
            ZeroDirection[] zeroDirectionArray5 = zeroDirectionArray2 = (zeroDirectionArray = zeroDirectionArray4);
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zeroDirectionArray2);
            return zeroDirectionArray;
        }

        public static ZeroDirection valueOf(String arg0) {
            ZeroDirection zeroDirection;
            ZeroDirection zeroDirection2;
            String string = arg0;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            ZeroDirection zeroDirection3 = zeroDirection2 = (zeroDirection = Enum.valueOf(ZeroDirection.class, arg0));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)zeroDirection2);
            return zeroDirection;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("WorkingDaysToDaysConverter.java", ZeroDirection.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDirection", "pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection", "", "", "", "int"), 175);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection", "", "", "", "[Lpro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection;"), 1);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection", "java.lang.String", "arg0", "", "pro.taskana.common.api.WorkingDaysToDaysConverter$ZeroDirection"), 1);
        }
    }
}

