/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.UnsupportedDatabaseException;
import pro.taskana.common.internal.logging.LoggingAspect;

public final class DB
extends Enum<DB> {
    public static final /* enum */ DB H2;
    public static final /* enum */ DB DB2;
    public static final /* enum */ DB ORACLE;
    public static final /* enum */ DB POSTGRES;
    public final String dbProductName;
    public final String dbProductId;
    private static final /* synthetic */ DB[] ENUM$VALUES;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        DB.ajc$preClinit();
        H2 = new DB("H2", "h2");
        DB2 = new DB("DB2", "db2");
        ORACLE = new DB("Oracle", "oracle");
        POSTGRES = new DB("PostgreSQL", "postgres");
        ENUM$VALUES = new DB[]{H2, DB2, ORACLE, POSTGRES};
    }

    private DB(String dbProductName, String dbProductId) {
        this.dbProductName = dbProductName;
        this.dbProductId = dbProductId;
    }

    public static boolean isH2(String dbProductId) {
        boolean bl;
        boolean bl2;
        String string = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = DB.H2.dbProductId.equals(dbProductId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public static boolean isDb2(String dbProductId) {
        boolean bl;
        boolean bl2;
        String string = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = DB.DB2.dbProductId.equals(dbProductId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public static boolean isPostgres(String dbProductId) {
        boolean bl;
        boolean bl2;
        String string = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = DB.POSTGRES.dbProductId.equals(dbProductId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public static boolean isOracle(String dbProductId) {
        boolean bl;
        boolean bl2;
        String string = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = DB.ORACLE.dbProductId.equals(dbProductId));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public static boolean isOracleDb(String dbProductName) {
        boolean bl;
        boolean bl2;
        String string = dbProductName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean bl3 = bl2 = (bl = DB.ORACLE.dbProductName.equals(dbProductName));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    public static String getDatabaseProductName(Connection connection) throws SQLException {
        String string;
        String string2;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = connection.getMetaData().getDatabaseProductName());
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static DB getDbForId(String databaseId) {
        DB dB;
        DB dB2;
        DB dB3;
        String string = databaseId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (DB.isH2(databaseId)) {
            dB2 = dB3 = H2;
        } else if (DB.isDb2(databaseId)) {
            dB2 = dB3 = DB2;
        } else if (DB.isOracle(databaseId)) {
            dB2 = dB3 = ORACLE;
        } else if (DB.isPostgres(databaseId)) {
            dB2 = dB3 = POSTGRES;
        } else {
            throw new SystemException("Unknown database id: " + databaseId);
        }
        DB dB4 = dB = dB2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB);
        return dB3;
    }

    public static String getDatabaseProductId(Connection connection) throws SQLException {
        String string;
        String string2;
        String string3;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String dbProductName = DB.getDatabaseProductName(connection);
        if (dbProductName.contains(DB.H2.dbProductName)) {
            string2 = string3 = DB.H2.dbProductId;
        } else if (dbProductName.contains(DB.DB2.dbProductName)) {
            string2 = string3 = DB.DB2.dbProductId;
        } else if (dbProductName.contains(DB.ORACLE.dbProductName)) {
            string2 = string3 = DB.ORACLE.dbProductId;
        } else if (DB.POSTGRES.dbProductName.equals(dbProductName)) {
            string2 = string3 = DB.POSTGRES.dbProductId;
        } else {
            throw new UnsupportedDatabaseException(dbProductName);
        }
        String string4 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    public String getProductId() {
        String string;
        String string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this));
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String string3 = string2 = (string = this.dbProductId);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string2);
        return string;
    }

    public static DB[] values() {
        DB[] dBArray;
        DB[] dBArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DB[] dBArray3 = ENUM$VALUES;
        int n = dBArray3.length;
        DB[] dBArray4 = new DB[n];
        System.arraycopy(ENUM$VALUES, 0, dBArray4, 0, n);
        DB[] dBArray5 = dBArray2 = (dBArray = dBArray4);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dBArray2);
        return dBArray;
    }

    public static DB valueOf(String arg0) {
        DB dB;
        DB dB2;
        String string = arg0;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DB dB3 = dB2 = (dB = Enum.valueOf(DB.class, arg0));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DB.java", DB.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isH2", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductId", "", "boolean"), 24);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isDb2", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductId", "", "boolean"), 28);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "arg0", "", "pro.taskana.common.internal.configuration.DB"), 1);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isPostgres", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductId", "", "boolean"), 32);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isOracle", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductId", "", "boolean"), 36);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isOracleDb", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductName", "", "boolean"), 40);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDatabaseProductName", "pro.taskana.common.internal.configuration.DB", "java.sql.Connection", "connection", "java.sql.SQLException", "java.lang.String"), 44);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDbForId", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "databaseId", "", "pro.taskana.common.internal.configuration.DB"), 48);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDatabaseProductId", "pro.taskana.common.internal.configuration.DB", "java.sql.Connection", "connection", "java.sql.SQLException", "java.lang.String"), 61);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProductId", "pro.taskana.common.internal.configuration.DB", "", "", "", "java.lang.String"), 76);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.common.internal.configuration.DB", "", "", "", "[Lpro.taskana.common.internal.configuration.DB;"), 1);
    }
}

