/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.CustomHoliday;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException;
import pro.taskana.common.internal.configuration.TaskanaProperty;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.Pair;
import pro.taskana.common.internal.util.ReflectionUtil;

public class TaskanaConfigurationInitializer {
    private static final Logger LOGGER;
    private static final String TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR = ".";
    private static final String TASKANA_CLASSIFICATION_CATEGORIES_PROPERTY = "taskana.classification.categories";
    private static final Map<Class<?>, PropertyParser<?>> PROPERTY_INITIALIZER_BY_CLASS;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        TaskanaConfigurationInitializer.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TaskanaConfigurationInitializer.class);
        PROPERTY_INITIALIZER_BY_CLASS = new HashMap();
        PROPERTY_INITIALIZER_BY_CLASS.put(Integer.class, new IntegerPropertyParser());
        PROPERTY_INITIALIZER_BY_CLASS.put(Boolean.class, new BooleanPropertyParser());
        PROPERTY_INITIALIZER_BY_CLASS.put(String.class, new StringPropertyParser());
        PROPERTY_INITIALIZER_BY_CLASS.put(Duration.class, new DurationPropertyParser());
        PROPERTY_INITIALIZER_BY_CLASS.put(Instant.class, new InstantPropertyParser());
        PROPERTY_INITIALIZER_BY_CLASS.put(List.class, new ListPropertyParser());
    }

    private TaskanaConfigurationInitializer() {
        throw new IllegalStateException("utility class");
    }

    public static void configureAnnotatedFields(Object instance, String separator, Properties props) {
        Object object = instance;
        String string = separator;
        Properties properties = props;
        Object[] objectArray = new Object[]{object, string, properties};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<Field> fields = ReflectionUtil.retrieveAllFields(instance.getClass());
        for (Field field : fields) {
            Optional.ofNullable(field.getAnnotation(TaskanaProperty.class)).ifPresent(taskanaProperty -> {
                Class<?> type = ReflectionUtil.wrap(field.getType());
                PropertyParser<?> propertyParser = Optional.ofNullable(PROPERTY_INITIALIZER_BY_CLASS.get(type)).orElseThrow(() -> new SystemException("Unknown configuration type " + type));
                propertyParser.initialize(props, separator, field, (TaskanaProperty)taskanaProperty).ifPresent(value -> TaskanaConfigurationInitializer.setFieldValue(instance, field, value));
            });
        }
        Object var11_11 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var11_11);
    }

    public static Map<String, List<String>> configureClassificationCategoriesForType(Properties props, List<String> classificationTypes) {
        Map<String, List<String>> map;
        Map<String, List<String>> map2;
        Properties properties = props;
        List<String> list = classificationTypes;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)properties, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Function<String, List> getClassificationCategoriesForType = type -> TaskanaConfigurationInitializer.parseProperty(props, "taskana.classification.categories." + type.toLowerCase(), p -> TaskanaConfigurationInitializer.splitStringAndTrimElements(p, ",", String::toUpperCase)).orElseGet(ArrayList::new);
        Map<String, List<String>> map3 = map2 = (map = classificationTypes.stream().map(type -> Pair.of(type, (List)getClassificationCategoriesForType.apply((String)type))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    public static Map<TaskanaRole, Set<String>> configureRoles(String separator, Properties props, boolean shouldUseLowerCaseForAccessIds) {
        Map<TaskanaRole, Set<String>> map;
        Map<TaskanaRole, Set<String>> map2;
        String string = separator;
        Properties properties = props;
        boolean bl = shouldUseLowerCaseForAccessIds;
        Object[] objectArray = new Object[]{string, properties, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Function<TaskanaRole, Set> getAccessIdsForRole = role -> new HashSet<String>(TaskanaConfigurationInitializer.splitStringAndTrimElements(props.getProperty(role.getPropertyName().toLowerCase(), ""), separator, shouldUseLowerCaseForAccessIds ? String::toLowerCase : UnaryOperator.identity()));
        Map<TaskanaRole, Set<String>> map3 = map2 = (map = Arrays.stream(TaskanaRole.values()).map(role -> Pair.of(role, (Set)getAccessIdsForRole.apply((TaskanaRole)((Object)role)))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, map2);
        return map;
    }

    static List<String> splitStringAndTrimElements(String str, String separator) {
        List<String> list;
        List<String> list2;
        String string = str;
        String string2 = separator;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)string, (Object)string2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = TaskanaConfigurationInitializer.splitStringAndTrimElements(str, separator, UnaryOperator.identity()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static List<String> splitStringAndTrimElements(String str, String separator, UnaryOperator<String> modifier) {
        List<String> list;
        List<String> list2;
        String string = str;
        String string2 = separator;
        UnaryOperator<String> unaryOperator = modifier;
        Object[] objectArray = new Object[]{string, string2, unaryOperator};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> list3 = list2 = (list = Arrays.stream(str.split(Pattern.quote(separator))).filter(Predicate.not(String::isEmpty)).map(String::trim).map(modifier).collect(Collectors.toList()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, list2);
        return list;
    }

    static CustomHoliday createCustomHolidayFromPropsEntry(String customHolidayEntry) throws WrongCustomHolidayFormatException {
        CustomHoliday customHoliday;
        String string = customHolidayEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        List<String> parts = TaskanaConfigurationInitializer.splitStringAndTrimElements(customHolidayEntry, TASKANA_CUSTOM_HOLIDAY_DAY_MONTH_SEPARATOR);
        if (parts.size() != 2) {
            throw new WrongCustomHolidayFormatException(customHolidayEntry);
        }
        CustomHoliday customHoliday2 = CustomHoliday.of(Integer.valueOf(parts.get(0)), Integer.valueOf(parts.get(1)));
        CustomHoliday customHoliday3 = customHoliday = customHoliday2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)customHoliday);
        return customHoliday2;
    }

    private static void setFieldValue(Object instance, Field field, Object value) {
        Object object = instance;
        Field field2 = field;
        Object object2 = value;
        Object[] objectArray = new Object[]{object, field2, object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SystemException("Property value " + value + " is invalid for field " + field.getName(), e);
        }
        Object var9_9 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var9_9);
    }

    private static <T> Optional<T> parseProperty(Properties props, String key, CheckedFunction<String, T, Exception> function) {
        Optional optional;
        Optional optional2;
        Optional optional3;
        JoinPoint joinPoint;
        block3: {
            block2: {
                Properties properties = props;
                String string = key;
                CheckedFunction<String, String, Exception> checkedFunction = function;
                Object[] objectArray = new Object[]{properties, string, checkedFunction};
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
                LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
                String property = props.getProperty(key, "");
                if (property.isEmpty()) break block2;
                try {
                    optional2 = optional3 = Optional.ofNullable(function.apply(property));
                }
                catch (Throwable t) {
                    LOGGER.warn("Could not parse property {} ({}). Using default. Exception: {}", new Object[]{key, property, t.getMessage()});
                }
                break block3;
            }
            optional2 = optional3 = Optional.empty();
        }
        Optional optional4 = optional = optional2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, optional);
        return optional3;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskanaConfigurationInitializer.java", TaskanaConfigurationInitializer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "configureAnnotatedFields", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.Object:java.lang.String:java.util.Properties", "instance:separator:props", "", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "configureClassificationCategoriesForType", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.util.Properties:java.util.List", "props:classificationTypes", "", "java.util.Map"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "configureRoles", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.String:java.util.Properties:boolean", "separator:props:shouldUseLowerCaseForAccessIds", "", "java.util.Map"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "splitStringAndTrimElements", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.String:java.lang.String", "str:separator", "", "java.util.List"), 106);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "splitStringAndTrimElements", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.String:java.lang.String:java.util.function.UnaryOperator", "str:separator:modifier", "", "java.util.List"), 110);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "createCustomHolidayFromPropsEntry", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.String", "customHolidayEntry", "pro.taskana.common.api.exceptions.WrongCustomHolidayFormatException", "pro.taskana.common.api.CustomHoliday"), 119);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "setFieldValue", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.lang.Object:java.lang.reflect.Field:java.lang.Object", "instance:field:value", "", "void"), 129);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "parseProperty", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer", "java.util.Properties:java.lang.String:pro.taskana.common.internal.util.CheckedFunction", "props:key:function", "", "java.util.Optional"), 139);
    }

    static class BooleanPropertyParser
    implements PropertyParser<Boolean> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        BooleanPropertyParser() {
        }

        @Override
        public Optional<Boolean> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Optional optional3 = optional2 = (optional = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), Boolean::parseBoolean));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
            return optional;
        }

        static {
            BooleanPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", BooleanPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$BooleanPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 249);
        }
    }

    static class DurationPropertyParser
    implements PropertyParser<Duration> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        DurationPropertyParser() {
        }

        @Override
        public Optional<Duration> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Optional optional3 = optional2 = (optional = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), Duration::parse));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
            return optional;
        }

        static {
            DurationPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", DurationPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$DurationPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 225);
        }
    }

    static class InstantPropertyParser
    implements PropertyParser<Instant> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        InstantPropertyParser() {
        }

        @Override
        public Optional<Instant> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Optional optional3 = optional2 = (optional = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), Instant::parse));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
            return optional;
        }

        static {
            InstantPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", InstantPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$InstantPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 217);
        }
    }

    static class IntegerPropertyParser
    implements PropertyParser<Integer> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        IntegerPropertyParser() {
        }

        @Override
        public Optional<Integer> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Optional optional3 = optional2 = (optional = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), Integer::parseInt));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
            return optional;
        }

        static {
            IntegerPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", IntegerPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$IntegerPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 241);
        }
    }

    static class ListPropertyParser
    implements PropertyParser<List<?>> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        ListPropertyParser() {
        }

        @Override
        public Optional<List<?>> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Optional optional3;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            if (!List.class.isAssignableFrom(field.getType())) {
                throw new SystemException(String.format("Cannot initialize field '%s' because field type '%s' is not a List", field, field.getType()));
            }
            Class genericClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (genericClass.isEnum()) {
                Map enumConstants = Arrays.stream(genericClass.getEnumConstants()).collect(Collectors.toMap(e -> e.toString().toLowerCase(), Function.identity()));
                CheckedFunction parseFunction = s -> TaskanaConfigurationInitializer.splitStringAndTrimElements(s, separator).stream().map(String::toLowerCase).map(enumConstants::get).filter(Objects::nonNull).collect(Collectors.toList());
                optional2 = optional3 = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), parseFunction);
            } else if (CustomHoliday.class.isAssignableFrom(genericClass)) {
                CheckedFunction parseFunction = s -> TaskanaConfigurationInitializer.splitStringAndTrimElements(s, separator).stream().map(str -> {
                    try {
                        return TaskanaConfigurationInitializer.createCustomHolidayFromPropsEntry(str);
                    }
                    catch (WrongCustomHolidayFormatException e) {
                        LOGGER.warn(e.getMessage());
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                optional2 = optional3 = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), parseFunction);
            } else if (String.class.isAssignableFrom(genericClass)) {
                CheckedFunction parseListFunction = p -> TaskanaConfigurationInitializer.splitStringAndTrimElements(p, ",", String::toUpperCase);
                optional2 = optional3 = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), parseListFunction);
            } else {
                throw new SystemException(String.format("Cannot initialize field '%s' because field type '%s' is unknown", field, genericClass));
            }
            Optional optional4 = optional = optional2;
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional);
            return optional3;
        }

        static {
            ListPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", ListPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$ListPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 163);
        }
    }

    static interface PropertyParser<T> {
        public Optional<T> initialize(Properties var1, String var2, Field var3, TaskanaProperty var4);
    }

    static class StringPropertyParser
    implements PropertyParser<String> {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        StringPropertyParser() {
        }

        @Override
        public Optional<String> initialize(Properties properties, String separator, Field field, TaskanaProperty taskanaProperty) {
            Optional optional;
            Optional optional2;
            Properties properties2 = properties;
            String string = separator;
            Field field2 = field;
            TaskanaProperty taskanaProperty2 = taskanaProperty;
            Object[] objectArray = new Object[]{properties2, string, field2, taskanaProperty2};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            Optional optional3 = optional2 = (optional = TaskanaConfigurationInitializer.parseProperty(properties, taskanaProperty.value(), String::new));
            LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)optional2);
            return optional;
        }

        static {
            StringPropertyParser.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("TaskanaConfigurationInitializer.java", StringPropertyParser.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.common.internal.configuration.TaskanaConfigurationInitializer$StringPropertyParser", "java.util.Properties:java.lang.String:java.lang.reflect.Field:pro.taskana.common.internal.configuration.TaskanaProperty", "properties:separator:field:taskanaProperty", "", "java.util.Optional"), 233);
        }
    }
}

