/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.internal.configuration.DB;
import pro.taskana.common.internal.logging.LoggingAspect;

public class DbSchemaCreator {
    private static final Logger LOGGER;
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA_H2 = "/sql/h2/taskana-schema-h2.sql";
    private static final String DB_SCHEMA_DETECTION_H2 = "/sql/h2/schema-detection-h2.sql";
    private static final String DB_SCHEMA_DB2 = "/sql/db2/taskana-schema-db2.sql";
    private static final String DB_SCHEMA_DETECTION_DB2 = "/sql/db2/schema-detection-db2.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/postgres/taskana-schema-postgres.sql";
    private static final String DB_SCHEMA_DETECTION_POSTGRES = "/sql/postgres/schema-detection-postgres.sql";
    private final String schemaName;
    private final StringWriter outWriter = new StringWriter();
    private final PrintWriter logWriter = new PrintWriter(this.outWriter);
    private final StringWriter errorWriter = new StringWriter();
    private final PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);
    private DataSource dataSource;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        DbSchemaCreator.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    }

    public DbSchemaCreator(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.schemaName = schema;
    }

    public void run() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        Throwable throwable = null;
        Object var2_4 = null;
        try (Connection connection = this.dataSource.getConnection();){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using database of type {} with url '{}'", (Object)connection.getMetaData().getDatabaseProductName(), (Object)connection.getMetaData().getURL());
            }
            ScriptRunner runner = this.getScriptRunnerInstance(connection);
            String dbProductId = DB.getDatabaseProductId(connection.getMetaData().getDatabaseProductName());
            if (!this.isSchemaPreexisting(connection, dbProductId)) {
                String scriptPath = DbSchemaCreator.selectDbScriptFileName(dbProductId);
                InputStream resourceAsStream = DbSchemaCreator.class.getResourceAsStream(scriptPath);
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
                runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.outWriter.toString());
        }
        if (!this.errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(this.errorWriter.toString());
        }
        Object var10_12 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var10_12);
    }

    /*
     * Exception decompiling
     */
    public boolean isValidSchemaVersion(String expectedMinVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataSource getDataSource() {
        DataSource dataSource;
        DataSource dataSource2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DataSource dataSource3 = dataSource2 = (dataSource = this.dataSource);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dataSource2);
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        DataSource dataSource2 = dataSource;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)dataSource2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.dataSource = dataSource;
        Object var4_4 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var4_4);
    }

    private static String selectDbScriptFileName(String dbProductId) {
        String string;
        String string2;
        String string3;
        String string4 = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        switch (DB.getDbForId(dbProductId)) {
            case DB2: {
                string2 = string3 = DB_SCHEMA_DB2;
                break;
            }
            case POSTGRES: {
                string2 = string3 = DB_SCHEMA_POSTGRES;
                break;
            }
            default: {
                string2 = string3 = DB_SCHEMA_H2;
            }
        }
        String string5 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    private static String selectDbSchemaDetectionScript(String dbProductId) {
        String string;
        String string2;
        String string3;
        String string4 = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string4);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        switch (DB.getDbForId(dbProductId)) {
            case DB2: {
                string2 = string3 = DB_SCHEMA_DETECTION_DB2;
                break;
            }
            case POSTGRES: {
                string2 = string3 = DB_SCHEMA_DETECTION_POSTGRES;
                break;
            }
            default: {
                string2 = string3 = DB_SCHEMA_DETECTION_H2;
            }
        }
        String string5 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    private ScriptRunner getScriptRunnerInstance(Connection connection) {
        ScriptRunner scriptRunner;
        ScriptRunner scriptRunner2;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        ScriptRunner scriptRunner3 = scriptRunner2 = (scriptRunner = runner);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)scriptRunner2);
        return scriptRunner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSchemaPreexisting(Connection connection, String dbProductId) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        JoinPoint joinPoint;
        block25: {
            block24: {
                Connection connection2 = connection;
                String string = dbProductId;
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)connection2, (Object)string);
                LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
                ScriptRunner runner = this.getScriptRunnerInstance(connection);
                runner.setErrorLogWriter(this.errorLogWriter);
                String scriptPath = DbSchemaCreator.selectDbSchemaDetectionScript(dbProductId);
                try {
                    Throwable throwable = null;
                    Object var6_10 = null;
                    try {
                        InputStream resource = DbSchemaCreator.class.getResourceAsStream(scriptPath);
                        try {
                            block23: {
                                InputStreamReader inputReader = new InputStreamReader(resource, StandardCharsets.UTF_8);
                                try {
                                    try (BufferedReader reader = new BufferedReader(inputReader);){
                                        runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
                                    }
                                    if (inputReader == null) break block23;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (inputReader == null) throw throwable;
                                    inputReader.close();
                                    throw throwable;
                                }
                                inputReader.close();
                            }
                            if (resource == null) break block24;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (resource == null) throw throwable;
                            resource.close();
                            throw throwable;
                        }
                        resource.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                            throw throwable;
                        }
                        if (throwable == throwable4) throw throwable;
                        throwable.addSuppressed(throwable4);
                        throw throwable;
                    }
                }
                catch (IOException | RuntimeSqlException throwable) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Schema does not exist.");
                        if (!this.errorWriter.toString().trim().isEmpty()) {
                            LOGGER.debug(this.errorWriter.toString());
                        }
                    }
                    bl2 = bl3 = false;
                    break block25;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Schema does exist.");
            }
            bl2 = bl3 = true;
        }
        boolean bl4 = bl = bl2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl));
        return bl3;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader) {
        StringReader stringReader;
        StringReader stringReader2;
        BufferedReader bufferedReader = reader;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)bufferedReader);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        StringBuilder content = new StringBuilder();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replace("%schemaName%", this.schemaName)).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            LOGGER.error("SchemaName sql parsing failed for schemaName {}", (Object)this.schemaName, (Object)e);
        }
        StringReader stringReader3 = stringReader2 = (stringReader = new StringReader(content.toString()));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)stringReader2);
        return stringReader;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DbSchemaCreator.java", DbSchemaCreator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "pro.taskana.common.internal.configuration.DbSchemaCreator", "", "", "java.sql.SQLException", "void"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isValidSchemaVersion", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.lang.String", "expectedMinVersion", "", "boolean"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDataSource", "pro.taskana.common.internal.configuration.DbSchemaCreator", "", "", "", "javax.sql.DataSource"), 123);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDataSource", "pro.taskana.common.internal.configuration.DbSchemaCreator", "javax.sql.DataSource", "dataSource", "", "void"), 127);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "selectDbScriptFileName", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.lang.String", "dbProductId", "", "java.lang.String"), 131);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "selectDbSchemaDetectionScript", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.lang.String", "dbProductId", "", "java.lang.String"), 143);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getScriptRunnerInstance", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.sql.Connection", "connection", "", "org.apache.ibatis.jdbc.ScriptRunner"), 155);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isSchemaPreexisting", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.sql.Connection:java.lang.String", "connection:dbProductId", "", "boolean"), 163);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSqlSchemaNameParsed", "pro.taskana.common.internal.configuration.DbSchemaCreator", "java.io.BufferedReader", "reader", "", "java.io.StringReader"), 187);
    }
}

