/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.UnsupportedDatabaseException;
import pro.taskana.common.internal.logging.LoggingAspect;

public final class DB
extends Enum<DB> {
    public static final /* enum */ DB H2;
    public static final /* enum */ DB DB2;
    public static final /* enum */ DB ORACLE;
    public static final /* enum */ DB POSTGRES;
    public final String dbProductName;
    public final String dbProductId;
    public final String detectionScript;
    public final String schemaScript;
    private static final /* synthetic */ DB[] ENUM$VALUES;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        DB.ajc$preClinit();
        H2 = new DB("H2", "h2", "/sql/h2/schema-detection-h2.sql", "/sql/h2/taskana-schema-h2.sql");
        DB2 = new DB("DB2", "db2", "/sql/db2/schema-detection-db2.sql", "/sql/db2/taskana-schema-db2.sql");
        ORACLE = new DB("Oracle", "oracle", "/sql/oracle/schema-detection-oracle.sql", "/sql/oracle/taskana-schema-oracle.sql");
        POSTGRES = new DB("PostgreSQL", "postgres", "/sql/postgres/schema-detection-postgres.sql", "/sql/postgres/taskana-schema-postgres.sql");
        ENUM$VALUES = new DB[]{H2, DB2, ORACLE, POSTGRES};
    }

    private DB(String dbProductName, String dbProductId, String detectionScript, String schemaScript) {
        this.dbProductName = dbProductName;
        this.dbProductId = dbProductId;
        this.detectionScript = detectionScript;
        this.schemaScript = schemaScript;
    }

    public static DB getDB(String dbProductId) {
        DB dB;
        DB dB2;
        String string = dbProductId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DB dB3 = dB2 = (dB = Arrays.stream(DB.values()).filter(db -> dbProductId.contains(db.dbProductId)).findFirst().orElseThrow(() -> new UnsupportedDatabaseException(dbProductId)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    public static DB getDB(Connection connection) {
        DB dB;
        DB dB2;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        String dbProductName = DB.getDatabaseProductName(connection);
        DB dB3 = dB2 = (dB = Arrays.stream(DB.values()).filter(db -> dbProductName.contains(db.dbProductName)).findFirst().orElseThrow(() -> new UnsupportedDatabaseException(dbProductName)));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    private static String getDatabaseProductName(Connection connection) {
        String string;
        String string2;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)connection2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            string2 = connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new SystemException("Could not extract meta data from connection", e);
        }
        String string3 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string2;
    }

    public static DB[] values() {
        DB[] dBArray;
        DB[] dBArray2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DB[] dBArray3 = ENUM$VALUES;
        int n = dBArray3.length;
        DB[] dBArray4 = new DB[n];
        System.arraycopy(ENUM$VALUES, 0, dBArray4, 0, n);
        DB[] dBArray5 = dBArray2 = (dBArray = dBArray4);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dBArray2);
        return dBArray;
    }

    public static DB valueOf(String arg0) {
        DB dB;
        DB dB2;
        String string = arg0;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        DB dB3 = dB2 = (dB = Enum.valueOf(DB.class, arg0));
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)dB2);
        return dB;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DB.java", DB.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDB", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "dbProductId", "", "pro.taskana.common.internal.configuration.DB"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDB", "pro.taskana.common.internal.configuration.DB", "java.sql.Connection", "connection", "", "pro.taskana.common.internal.configuration.DB"), 43);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getDatabaseProductName", "pro.taskana.common.internal.configuration.DB", "java.sql.Connection", "connection", "", "java.lang.String"), 51);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "pro.taskana.common.internal.configuration.DB", "", "", "", "[Lpro.taskana.common.internal.configuration.DB;"), 1);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "pro.taskana.common.internal.configuration.DB", "java.lang.String", "arg0", "", "pro.taskana.common.internal.configuration.DB"), 1);
    }
}

