/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONObject;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.common.internal.util.CheckedFunction;
import pro.taskana.common.internal.util.ReflectionUtil;
import pro.taskana.common.internal.util.Triplet;

public class ObjectAttributeChangeDetector {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    private ObjectAttributeChangeDetector() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> String determineChangesInAttributes(T oldObject, T newObject) {
        String string;
        String string2;
        String string3;
        Object t2 = oldObject;
        Object t3 = newObject;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, t2, t3);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldObject == null || newObject == null) {
            throw new SystemException("Null was provided as a parameter. Please provide two objects of the same type");
        }
        Class<?> objectClass = oldObject.getClass();
        if (List.class.isAssignableFrom(objectClass)) {
            string2 = string3 = ObjectAttributeChangeDetector.compareLists(oldObject, newObject);
        } else {
            if (!oldObject.getClass().equals(newObject.getClass()) && !oldObject.getClass().isAssignableFrom(newObject.getClass())) {
                throw new SystemException(String.format("The classes differ between the oldObject(%s) and newObject(%s). In order to detect changes properly they should not differ.", oldObject.getClass().getName(), newObject.getClass().getName()));
            }
            List<JSONObject> changedAttributes = ReflectionUtil.retrieveAllFields(objectClass).stream().peek(field -> field.setAccessible(true)).filter(Predicate.not(field -> "customAttributes".equals(field.getName()))).map(CheckedFunction.wrap(field -> Triplet.of(field, field.get(oldObject), field.get(newObject)))).filter(Predicate.not(t -> Objects.equals(t.getMiddle(), t.getRight()))).map(t -> ObjectAttributeChangeDetector.generateChangedAttribute((Field)t.getLeft(), t.getMiddle(), t.getRight())).toList();
            JSONObject changes = new JSONObject();
            changes.put("changes", changedAttributes);
            string2 = string3 = changes.toString();
        }
        String string4 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    private static JSONObject generateChangedAttribute(Field field, Object oldValue, Object newValue) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        Field field2 = field;
        Object object = oldValue;
        Object object2 = newValue;
        Object[] objectArray = new Object[]{field2, object, object2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object[])objectArray);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        JSONObject changedAttribute = new JSONObject();
        changedAttribute.put("fieldName", (Object)field.getName());
        changedAttribute.put("oldValue", Optional.ofNullable(oldValue).map(JSONObject::wrap).orElse(""));
        changedAttribute.put("newValue", Optional.ofNullable(newValue).map(JSONObject::wrap).orElse(""));
        JSONObject jSONObject3 = jSONObject2 = (jSONObject = changedAttribute);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)jSONObject2);
        return jSONObject;
    }

    private static <T> String compareLists(T oldObject, T newObject) {
        String string;
        String string2;
        String string3;
        T t = oldObject;
        T t2 = newObject;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, t, t2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        if (oldObject.equals(newObject)) {
            string2 = string3 = "";
        } else {
            JSONObject changedAttribute = new JSONObject();
            changedAttribute.put("oldValue", oldObject);
            changedAttribute.put("newValue", newObject);
            JSONObject changes = new JSONObject();
            changes.put("changes", (Object)changedAttribute);
            string2 = string3 = changes.toString();
        }
        String string4 = string = string2;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)string);
        return string3;
    }

    static {
        ObjectAttributeChangeDetector.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ObjectAttributeChangeDetector.java", ObjectAttributeChangeDetector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "determineChangesInAttributes", "pro.taskana.common.internal.util.ObjectAttributeChangeDetector", "java.lang.Object:java.lang.Object", "oldObject:newObject", "", "java.lang.String"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "generateChangedAttribute", "pro.taskana.common.internal.util.ObjectAttributeChangeDetector", "java.lang.reflect.Field:java.lang.Object:java.lang.Object", "field:oldValue:newValue", "", "org.json.JSONObject"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "compareLists", "pro.taskana.common.internal.util.ObjectAttributeChangeDetector", "java.lang.Object:java.lang.Object", "oldObject:newObject", "", "java.lang.String"), 76);
    }
}

