/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;

public class ClassificationQueryImpl
implements ClassificationQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryClassification";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationQueryImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private String[] parentClassificationId;
    private String[] category;
    private String[] type;
    private String[] domain;
    private Boolean validInDomain;
    private Date[] created;
    private String[] name;
    private String description;
    private int[] priority;
    private String[] serviceLevel;
    private String[] customFields;
    private Date[] validFrom;
    private Date[] validUntil;

    public ClassificationQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public ClassificationQuery parentClassification(String ... parentClassificationId) {
        this.parentClassificationId = parentClassificationId;
        return this;
    }

    @Override
    public ClassificationQuery category(String ... category) {
        this.category = category;
        return this;
    }

    @Override
    public ClassificationQuery type(String ... type) {
        this.type = type;
        return this;
    }

    @Override
    public ClassificationQuery domain(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public ClassificationQuery validInDomain(Boolean validInDomain) {
        this.validInDomain = validInDomain;
        return this;
    }

    @Override
    public ClassificationQuery created(Date ... created) {
        this.created = created;
        return this;
    }

    @Override
    public ClassificationQuery name(String ... name) {
        this.name = name;
        return this;
    }

    @Override
    public ClassificationQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public ClassificationQuery priority(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public ClassificationQuery serviceLevel(String ... serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @Override
    public ClassificationQuery customFields(String ... customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    public ClassificationQuery validFrom(Date ... validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    @Override
    public ClassificationQuery validUntil(Date ... validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> list() {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> list(int offset, int limit) {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public Classification single() {
        Classification classification;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        Classification result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            classification = result = (Classification)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return classification;
    }

    public String[] getParentClassificationId() {
        return this.parentClassificationId;
    }

    public void setParentClassificationId(String[] parentClassificationId) {
        this.parentClassificationId = parentClassificationId;
    }

    public String[] getCategory() {
        return this.category;
    }

    public void setCategory(String[] category) {
        this.category = category;
    }

    public String[] getType() {
        return this.type;
    }

    public void setType(String[] type) {
        this.type = type;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public void setPriority(int[] priority) {
        this.priority = priority;
    }

    public String[] getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(String[] serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public void setDomain(String[] domain) {
        this.domain = domain;
    }

    public Boolean getValidInDomain() {
        return this.validInDomain;
    }

    public void setValidInDomain(Boolean validInDomain) {
        this.validInDomain = validInDomain;
    }

    public Date[] getCreated() {
        return this.created;
    }

    public void setCreated(Date[] created) {
        this.created = created;
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(String[] customFields) {
        this.customFields = customFields;
    }

    public Date[] getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date[] validFrom) {
        this.validFrom = validFrom;
    }

    public Date[] getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Date[] validUntil) {
        this.validUntil = validUntil;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClassificationQueryImpl [taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append(", parentClassificationId=");
        builder.append(Arrays.toString(this.parentClassificationId));
        builder.append(", category=");
        builder.append(Arrays.toString(this.category));
        builder.append(", type=");
        builder.append(Arrays.toString(this.type));
        builder.append(", domain=");
        builder.append(Arrays.toString(this.domain));
        builder.append(", validInDomain=");
        builder.append(this.validInDomain);
        builder.append(", created=");
        builder.append(Arrays.toString(this.created));
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", serviceLevel=");
        builder.append(Arrays.toString(this.serviceLevel));
        builder.append(", customFields=");
        builder.append(Arrays.toString(this.customFields));
        builder.append(", validFrom=");
        builder.append(Arrays.toString(this.validFrom));
        builder.append(", validUntil=");
        builder.append(Arrays.toString(this.validUntil));
        builder.append("]");
        return builder.toString();
    }
}

