/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.ClassificationQueryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.ClassificationImpl;
import pro.taskana.model.mappings.ClassificationMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    private static final String ID_PREFIX_CLASSIFICATION = "CLI";
    public static final Date CURRENT_CLASSIFICATIONS_VALID_UNTIL = Date.valueOf("9999-12-31");
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    private ClassificationMapper classificationMapper;
    private TaskanaEngineImpl taskanaEngineImpl;

    public ClassificationServiceImpl(TaskanaEngine taskanaEngine, ClassificationMapper classificationMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.classificationMapper = classificationMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> getClassificationTree() throws NotAuthorizedException {
        List<Classification> list;
        LOGGER.debug("entry to getClassificationTree()");
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            List<Classification> rootClassifications = this.createClassificationQuery().parentClassification("").validUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL).list();
            list = rootClassifications = this.populateChildClassifications(rootClassifications);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Classification> populateChildClassifications(List<Classification> classifications) throws NotAuthorizedException {
        try {
            this.taskanaEngineImpl.openConnection();
            ArrayList<Classification> children = new ArrayList<Classification>();
            for (Classification classification : classifications) {
                List<Classification> childClassifications = this.createClassificationQuery().parentClassification(classification.getId()).validUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL).list();
                children.addAll(this.populateChildClassifications(childClassifications));
            }
            classifications.addAll(children);
            List<Classification> list = classifications;
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClassification(Classification classification) throws ClassificationAlreadyExistException {
        block7: {
            LOGGER.debug("entry to createClassification(classification = {})", (Object)classification);
            try {
                Classification oldClassification;
                this.taskanaEngineImpl.openConnection();
                ClassificationImpl classificationImpl = (ClassificationImpl)classification;
                this.setDefaultValues(classificationImpl);
                try {
                    oldClassification = this.getClassification(classificationImpl.getId(), classificationImpl.getDomain());
                }
                catch (ClassificationNotFoundException e) {
                    oldClassification = null;
                }
                if (oldClassification == null) {
                    classificationImpl.setCreated(classificationImpl.getValidFrom());
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method createClassification created classification {}.", (Object)classification);
                    if (classificationImpl.getDomain() != "") {
                        classificationImpl.setDomain("");
                        this.classificationMapper.insert(classificationImpl);
                        LOGGER.debug("Method createClassification created classification {}.", (Object)classification);
                    }
                    break block7;
                }
                throw new ClassificationAlreadyExistException(classificationImpl.getId());
            }
            finally {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from addClassification()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClassification(Classification classification) {
        block7: {
            LOGGER.debug("entry to updateClassification(Classification = {})", (Object)classification);
            try {
                this.taskanaEngineImpl.openConnection();
                ClassificationImpl classificationImpl = (ClassificationImpl)classification;
                this.setDefaultValues(classificationImpl);
                ClassificationImpl oldClassification = null;
                try {
                    oldClassification = (ClassificationImpl)this.getClassification(classificationImpl.getId(), classificationImpl.getDomain());
                    LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classificationImpl);
                    if (oldClassification == null) {
                        throw new ClassificationNotFoundException("Classification not found. ID: " + classificationImpl.getId());
                    }
                    if (!oldClassification.getDomain().equals(classificationImpl.getDomain())) {
                        classificationImpl.setCreated(Date.valueOf(LocalDate.now()));
                        this.classificationMapper.insert(classificationImpl);
                        LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classification);
                        break block7;
                    }
                    oldClassification.setValidUntil(Date.valueOf(LocalDate.now().minusDays(1L)));
                    this.classificationMapper.update(oldClassification);
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method updateClassification() updated old classification {} and inserted new {}.", (Object)oldClassification, (Object)classificationImpl);
                }
                catch (ClassificationNotFoundException e) {
                    classificationImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
                    classificationImpl.setCreated(Date.valueOf(LocalDate.now()));
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classificationImpl);
                }
            }
            finally {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from updateClassification().");
            }
        }
    }

    private void setDefaultValues(ClassificationImpl classification) {
        classification.setValidFrom(Date.valueOf(LocalDate.now()));
        classification.setValidUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL);
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() != null) {
            try {
                Duration.parse(classification.getServiceLevel());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid duration. Please use the format defined by ISO 8601");
            }
        }
        if (classification.getId() == null) {
            classification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
        }
        if (classification.getParentClassificationId() == classification.getId()) {
            throw new IllegalArgumentException("A classification can't be a parent to itself");
        }
        if (classification.getParentClassificationId() == null) {
            classification.setParentClassificationId("");
        }
        if (classification.getDomain() == null) {
            classification.setDomain("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> getAllClassificationsWithId(String id, String domain) {
        ArrayList<Classification> arrayList;
        LOGGER.debug("entry to getAllClassificationsWithId(id = {}, domain = {})", (Object)id, (Object)domain);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            List<ClassificationImpl> classifications = this.classificationMapper.getAllClassificationsWithId(id, domain);
            ArrayList<Classification> results = new ArrayList<Classification>();
            classifications.stream().forEach(c -> results.add((Classification)c));
            arrayList = results;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getAllClassificationsWithId(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getAllClassificationsWithId(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String id, String domain) throws ClassificationNotFoundException {
        ClassificationImpl classificationImpl;
        if (id == null) {
            throw new ClassificationNotFoundException(null);
        }
        LOGGER.debug("entry to getClassification(id = {}, domain = {})", (Object)id, (Object)domain);
        ClassificationImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.classificationMapper.findByIdAndDomain(id, domain, CURRENT_CLASSIFICATIONS_VALID_UNTIL);
            if (result == null) {
                result = this.classificationMapper.findByIdAndDomain(id, "", CURRENT_CLASSIFICATIONS_VALID_UNTIL);
            }
            if (result == null) {
                throw new ClassificationNotFoundException(id);
            }
            classificationImpl = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        return classificationImpl;
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        return new ClassificationQueryImpl(this.taskanaEngineImpl);
    }

    @Override
    public Classification newClassification() {
        Date date = Date.valueOf(LocalDate.now());
        ClassificationImpl classification = new ClassificationImpl();
        this.setDefaultValues(classification);
        classification.setCreated(date);
        return classification;
    }
}

