/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.ObjectReference;

public class ObjectReferenceQueryImpl
implements ObjectReferenceQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryObjectReference";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectReferenceQueryImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private String[] company;
    private String[] system;
    private String[] systemInstance;
    private String[] type;
    private String[] value;

    public ObjectReferenceQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public ObjectReferenceQuery company(String ... companies) {
        this.company = companies;
        return this;
    }

    @Override
    public ObjectReferenceQuery system(String ... systems) {
        this.system = systems;
        return this;
    }

    @Override
    public ObjectReferenceQuery systemInstance(String ... systemInstances) {
        this.systemInstance = systemInstances;
        return this;
    }

    @Override
    public ObjectReferenceQuery type(String ... types) {
        this.type = types;
        return this;
    }

    @Override
    public ObjectReferenceQuery value(String ... values) {
        this.value = values;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectReference> list() {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectReference> list(int offset, int limit) {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public ObjectReference single() {
        ObjectReference objectReference;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        ObjectReference result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            objectReference = result = (ObjectReference)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return objectReference;
    }

    public String[] getCompany() {
        return this.company;
    }

    public void setCompany(String[] company) {
        this.company = company;
    }

    public String[] getSystem() {
        return this.system;
    }

    public void setSystem(String[] system) {
        this.system = system;
    }

    public String[] getSystemInstance() {
        return this.systemInstance;
    }

    public void setSystemInstance(String[] systemInstance) {
        this.systemInstance = systemInstance;
    }

    public String[] getType() {
        return this.type;
    }

    public void setType(String[] type) {
        this.type = type;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ObjectReferenceQueryImpl [taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append(", company=");
        builder.append(Arrays.toString(this.company));
        builder.append(", system=");
        builder.append(Arrays.toString(this.system));
        builder.append(", systemInstance=");
        builder.append(Arrays.toString(this.systemInstance));
        builder.append(", type=");
        builder.append(Arrays.toString(this.type));
        builder.append(", value=");
        builder.append(Arrays.toString(this.value));
        builder.append("]");
        return builder.toString();
    }
}

