/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskQueryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.DueWorkbasketCounter;
import pro.taskana.model.ObjectReference;
import pro.taskana.model.Task;
import pro.taskana.model.TaskState;
import pro.taskana.model.TaskStateCounter;
import pro.taskana.model.TaskSummary;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.ObjectReferenceMapper;
import pro.taskana.model.mappings.TaskMapper;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final String ID_PREFIX_OBJECTR_EFERENCE = "ORI";
    private static final String ID_PREFIX_TASK = "TKI";
    private static final String ID_PREFIX_BUSINESS_PROCESS = "BPI";
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMapper taskMapper;
    private ObjectReferenceMapper objectReferenceMapper;

    public TaskServiceImpl(TaskanaEngine taskanaEngine, TaskMapper taskMapper, ObjectReferenceMapper objectReferenceMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMapper = taskMapper;
        this.objectReferenceMapper = objectReferenceMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task claim(String id, String userName) throws TaskNotFoundException {
        Task task;
        block4: {
            LOGGER.debug("entry to claim(id = {}, userName = {})", (Object)id, (Object)userName);
            task = null;
            try {
                this.taskanaEngineImpl.openConnection();
                task = this.taskMapper.findById(id);
                if (task != null) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    task.setOwner(userName);
                    task.setModified(now);
                    task.setClaimed(now);
                    task.setState(TaskState.CLAIMED);
                    this.taskMapper.update(task);
                    LOGGER.debug("Method claim() claimed task '{}' for user '{}'.", (Object)id, (Object)userName);
                    break block4;
                }
                LOGGER.warn("Method claim() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
                throw new TaskNotFoundException(id);
            }
            finally {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from claim()");
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task complete(String id) throws TaskNotFoundException {
        Task task;
        block4: {
            LOGGER.debug("entry to complete(id = {})", (Object)id);
            task = null;
            try {
                this.taskanaEngineImpl.openConnection();
                task = this.taskMapper.findById(id);
                if (task != null) {
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    task.setCompleted(now);
                    task.setModified(now);
                    task.setState(TaskState.COMPLETED);
                    this.taskMapper.update(task);
                    LOGGER.debug("Method complete() completed Task '{}'.", (Object)id);
                    break block4;
                }
                LOGGER.warn("Method complete() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
                throw new TaskNotFoundException(id);
            }
            finally {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from complete()");
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task task) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException {
        LOGGER.debug("entry to createTask(task = {})", (Object)task);
        try {
            this.taskanaEngineImpl.openConnection();
            this.taskanaEngine.getWorkbasketService().getWorkbasket(task.getWorkbasketId());
            this.taskanaEngine.getWorkbasketService().checkAuthorization(task.getWorkbasketId(), WorkbasketAuthorization.APPEND);
            Classification classification = task.getClassification();
            if (classification == null) {
                throw new ClassificationNotFoundException(null);
            }
            this.taskanaEngine.getClassificationService().getClassification(classification.getId(), "");
            this.standardSettings(task);
            this.taskMapper.insert(task);
            LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
            Task task2 = task;
            return task2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createTask(task = {})");
        }
    }

    @Override
    public Task getTaskById(String id) throws TaskNotFoundException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.taskMapper.findById(id);
            if (result != null) {
                Task task = result;
                return task;
            }
            LOGGER.warn("Method getTaskById() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
            throw new TaskNotFoundException(id);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStateCounter> getTaskCountForState(List<TaskState> states) {
        List<TaskStateCounter> list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountForState(states = {})", (Object)LoggerUtils.listToString(states));
        }
        List<TaskStateCounter> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskMapper.getTaskCountForState(states);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getTaskCountForState(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getTaskCountForState(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTaskCountForWorkbasketByDaysInPastAndState(String workbasketId, long daysInPast, List<TaskState> states) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountForWorkbasketByDaysInPastAndState(workbasketId {}, daysInPast={}, states = {})", new Object[]{workbasketId, daysInPast, LoggerUtils.listToString(states)});
        }
        long result = -1L;
        try {
            this.taskanaEngineImpl.openConnection();
            LocalDate time = LocalDate.now();
            time = time.minusDays(daysInPast);
            Date fromDate = Date.valueOf(time);
            long l = result = this.taskMapper.getTaskCountForWorkbasketByDaysInPastAndState(workbasketId, fromDate, states);
            return l;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskCountForWorkbasketByDaysInPastAndState(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException {
        Task task;
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketId = {})", (Object)taskId, (Object)destinationWorkbasketId);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            Task task2 = this.getTaskById(taskId);
            this.taskanaEngine.getWorkbasketService().checkAuthorization(destinationWorkbasketId, WorkbasketAuthorization.APPEND);
            this.taskanaEngine.getWorkbasketService().checkAuthorization(task2.getWorkbasketId(), WorkbasketAuthorization.TRANSFER);
            if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
                this.taskanaEngine.getWorkbasketService().getWorkbasket(destinationWorkbasketId);
            }
            task2.setRead(false);
            task2.setTransferred(true);
            task2.setWorkbasketId(destinationWorkbasketId);
            task2.setModified(Timestamp.valueOf(LocalDateTime.now()));
            this.taskMapper.update(task2);
            result = this.getTaskById(taskId);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasketId);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from transfer(). Returning result {} ", (Object)result);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DueWorkbasketCounter> getTaskCountByWorkbasketAndDaysInPastAndState(long daysInPast, List<TaskState> states) {
        List<DueWorkbasketCounter> list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast = {}, states = {})", (Object)daysInPast, (Object)LoggerUtils.listToString(states));
        }
        List<DueWorkbasketCounter> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            LocalDate time = LocalDate.now();
            time = time.minusDays(daysInPast);
            Date fromDate = Date.valueOf(time);
            list = result = this.taskMapper.getTaskCountByWorkbasketIdAndDaysInPastAndState(fromDate, states);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast,states). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast,states). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException {
        Task task;
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            Task task2 = this.getTaskById(taskId);
            task2.setRead(true);
            task2.setModified(Timestamp.valueOf(LocalDateTime.now()));
            this.taskMapper.update(task2);
            result = this.getTaskById(taskId);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)result, (Object)isRead);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)result);
        return task;
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> getTasksByWorkbasketIdAndState(String workbasketId, TaskState taskState) throws WorkbasketNotFoundException, NotAuthorizedException, Exception {
        LOGGER.debug("entry to getTasksByWorkbasketIdAndState(workbasketId = {}, taskState = {})", (Object)workbasketId, (Object)taskState);
        ArrayList result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            this.taskanaEngine.getWorkbasketService().checkAuthorization(workbasketId, WorkbasketAuthorization.READ);
            result = this.taskMapper.findTasksByWorkbasketIdAndState(workbasketId, taskState);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return result == null ? new ArrayList() : result;
    }

    private void standardSettings(Task task) {
        Classification classification;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        task.setId(IdGenerator.generateWithPrefix(ID_PREFIX_TASK));
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        if (task.getPlanned() == null) {
            task.setPlanned(now);
        }
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix(ID_PREFIX_BUSINESS_PROCESS));
        }
        if ((classification = task.getClassification()) != null) {
            if (classification.getServiceLevel() != null) {
                Duration serviceLevel = Duration.parse(task.getClassification().getServiceLevel());
                LocalDateTime due = task.getPlanned().toLocalDateTime().plus(serviceLevel);
                task.setDue(Timestamp.valueOf(due));
            }
            if (task.getName() == null) {
                task.setName(classification.getName());
            }
            if (task.getDescription() == null) {
                task.setDescription(classification.getDescription());
            }
            if (task.getPriority() == 0) {
                task.setPriority(classification.getPriority());
            }
        }
        if (task.getPrimaryObjRef() != null) {
            ObjectReference objectReference = this.objectReferenceMapper.findByObjectReference(task.getPrimaryObjRef());
            if (objectReference == null) {
                objectReference = task.getPrimaryObjRef();
                objectReference.setId(IdGenerator.generateWithPrefix(ID_PREFIX_OBJECTR_EFERENCE));
                this.objectReferenceMapper.insert(objectReference);
            }
            task.setPrimaryObjRef(objectReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> getTaskSummariesByWorkbasketId(String workbasketId) throws WorkbasketNotFoundException {
        LOGGER.debug("entry to getTaskSummariesByWorkbasketId(workbasketId = {}", (Object)workbasketId);
        List<Object> taskSummaries = new ArrayList();
        this.taskanaEngineImpl.getWorkbasketService().getWorkbasket(workbasketId);
        try {
            this.taskanaEngineImpl.openConnection();
            taskSummaries = this.taskMapper.findTaskSummariesByWorkbasketId(workbasketId);
        }
        catch (Exception ex) {
            LOGGER.error("Getting TASKSUMMARY failed internally.", (Throwable)ex);
        }
        finally {
            if (taskSummaries == null) {
                taskSummaries = new ArrayList();
            }
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = taskSummaries.size();
                LOGGER.debug("exit from getTaskSummariesByWorkbasketId(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(taskSummaries));
            }
        }
        return taskSummaries;
    }
}

