/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketQuery;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.Workbasket;
import pro.taskana.model.WorkbasketAuthorization;

public class WorkbasketQueryImpl
implements WorkbasketQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryWorkbasket";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String[] accessId;
    private WorkbasketAuthorization authorization;
    private String[] name;
    private Date[] created;
    private Date[] modified;
    private String description;
    private String[] owner;
    private TaskanaEngineImpl taskanaEngineImpl;

    public WorkbasketQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public WorkbasketQuery name(String ... names) {
        this.name = names;
        return this;
    }

    @Override
    public WorkbasketQuery created(Date ... created) {
        this.created = created;
        return this;
    }

    @Override
    public WorkbasketQuery modified(Date ... modified) {
        this.modified = modified;
        return this;
    }

    @Override
    public WorkbasketQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public WorkbasketQuery owner(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public WorkbasketQuery access(WorkbasketAuthorization permission, String ... accessIds) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("permission must not be null");
        }
        if (accessIds == null || accessIds.length == 0) {
            throw new InvalidArgumentException("accessIds must not be empty");
        }
        this.authorization = permission;
        this.accessId = accessIds;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> list() throws NotAuthorizedException {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> list(int offset, int limit) throws NotAuthorizedException {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public Workbasket single() throws NotAuthorizedException {
        Workbasket workbasket;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        Workbasket result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasket = result = (Workbasket)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return workbasket;
    }

    public String[] getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String[] accessId) {
        this.accessId = accessId;
    }

    public WorkbasketAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(WorkbasketAuthorization authorization) {
        this.authorization = authorization;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public Date[] getCreated() {
        return this.created;
    }

    public void setCreated(Date[] created) {
        this.created = created;
    }

    public Date[] getModified() {
        return this.modified;
    }

    public void setModified(Date[] modified) {
        this.modified = modified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public void setOwner(String[] owner) {
        this.owner = owner;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketQueryImpl [accessId=");
        builder.append(Arrays.toString(this.accessId));
        builder.append(", authorization=");
        builder.append((Object)this.authorization);
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", created=");
        builder.append(Arrays.toString(this.created));
        builder.append(", modified=");
        builder.append(Arrays.toString(this.modified));
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append(", taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append("]");
        return builder.toString();
    }
}

