/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.Workbasket;
import pro.taskana.model.WorkbasketAccessItem;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.DistributionTargetMapper;
import pro.taskana.model.mappings.WorkbasketAccessMapper;
import pro.taskana.model.mappings.WorkbasketMapper;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketServiceImpl
implements WorkbasketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketServiceImpl.class);
    private static final String ID_PREFIX_WORKBASKET = "WBI";
    private static final String ID_PREFIX_WORKBASKET_AUTHORIZATION = "WAI";
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineImpl taskanaEngineImpl;
    private WorkbasketMapper workbasketMapper;
    private DistributionTargetMapper distributionTargetMapper;
    private WorkbasketAccessMapper workbasketAccessMapper;

    public WorkbasketServiceImpl() {
    }

    public WorkbasketServiceImpl(TaskanaEngine taskanaEngine, WorkbasketMapper workbasketMapper, DistributionTargetMapper distributionTargetMapper, WorkbasketAccessMapper workbasketAccessMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.workbasketMapper = workbasketMapper;
        this.distributionTargetMapper = distributionTargetMapper;
        this.workbasketAccessMapper = workbasketAccessMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasket(String workbasketId) throws WorkbasketNotFoundException {
        LOGGER.debug("entry to getWorkbasket(workbasketId = {})", (Object)workbasketId);
        Workbasket result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.workbasketMapper.findById(workbasketId);
            if (result == null) {
                LOGGER.warn("Method getWorkbasket() didn't find workbasket with id {}. Throwing WorkbasketNotFoundException", (Object)workbasketId);
                throw new WorkbasketNotFoundException(workbasketId);
            }
            Workbasket workbasket = result;
            return workbasket;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> getWorkbaskets(List<WorkbasketAuthorization> permissions) {
        ArrayList<Workbasket> arrayList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbaskets(permissions = {})", (Object)LoggerUtils.listToString(permissions));
        }
        ArrayList<Workbasket> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            HashSet<Workbasket> workbaskets = new HashSet<Workbasket>();
            for (String accessId : CurrentUserContext.getAccessIds()) {
                workbaskets.addAll(this.workbasketMapper.findByPermission(permissions, accessId));
            }
            result = new ArrayList<Workbasket>();
            result.addAll(workbaskets);
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> getWorkbaskets() {
        List<Workbasket> list;
        LOGGER.debug("entry to getWorkbaskets()");
        List<Workbasket> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.workbasketMapper.findAll();
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbaskets(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbaskets(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket createWorkbasket(Workbasket workbasket) {
        Workbasket workbasket2;
        LOGGER.debug("entry to createtWorkbasket(workbasket)", (Object)workbasket);
        Workbasket result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            workbasket.setCreated(now);
            workbasket.setModified(now);
            if (workbasket.getId() == null || workbasket.getId().isEmpty()) {
                workbasket.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET));
            }
            this.workbasketMapper.insert(workbasket);
            LOGGER.debug("Method createWorkbasket() created Workbasket '{}'", (Object)workbasket);
            if (workbasket.getDistributionTargets() != null) {
                for (Workbasket distributionTarget : workbasket.getDistributionTargets()) {
                    if (this.workbasketMapper.findById(distributionTarget.getId()) == null) {
                        distributionTarget.setCreated(now);
                        distributionTarget.setModified(now);
                        this.workbasketMapper.insert(distributionTarget);
                        LOGGER.debug("Method createWorkbasket() created distributionTarget '{}'", (Object)distributionTarget);
                    }
                    this.distributionTargetMapper.insert(workbasket.getId(), distributionTarget.getId());
                    LOGGER.debug("Method createWorkbasket() created distributiontarget for source '{}' and target {}", (Object)workbasket.getId(), (Object)distributionTarget.getId());
                }
            }
            result = this.workbasketMapper.findById(workbasket.getId());
            workbasket2 = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", (Object)result);
        return workbasket2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket updateWorkbasket(Workbasket workbasket) throws NotAuthorizedException {
        Workbasket workbasket2;
        LOGGER.debug("entry to updateWorkbasket(workbasket)", (Object)workbasket);
        Workbasket result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasket.setModified(new Timestamp(System.currentTimeMillis()));
            this.workbasketMapper.update(workbasket);
            LOGGER.debug("Method updateWorkbasket() updated workbasket '{}'", (Object)workbasket.getId());
            List<String> oldDistributionTargets = this.distributionTargetMapper.findBySourceId(workbasket.getId());
            List<Workbasket> distributionTargets = workbasket.getDistributionTargets();
            for (Workbasket distributionTarget : distributionTargets) {
                if (!oldDistributionTargets.contains(distributionTarget.getId())) {
                    if (this.workbasketMapper.findById(distributionTarget.getId()) == null) {
                        this.workbasketMapper.insert(distributionTarget);
                        LOGGER.debug(" Method updateWorkbasket() created distributionTarget '{}'", (Object)distributionTarget);
                    }
                    this.distributionTargetMapper.insert(workbasket.getId(), distributionTarget.getId());
                    LOGGER.debug("Method updateWorkbasket() created distributionTarget for '{}' and '{}'", (Object)workbasket.getId(), (Object)distributionTarget.getId());
                    continue;
                }
                oldDistributionTargets.remove(distributionTarget.getId());
            }
            this.distributionTargetMapper.deleteMultiple(workbasket.getId(), oldDistributionTargets);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.debug("Method updateWorkbasket() deleted distributionTargets for '{}' and old distribution targets {}", (Object)workbasket.getId(), (Object)LoggerUtils.listToString(oldDistributionTargets));
            }
            result = this.workbasketMapper.findById(workbasket.getId());
            workbasket2 = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", (Object)result);
        return workbasket2;
    }

    @Override
    public WorkbasketAccessItem createWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) {
        LOGGER.debug("entry to createWorkbasketAuthorization(workbasketAccessItem = {})", (Object)workbasketAccessItem);
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketAccessItem.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET_AUTHORIZATION));
            this.workbasketAccessMapper.insert(workbasketAccessItem);
            LOGGER.debug("Method createWorkbasketAuthorization() created workbaskteAccessItem {}", (Object)workbasketAccessItem);
            WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
            return workbasketAccessItem2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createWorkbasketAuthorization(workbasketAccessItem). Returning result {}", (Object)workbasketAccessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem getWorkbasketAuthorization(String id) {
        LOGGER.debug("entry to getWorkbasketAuthorization(id = {})", (Object)id);
        WorkbasketAccessItem result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            WorkbasketAccessItem workbasketAccessItem = result = this.workbasketAccessMapper.findById(id);
            return workbasketAccessItem;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasketAuthorization(id). Returning result {}", (Object)result);
        }
    }

    @Override
    public void deleteWorkbasketAuthorization(String id) {
        LOGGER.debug("entry to deleteWorkbasketAuthorization(id = {})", (Object)id);
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketAccessMapper.delete(id);
            LOGGER.debug("Method deleteWorkbasketAuthorization() deleted workbasketAccessItem wit Id {}", (Object)id);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from deleteWorkbasketAuthorization(id).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getAllAuthorizations() {
        List<WorkbasketAccessItem> list;
        LOGGER.debug("entry to getAllAuthorizations()");
        List<WorkbasketAccessItem> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.workbasketAccessMapper.findAll();
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getAllAuthorizations(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getAllAuthorizations(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAuthorization(String workbasketId, WorkbasketAuthorization workbasketAuthorization) throws NotAuthorizedException {
        LOGGER.debug("entry to checkAuthorization(workbasketId = {}, workbasketAuthorization = {})", (Object)workbasketId, (Object)workbasketAuthorization);
        boolean isAuthorized = false;
        try {
            this.taskanaEngineImpl.openConnection();
            if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
                LOGGER.debug("Skipping permissions check since security is disabled.");
                isAuthorized = true;
                return;
            }
            List<String> accessIds = CurrentUserContext.getAccessIds();
            LOGGER.debug("checkAuthorization: Verifying that {} has the permission {} on workbasket {}", new Object[]{CurrentUserContext.getUserid(), workbasketAuthorization.name(), workbasketId});
            List<WorkbasketAccessItem> accessItems = this.workbasketAccessMapper.findByWorkbasketAndAccessIdAndAuthorizations(workbasketId, accessIds, workbasketAuthorization.name());
            if (accessItems.size() <= 0) {
                throw new NotAuthorizedException("Not authorized. Authorization '" + workbasketAuthorization.name() + "' on workbasket '" + workbasketId + "' is needed.");
            }
            isAuthorized = true;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from checkAuthorization(). User is authorized = {}.", (Object)isAuthorized);
        }
    }

    @Override
    public WorkbasketAccessItem updateWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) {
        LOGGER.debug("entry to updateWorkbasketAuthorization(workbasketAccessItem = {}", (Object)workbasketAccessItem);
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketAccessMapper.update(workbasketAccessItem);
            LOGGER.debug("Method updateWorkbasketAuthorization() updated workbasketAccessItem {}", (Object)workbasketAccessItem);
            WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
            return workbasketAccessItem2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateWorkbasketAuthorization(workbasketAccessItem). Returning {}", (Object)workbasketAccessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getWorkbasketAuthorizations(String workbasketId) {
        List<WorkbasketAccessItem> list;
        LOGGER.debug("entry to getWorkbasketAuthorizations(workbasketId = {})", (Object)workbasketId);
        List<WorkbasketAccessItem> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.workbasketAccessMapper.findByWorkbasketId(workbasketId);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public WorkbasketQuery createWorkbasketQuery() {
        return new WorkbasketQueryImpl(this.taskanaEngine);
    }
}

