/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.model.mappings;

import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Many;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.mapping.FetchType;
import pro.taskana.model.Workbasket;
import pro.taskana.model.WorkbasketAuthorization;

public interface WorkbasketMapper {
    @Select(value={"SELECT ID, CREATED, MODIFIED, NAME, DESCRIPTION, OWNER FROM WORKBASKET WHERE ID = #{id}"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="name", column="NAME"), @Result(property="description", column="DESCRIPTION"), @Result(property="owner", column="OWNER"), @Result(property="distributionTargets", column="ID", javaType=List.class, many=@Many(fetchType=FetchType.DEFAULT, select="findByDistributionTargets"))})
    public Workbasket findById(@Param(value="id") String var1);

    @Select(value={"SELECT * FROM WORKBASKET WHERE id IN (SELECT TARGET_ID FROM DISTRIBUTION_TARGETS WHERE SOURCE_ID = #{id})"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="name", column="NAME"), @Result(property="description", column="DESCRIPTION"), @Result(property="owner", column="OWNER"), @Result(property="distributionTargets", column="ID", javaType=List.class, many=@Many(fetchType=FetchType.DEFAULT, select="findByDistributionTargets"))})
    public List<Workbasket> findByDistributionTargets(@Param(value="id") String var1);

    @Select(value={"SELECT * FROM WORKBASKET ORDER BY id"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="name", column="NAME"), @Result(property="description", column="DESCRIPTION"), @Result(property="owner", column="OWNER"), @Result(property="distributionTargets", column="ID", javaType=List.class, many=@Many(fetchType=FetchType.DEFAULT, select="findByDistributionTargets"))})
    public List<Workbasket> findAll();

    @Select(value={"<script>SELECT W.ID, W.CREATED, W.MODIFIED, W.NAME, W.DESCRIPTION, W.OWNER FROM WORKBASKET AS W INNER JOIN WORKBASKET_ACCESS_LIST AS ACL ON (W.ID = ACL.WORKBASKET_ID AND ACL.ACCESS_ID = #{accessId}) WHERE <foreach collection='authorizations' item='authorization' separator=' AND '><if test=\"authorization.name() == 'OPEN'\">PERM_OPEN</if><if test=\"authorization.name() == 'READ'\">PERM_READ</if><if test=\"authorization.name() == 'APPEND'\">PERM_APPEND</if><if test=\"authorization.name() == 'TRANSFER'\">PERM_TRANSFER</if><if test=\"authorization.name() == 'DISTRIBUTE'\">PERM_DISTRIBUTE</if><if test=\"authorization.name() == 'CUSTOM_1'\">PERM_CUSTOM_1</if><if test=\"authorization.name() == 'CUSTOM_2'\">PERM_CUSTOM_2</if><if test=\"authorization.name() == 'CUSTOM_3'\">PERM_CUSTOM_3</if><if test=\"authorization.name() == 'CUSTOM_4'\">PERM_CUSTOM_4</if><if test=\"authorization.name() == 'CUSTOM_5'\">PERM_CUSTOM_5</if><if test=\"authorization.name() == 'CUSTOM_6'\">PERM_CUSTOM_6</if><if test=\"authorization.name() == 'CUSTOM_7'\">PERM_CUSTOM_7</if><if test=\"authorization.name() == 'CUSTOM_8'\">PERM_CUSTOM_8</if> = 1 </foreach> ORDER BY id</script>"})
    @Results(value={@Result(property="id", column="ID"), @Result(property="created", column="CREATED"), @Result(property="modified", column="MODIFIED"), @Result(property="name", column="NAME"), @Result(property="description", column="DESCRIPTION"), @Result(property="owner", column="OWNER"), @Result(property="distributionTargets", column="ID", javaType=List.class, many=@Many(fetchType=FetchType.DEFAULT, select="findByDistributionTargets"))})
    public List<Workbasket> findByPermission(@Param(value="authorizations") List<WorkbasketAuthorization> var1, @Param(value="accessId") String var2);

    @Insert(value={"INSERT INTO WORKBASKET (ID, CREATED, MODIFIED, NAME, DESCRIPTION, OWNER) VALUES (#{workbasket.id}, #{workbasket.created}, #{workbasket.modified}, #{workbasket.name}, #{workbasket.description}, #{workbasket.owner})"})
    @Options(keyProperty="id", keyColumn="ID")
    public void insert(@Param(value="workbasket") Workbasket var1);

    @Update(value={"UPDATE WORKBASKET SET MODIFIED = #{workbasket.modified}, NAME = #{workbasket.name}, DESCRIPTION = #{workbasket.description}, OWNER = #{workbasket.owner} WHERE id = #{workbasket.id}"})
    public void update(@Param(value="workbasket") Workbasket var1);

    @Delete(value={"DELETE FROM WORKBASKET where id = #{id}"})
    public void delete(@Param(value="id") String var1);
}

