/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.configuration.DbScriptRunner;
import pro.taskana.impl.TaskanaEngineImpl;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    private static final String USER_NAME = "sa";
    private static final String USER_PASSWORD = "sa";
    private static final String JDBC_H2_MEM_TASKANA = "jdbc:h2:mem:taskana";
    private static final String H2_DRIVER = "org.h2.Driver";
    protected DataSource dataSource;
    protected DbScriptRunner dbScriptRunner;
    protected boolean securityEnabled;
    protected boolean useManagedTransactions;

    public TaskanaEngineConfiguration() {
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useContainerManagedTransactions) throws SQLException {
        this(dataSource, useContainerManagedTransactions, true);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useContainerManagedTransactions, boolean securityEnabled) throws SQLException {
        this.useManagedTransactions = useContainerManagedTransactions;
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.dbScriptRunner = new DbScriptRunner(this.dataSource);
        this.dbScriptRunner.run();
        this.securityEnabled = securityEnabled;
    }

    public static DataSource createDefaultDataSource() {
        LOGGER.warn("No datasource is provided. A inmemory db is used: 'org.h2.Driver', 'jdbc:h2:mem:taskana', 'sa', 'sa'");
        return TaskanaEngineConfiguration.createDatasource(H2_DRIVER, JDBC_H2_MEM_TASKANA, "sa", "sa");
    }

    public TaskanaEngine buildTaskanaEngine() {
        return new TaskanaEngineImpl(this);
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public boolean getUseManagedTransactions() {
        return this.useManagedTransactions;
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        return true;
    }
}

