/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.impl.ClassificationQueryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.mappings.ClassificationMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    public static final Date CURRENT_CLASSIFICATIONS_VALID_UNTIL = Date.valueOf("9999-12-31");
    private static final String ID_PREFIX_CLASSIFICATION = "CLI";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    private ClassificationMapper classificationMapper;
    private TaskanaEngineImpl taskanaEngineImpl;

    public ClassificationServiceImpl(TaskanaEngine taskanaEngine, ClassificationMapper classificationMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.classificationMapper = classificationMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> getClassificationTree() throws NotAuthorizedException {
        List<Classification> list;
        LOGGER.debug("entry to getClassificationTree()");
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            List<Classification> rootClassifications = this.createClassificationQuery().parentClassificationKey("").validUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL).list();
            list = rootClassifications = this.populateChildClassifications(rootClassifications);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Classification> populateChildClassifications(List<Classification> classifications) throws NotAuthorizedException {
        try {
            this.taskanaEngineImpl.openConnection();
            ArrayList<Classification> children = new ArrayList<Classification>();
            for (Classification classification : classifications) {
                List<Classification> childClassifications = this.createClassificationQuery().parentClassificationKey(classification.getKey()).validUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL).list();
                children.addAll(this.populateChildClassifications(childClassifications));
            }
            classifications.addAll(children);
            List<Classification> list = classifications;
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification createClassification(Classification classification) throws ClassificationAlreadyExistException {
        ClassificationImpl classificationImpl;
        LOGGER.debug("entry to createClassification(classification = {})", (Object)classification);
        try {
            this.taskanaEngineImpl.openConnection();
            boolean isClassificationExisting = this.doesClassificationExist(classification.getKey(), classification.getDomain());
            if (isClassificationExisting) {
                throw new ClassificationAlreadyExistException(classification);
            }
            classificationImpl = (ClassificationImpl)classification;
            this.initDefaultClassificationValues(classificationImpl);
            this.classificationMapper.insert(classificationImpl);
            LOGGER.debug("Method createClassification created classification {}.", (Object)classification);
            this.addClassificationToRootDomain(classificationImpl);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createClassification()");
        }
        return classificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassificationToRootDomain(ClassificationImpl classificationImpl) {
        if (classificationImpl.getDomain() != "") {
            boolean doesExist = true;
            String idBackup = classificationImpl.getId();
            String domainBackup = classificationImpl.getDomain();
            classificationImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
            classificationImpl.setDomain("");
            try {
                this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                throw new ClassificationAlreadyExistException(classificationImpl);
            }
            catch (ClassificationNotFoundException e) {
                doesExist = false;
                LOGGER.debug("Method createClassification: Classification does not exist in root domain. Classification {}.", (Object)classificationImpl);
                if (!doesExist) {
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                }
                classificationImpl.setId(idBackup);
                classificationImpl.setDomain(domainBackup);
            }
            catch (ClassificationAlreadyExistException ex) {
                try {
                    LOGGER.warn("Method createClassification: Classification does already exist in root domain. Classification {}.", (Object)classificationImpl);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!doesExist) {
                        this.classificationMapper.insert(classificationImpl);
                        LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                    }
                    classificationImpl.setId(idBackup);
                    classificationImpl.setDomain(domainBackup);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClassification(Classification classification) {
        block6: {
            LOGGER.debug("entry to updateClassification(Classification = {})", (Object)classification);
            try {
                this.taskanaEngineImpl.openConnection();
                ClassificationImpl classificationImpl = (ClassificationImpl)classification;
                this.initDefaultClassificationValues(classificationImpl);
                ClassificationImpl oldClassification = null;
                try {
                    oldClassification = (ClassificationImpl)this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                    LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classificationImpl);
                    if (!oldClassification.getDomain().equals(classificationImpl.getDomain())) {
                        this.addClassificationToDomain(classificationImpl);
                        break block6;
                    }
                    this.updateExistingClassification(oldClassification, classificationImpl);
                }
                catch (ClassificationNotFoundException e) {
                    classificationImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
                    classificationImpl.setCreated(Date.valueOf(LocalDate.now()));
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classificationImpl);
                }
            }
            finally {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from updateClassification().");
            }
        }
    }

    private void initDefaultClassificationValues(ClassificationImpl classification) throws IllegalStateException {
        classification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
        classification.setValidFrom(Date.valueOf(LocalDate.now()));
        classification.setValidUntil(CURRENT_CLASSIFICATIONS_VALID_UNTIL);
        if (classification.getCreated() == null) {
            classification.setCreated(Date.valueOf(LocalDate.now()));
        }
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() != null) {
            try {
                Duration.parse(classification.getServiceLevel());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid duration. Please use the format defined by ISO 8601");
            }
        }
        if (classification.getKey() == null) {
            throw new IllegalStateException("Classification must contain a key");
        }
        if (classification.getParentClassificationKey() == null) {
            classification.setParentClassificationKey("");
        }
        if (classification.getDomain() == null) {
            classification.setDomain("");
        }
    }

    private void addClassificationToDomain(ClassificationImpl classification) {
        classification.setCreated(Date.valueOf(LocalDate.now()));
        this.classificationMapper.insert(classification);
        LOGGER.debug("Method updateClassification() inserted classification {}.", (Object)classification);
    }

    private void updateExistingClassification(ClassificationImpl oldClassification, ClassificationImpl newClassification) {
        oldClassification.setValidUntil(Date.valueOf(LocalDate.now().minusDays(1L)));
        this.classificationMapper.update(oldClassification);
        this.classificationMapper.insert(newClassification);
        LOGGER.debug("Method updateClassification() updated old classification {} and inserted new {}.", (Object)oldClassification, (Object)newClassification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Classification> getAllClassificationsWithKey(String key, String domain) {
        ArrayList<Classification> arrayList;
        LOGGER.debug("entry to getAllClassificationsWithKey(key = {}, domain = {})", (Object)key, (Object)domain);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            List<ClassificationImpl> classifications = this.classificationMapper.getAllClassificationsWithKey(key, domain);
            ArrayList<Classification> results = new ArrayList<Classification>();
            classifications.stream().forEach(c -> results.add((Classification)c));
            arrayList = results;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getAllClassificationsWithKey(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getAllClassificationsWithKey(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String key, String domain) throws ClassificationNotFoundException {
        ClassificationImpl classificationImpl;
        if (key == null) {
            throw new ClassificationNotFoundException(null);
        }
        LOGGER.debug("entry to getClassification(key = {}, domain = {})", (Object)key, (Object)domain);
        ClassificationImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.classificationMapper.findByKeyAndDomain(key, domain, CURRENT_CLASSIFICATIONS_VALID_UNTIL);
            if (result == null) {
                throw new ClassificationNotFoundException(key);
            }
            classificationImpl = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        return classificationImpl;
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        return new ClassificationQueryImpl(this.taskanaEngineImpl);
    }

    @Override
    public Classification newClassification() {
        ClassificationImpl classification = new ClassificationImpl();
        return classification;
    }

    private boolean doesClassificationExist(String key, String domain) {
        boolean isExisting = false;
        try {
            if (this.classificationMapper.findByKeyAndDomain(key, domain, CURRENT_CLASSIFICATIONS_VALID_UNTIL) != null) {
                isExisting = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Classification-Service throwed Exception while calling mapper and searching for classification. EX={}", (Throwable)ex);
        }
        return isExisting;
    }
}

