/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationService;
import pro.taskana.Task;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskImpl;
import pro.taskana.impl.TaskQueryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.ObjectReference;
import pro.taskana.model.TaskState;
import pro.taskana.model.TaskSummary;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.ObjectReferenceMapper;
import pro.taskana.model.mappings.TaskMapper;
import pro.taskana.security.CurrentUserContext;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final String ID_PREFIX_OBJECT_REFERENCE = "ORI";
    private static final String ID_PREFIX_TASK = "TKI";
    private static final String ID_PREFIX_BUSINESS_PROCESS = "BPI";
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineImpl taskanaEngineImpl;
    private WorkbasketService workbasketService;
    private ClassificationService classificationService;
    private TaskMapper taskMapper;
    private ObjectReferenceMapper objectReferenceMapper;

    public TaskServiceImpl(TaskanaEngine taskanaEngine, TaskMapper taskMapper, ObjectReferenceMapper objectReferenceMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMapper = taskMapper;
        this.objectReferenceMapper = objectReferenceMapper;
        this.workbasketService = this.taskanaEngineImpl.getWorkbasketService();
        this.classificationService = this.taskanaEngineImpl.getClassificationService();
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        return this.claim(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to claim(id = {}, forceClaim = {}, userId = {})", new Object[]{taskId, forceClaim, userId});
        TaskImpl task = null;
        try {
            this.taskanaEngineImpl.openConnection();
            task = (TaskImpl)this.getTaskById(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                LOGGER.warn("Method claim() found that task {} is already completed. Throwing InvalidStateException", (Object)taskId);
                throw new InvalidStateException("Task is already completed");
            }
            if (state == TaskState.CLAIMED && !forceClaim) {
                LOGGER.warn("Method claim() found that task {} is claimed by {} and forceClaim is false. Throwing InvalidOwnerException", (Object)taskId, (Object)task.getOwner());
                throw new InvalidOwnerException("Task is already claimed by user " + task.getOwner());
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            task.setOwner(userId);
            task.setModified(now);
            task.setClaimed(now);
            task.setRead(true);
            task.setState(TaskState.CLAIMED);
            this.taskMapper.update(task);
            LOGGER.debug("Method claim() claimed task '{}' for user '{}'.", (Object)taskId, (Object)userId);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        return this.completeTask(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        LOGGER.debug("entry to completeTask(id = {}, isForced {})", (Object)taskId, (Object)isForced);
        TaskImpl task = null;
        try {
            this.taskanaEngineImpl.openConnection();
            task = (TaskImpl)this.getTaskById(taskId);
            if (!isForced) {
                if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                    LOGGER.warn("Method completeTask() does expect a task which need to be CLAIMED before. TaskId={}", (Object)taskId);
                    throw new InvalidStateException(taskId);
                }
                if (CurrentUserContext.getUserid() != task.getOwner()) {
                    LOGGER.warn("Method completeTask() does expect to be invoced by the task-owner or a administrator. TaskId={}, TaskOwner={}, CurrentUser={}", new Object[]{taskId, task.getOwner(), CurrentUserContext.getUserid()});
                    throw new InvalidOwnerException("TaskOwner is" + task.getOwner() + ", but current User is " + CurrentUserContext.getUserid());
                }
            } else if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                task = (TaskImpl)this.claim(taskId, true);
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            task.setCompleted(now);
            task.setModified(now);
            task.setState(TaskState.COMPLETED);
            this.taskMapper.update(task);
            LOGGER.debug("Method completeTask() completed Task '{}'.", (Object)taskId);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from completeTask()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidWorkbasketException {
        LOGGER.debug("entry to createTask(task = {})", (Object)taskToCreate);
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task = (TaskImpl)taskToCreate;
            if (task.getId() != "" && task.getId() != null) {
                throw new TaskAlreadyExistException(taskToCreate.getId());
            }
            LOGGER.debug("Task {} cannot be be found, so it can be created.", (Object)taskToCreate.getId());
            Workbasket workbasket = this.workbasketService.getWorkbasketByKey(task.getWorkbasketKey());
            this.workbasketService.checkAuthorization(task.getWorkbasketKey(), WorkbasketAuthorization.APPEND);
            Classification classification = task.getClassification();
            if (classification == null) {
                throw new ClassificationNotFoundException(null);
            }
            this.classificationService.getClassification(classification.getKey(), classification.getDomain());
            this.standardSettings(task);
            this.taskMapper.insert(task);
            LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createTask(task = {})");
        }
    }

    @Override
    public Task getTaskById(String id) throws TaskNotFoundException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        TaskImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.taskMapper.findById(id);
            if (result != null) {
                TaskImpl taskImpl = result;
                return taskImpl;
            }
            LOGGER.warn("Method getTaskById() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
            throw new TaskNotFoundException(id);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task transfer(String taskId, String destinationWorkbasketKey) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        Task task;
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketKey = {})", (Object)taskId, (Object)destinationWorkbasketKey);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task2 = (TaskImpl)this.getTaskById(taskId);
            this.workbasketService.checkAuthorization(destinationWorkbasketKey, WorkbasketAuthorization.APPEND);
            this.workbasketService.checkAuthorization(task2.getWorkbasketKey(), WorkbasketAuthorization.TRANSFER);
            if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
                this.workbasketService.getWorkbasketByKey(destinationWorkbasketKey);
            }
            task2.setRead(false);
            task2.setTransferred(true);
            task2.setWorkbasketKey(destinationWorkbasketKey);
            task2.setModified(Timestamp.valueOf(LocalDateTime.now()));
            this.taskMapper.update(task2);
            result = this.getTaskById(taskId);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasketKey);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from transfer(). Returning result {} ", (Object)result);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException {
        Task task;
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task2 = (TaskImpl)this.getTaskById(taskId);
            task2.setRead(true);
            task2.setModified(Timestamp.valueOf(LocalDateTime.now()));
            this.taskMapper.update(task2);
            result = this.getTaskById(taskId);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)result, (Object)isRead);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)result);
        return task;
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> getTasksByWorkbasketKeyAndState(String workbasketKey, TaskState taskState) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getTasksByWorkbasketKeyAndState(workbasketKey = {}, taskState = {})", (Object)workbasketKey, (Object)taskState);
        ArrayList results = new ArrayList();
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketService.checkAuthorization(workbasketKey, WorkbasketAuthorization.READ);
            List<TaskImpl> tasks = this.taskMapper.findTasksByWorkbasketIdAndState(workbasketKey, taskState);
            tasks.stream().forEach(t -> results.add(t));
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = results == null ? 0 : results.size();
                LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = results == null ? 0 : results.size();
            LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
        }
        return results == null ? new ArrayList() : results;
    }

    private void standardSettings(TaskImpl task) {
        Classification classification;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        task.setId(IdGenerator.generateWithPrefix(ID_PREFIX_TASK));
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        if (task.getPlanned() == null) {
            task.setPlanned(now);
        }
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix(ID_PREFIX_BUSINESS_PROCESS));
        }
        if ((classification = task.getClassification()) != null) {
            if (classification.getServiceLevel() != null) {
                Duration serviceLevel = Duration.parse(task.getClassification().getServiceLevel());
                LocalDateTime due = task.getPlanned().toLocalDateTime().plus(serviceLevel);
                task.setDue(Timestamp.valueOf(due));
            }
            if (task.getName() == null) {
                task.setName(classification.getName());
            }
            if (task.getDescription() == null) {
                task.setDescription(classification.getDescription());
            }
            if (task.getPriority() == 0) {
                task.setPriority(classification.getPriority());
            }
        }
        if (task.getPrimaryObjRef() != null) {
            ObjectReference objectReference = this.objectReferenceMapper.findByObjectReference(task.getPrimaryObjRef());
            if (objectReference == null) {
                objectReference = task.getPrimaryObjRef();
                objectReference.setId(IdGenerator.generateWithPrefix(ID_PREFIX_OBJECT_REFERENCE));
                this.objectReferenceMapper.insert(objectReference);
            }
            task.setPrimaryObjRef(objectReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> getTaskSummariesByWorkbasketKey(String workbasketKey) throws WorkbasketNotFoundException, InvalidWorkbasketException {
        LOGGER.debug("entry to getTaskSummariesByWorkbasketId(workbasketId = {}", (Object)workbasketKey);
        List<Object> taskSummaries = new ArrayList();
        this.workbasketService.getWorkbasketByKey(workbasketKey);
        try {
            this.taskanaEngineImpl.openConnection();
            taskSummaries = this.taskMapper.findTaskSummariesByWorkbasketKey(workbasketKey);
        }
        catch (Exception ex) {
            LOGGER.error("Getting TASKSUMMARY failed internally.", (Throwable)ex);
        }
        finally {
            if (taskSummaries == null) {
                taskSummaries = new ArrayList();
            }
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = taskSummaries.size();
                LOGGER.debug("exit from getTaskSummariesByWorkbasketId(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(taskSummaries));
            }
        }
        return taskSummaries;
    }

    @Override
    public Task newTask() {
        return new TaskImpl();
    }
}

