/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Connection;
import java.util.Stack;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ClassificationService;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskService;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketService;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.AutocommitFailedException;
import pro.taskana.exceptions.ConnectionNotSetException;
import pro.taskana.impl.ClassificationServiceImpl;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.WorkbasketServiceImpl;
import pro.taskana.impl.persistence.MapTypeHandler;
import pro.taskana.model.mappings.ClassificationMapper;
import pro.taskana.model.mappings.DistributionTargetMapper;
import pro.taskana.model.mappings.ObjectReferenceMapper;
import pro.taskana.model.mappings.QueryMapper;
import pro.taskana.model.mappings.TaskMapper;
import pro.taskana.model.mappings.TaskMonitorMapper;
import pro.taskana.model.mappings.WorkbasketAccessMapper;
import pro.taskana.model.mappings.WorkbasketMapper;

public class TaskanaEngineImpl
implements TaskanaEngine {
    private static final String DEFAULT = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineImpl.class);
    protected static ThreadLocal<Stack<SqlSessionManager>> sessionStack = new ThreadLocal();
    protected TaskanaEngineConfiguration taskanaEngineConfiguration;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected SqlSessionFactory sessionFactory;
    protected TaskanaEngine.ConnectionManagementMode mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
    protected Connection connection = null;

    public TaskanaEngineImpl(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.createTransactionFactory(taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
    }

    @Override
    public TaskService getTaskService() {
        SqlSessionManager session = this.sessionManager;
        TaskServiceImpl taskServiceImpl = new TaskServiceImpl(this, (TaskMapper)session.getMapper(TaskMapper.class), (ObjectReferenceMapper)session.getMapper(ObjectReferenceMapper.class));
        return taskServiceImpl;
    }

    @Override
    public TaskMonitorService getTaskMonitorService() {
        SqlSessionManager session = this.sessionManager;
        TaskMonitorServiceImpl taskMonitorServiceImpl = new TaskMonitorServiceImpl(this, (TaskMonitorMapper)session.getMapper(TaskMonitorMapper.class));
        return taskMonitorServiceImpl;
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        SqlSessionManager session = this.sessionManager;
        WorkbasketServiceImpl workbasketServiceImpl = new WorkbasketServiceImpl(this, (WorkbasketMapper)session.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)session.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)session.getMapper(WorkbasketAccessMapper.class));
        return workbasketServiceImpl;
    }

    @Override
    public ClassificationService getClassificationService() {
        SqlSessionManager session = this.sessionManager;
        return new ClassificationServiceImpl(this, (ClassificationMapper)session.getMapper(ClassificationMapper.class));
    }

    @Override
    public TaskanaEngineConfiguration getConfiguration() {
        return this.taskanaEngineConfiguration;
    }

    @Override
    public void setConnectionManagementMode(TaskanaEngine.ConnectionManagementMode mode) {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
    }

    @Override
    public void setConnection(Connection connection) {
        if (connection != null) {
            this.connection = connection;
            this.mode = TaskanaEngine.ConnectionManagementMode.EXPLICIT;
            this.sessionManager.startManagedSession(connection);
        } else if (this.connection != null) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    @Override
    public void closeConnection() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    void openConnection() {
        this.initSqlSession();
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            TaskanaEngineImpl.pushSessionToStack(this.sessionManager);
        }
    }

    void initSqlSession() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection == null) {
            throw new ConnectionNotSetException();
        }
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT && !this.sessionManager.isManagedSessionStarted()) {
            this.sessionManager.startManagedSession();
        }
    }

    void returnConnection() {
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            TaskanaEngineImpl.popSessionFromStack();
            if (TaskanaEngineImpl.getSessionStack().isEmpty() && this.sessionManager != null && this.sessionManager.isManagedSessionStarted()) {
                if (this.mode == TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT) {
                    try {
                        this.sessionManager.commit();
                    }
                    catch (Exception e) {
                        LOGGER.error("closeSession(): Tried to Autocommit and caught exception" + e);
                        throw new AutocommitFailedException(e);
                    }
                }
                this.sessionManager.close();
            }
        }
    }

    SqlSession getSqlSession() {
        return this.sessionManager;
    }

    private SqlSessionManager createSqlSessionManager() {
        Environment environment = new Environment(DEFAULT, this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
        Configuration configuration = new Configuration(environment);
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(TaskMonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(QueryMapper.class);
        configuration.getTypeHandlerRegistry().register(MapTypeHandler.class);
        SqlSessionFactory sessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        SqlSessionManager sessionManager = SqlSessionManager.newInstance((SqlSessionFactory)sessionFactory);
        return sessionManager;
    }

    private void createTransactionFactory(boolean useContainerManagedTransactions) {
        this.transactionFactory = useContainerManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
    }

    protected static Stack<SqlSessionManager> getSessionStack() {
        Stack<Object> stack = sessionStack.get();
        if (stack == null) {
            stack = new Stack();
            sessionStack.set(stack);
        }
        return stack;
    }

    protected static SqlSessionManager getSessionFromStack() {
        Stack<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    protected static void pushSessionToStack(SqlSessionManager session) {
        TaskanaEngineImpl.getSessionStack().push(session);
    }

    protected static void popSessionFromStack() {
        Stack<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }
}

