/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketQuery;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.WorkbasketType;

public class WorkbasketQueryImpl
implements WorkbasketQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryWorkbasket";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String[] accessId;
    private WorkbasketAuthorization authorization;
    private String[] name;
    private String[] key;
    private String[] domain;
    private WorkbasketType[] type;
    private Date createdAfter;
    private Date createdBefore;
    private Date modifiedAfter;
    private Date modifiedBefore;
    private String description;
    private String[] owner;
    private TaskanaEngineImpl taskanaEngineImpl;

    public WorkbasketQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public WorkbasketQuery keyIn(String ... key) {
        this.key = key;
        return this;
    }

    @Override
    public WorkbasketQuery domainIn(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public WorkbasketQuery typeIn(WorkbasketType ... type) {
        this.type = type;
        return this;
    }

    @Override
    public WorkbasketQuery nameIn(String ... names) {
        this.name = names;
        return this;
    }

    @Override
    public WorkbasketQuery createdAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    @Override
    public WorkbasketQuery createdBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedAfter(Date modifiedAfter) {
        this.modifiedAfter = modifiedAfter;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedBefore(Date modifiedBefore) {
        this.modifiedBefore = modifiedBefore;
        return this;
    }

    @Override
    public WorkbasketQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public WorkbasketQuery ownerIn(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public WorkbasketQuery access(WorkbasketAuthorization permission, String ... accessIds) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("permission must not be null");
        }
        if (accessIds == null || accessIds.length == 0) {
            throw new InvalidArgumentException("accessIds must not be empty");
        }
        this.authorization = permission;
        this.accessId = accessIds;
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            for (int i = 0; i < accessIds.length; ++i) {
                String id = accessIds[i];
                if (id == null) continue;
                accessIds[i] = id.toLowerCase();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> list() throws NotAuthorizedException {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> list(int offset, int limit) throws NotAuthorizedException {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = result = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public Workbasket single() throws NotAuthorizedException {
        WorkbasketImpl workbasketImpl;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketImpl = result = (WorkbasketImpl)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return workbasketImpl;
    }

    public String[] getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String[] accessId) {
        this.accessId = accessId;
    }

    public WorkbasketAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(WorkbasketAuthorization authorization) {
        this.authorization = authorization;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public String[] getKey() {
        return this.key;
    }

    public void setKey(String[] key) {
        this.key = key;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public void setDomain(String[] domain) {
        this.domain = domain;
    }

    public WorkbasketType[] getType() {
        return this.type;
    }

    public void setType(WorkbasketType[] type) {
        this.type = type;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getModifiedAfter() {
        return this.modifiedAfter;
    }

    public void setModifiedAfter(Date modifiedAfter) {
        this.modifiedAfter = modifiedAfter;
    }

    public Date getModifiedBefore() {
        return this.modifiedBefore;
    }

    public void setModifiedBefore(Date modifiedBefore) {
        this.modifiedBefore = modifiedBefore;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public void setOwner(String[] owner) {
        this.owner = owner;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketQueryImpl [accessId=");
        builder.append(Arrays.toString(this.accessId));
        builder.append(", authorization=");
        builder.append((Object)this.authorization);
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", key=");
        builder.append(Arrays.toString(this.key));
        builder.append(", domain=");
        builder.append(Arrays.toString(this.domain));
        builder.append(", type=");
        builder.append(Arrays.toString((Object[])this.type));
        builder.append(", createdAfter=");
        builder.append(this.createdAfter);
        builder.append(", createdBefore=");
        builder.append(this.createdBefore);
        builder.append(", modifiedAfter=");
        builder.append(this.modifiedAfter);
        builder.append(", modifiedBefore=");
        builder.append(this.modifiedBefore);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append("]");
        return builder.toString();
    }
}

