/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ClassificationQuery;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.Task;
import pro.taskana.TaskQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.ObjectReferenceQueryImpl;
import pro.taskana.impl.TaskImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.TaskState;
import pro.taskana.model.WorkbasketAuthorization;

public class TaskQueryImpl
implements TaskQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryTasks";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueryImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private String[] name;
    private String description;
    private int[] priority;
    private TaskState[] states;
    private ClassificationQuery classificationQuery;
    private String[] workbasketKey;
    private String[] owner;
    private Boolean isRead;
    private Boolean isTransferred;
    private String[] customFields;
    private String[] porCompanyIn;
    private String porCompanyLike;
    private String[] porSystemIn;
    private String porSystemLike;
    private String[] porSystemInstanceIn;
    private String porSystemInstanceLike;
    private String[] porTypeIn;
    private String porTypeLike;
    private String[] porValueIn;
    private String porValueLike;

    public TaskQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public TaskQuery name(String ... names) {
        this.name = names;
        return this;
    }

    @Override
    public TaskQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery priority(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public TaskQuery state(TaskState ... states) {
        this.states = states;
        return this;
    }

    @Override
    public TaskQuery classification(ClassificationQuery classificationQuery) {
        this.classificationQuery = classificationQuery;
        return this;
    }

    @Override
    public TaskQuery workbasketKeyIn(String ... workbasketKeys) {
        this.workbasketKey = workbasketKeys;
        return this;
    }

    @Override
    public TaskQuery owner(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyIn(String ... companies) {
        this.porCompanyIn = companies;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyLike(String company) {
        this.porCompanyLike = company;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemIn(String ... systems) {
        this.porSystemIn = systems;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemLike(String system) {
        this.porSystemLike = system;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceIn(String ... systemInstances) {
        this.porSystemInstanceIn = systemInstances;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceLike(String systemInstance) {
        this.porSystemInstanceLike = systemInstance;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeIn(String ... types) {
        this.porTypeIn = types;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeLike(String type) {
        this.porTypeLike = type;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueIn(String ... values) {
        this.porValueIn = values;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueLike(String value) {
        this.porValueLike = value;
        return this;
    }

    @Override
    public TaskQuery read(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    @Override
    public TaskQuery transferred(Boolean isTransferred) {
        this.isTransferred = isTransferred;
        return this;
    }

    @Override
    public TaskQuery customFields(String ... customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    public ObjectReferenceQuery createObjectReferenceQuery() {
        return new ObjectReferenceQueryImpl(this.taskanaEngineImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> list() throws NotAuthorizedException {
        ArrayList<Task> arrayList;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        ArrayList<Task> result = new ArrayList<Task>();
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkAuthorization();
            List tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            tasks.stream().forEach(t -> {
                TaskServiceImpl.setPrimaryObjRef(t);
                result.add((Task)t);
            });
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Task> list(int offset, int limit) throws NotAuthorizedException {
        ArrayList<Task> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<Task> result = new ArrayList<Task>();
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkAuthorization();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            tasks.stream().forEach(t -> {
                TaskServiceImpl.setPrimaryObjRef(t);
                result.add((Task)t);
            });
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public TaskImpl single() throws NotAuthorizedException {
        TaskImpl taskImpl;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        TaskImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkAuthorization();
            result = (TaskImpl)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            TaskServiceImpl.setPrimaryObjRef(result);
            taskImpl = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskImpl;
    }

    private void checkAuthorization() throws NotAuthorizedException {
        if (this.workbasketKey != null && this.workbasketKey.length > 0) {
            for (String workbasket : this.workbasketKey) {
                this.taskanaEngineImpl.getWorkbasketService().checkAuthorization(workbasket, WorkbasketAuthorization.OPEN);
            }
        }
    }

    public TaskanaEngineImpl getTaskanaEngine() {
        return this.taskanaEngineImpl;
    }

    public void setTaskanaEngine(TaskanaEngineImpl taskanaEngine) {
        this.taskanaEngineImpl = taskanaEngine;
    }

    public String[] getName() {
        return this.name;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public void setPriority(int[] priority) {
        this.priority = priority;
    }

    public TaskState[] getStates() {
        return this.states;
    }

    public void setStates(TaskState[] states) {
        this.states = states;
    }

    public ClassificationQuery getClassificationQuery() {
        return this.classificationQuery;
    }

    public void setClassificationQuery(ClassificationQuery classificationQuery) {
        this.classificationQuery = classificationQuery;
    }

    public String[] getWorkbasketKey() {
        return this.workbasketKey;
    }

    public void setWorkbasketKey(String[] workbasketKey) {
        this.workbasketKey = workbasketKey;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public void setOwner(String[] owner) {
        this.owner = owner;
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(String[] customFields) {
        this.customFields = customFields;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    public Boolean getIsTransferred() {
        return this.isTransferred;
    }

    public void setIsTransferred(Boolean isTransferred) {
        this.isTransferred = isTransferred;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public void setPorCompanyIn(String[] porCompanyIn) {
        this.porCompanyIn = porCompanyIn;
    }

    public String getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public void setPorCompanyLike(String porCompanyLike) {
        this.porCompanyLike = porCompanyLike;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public void setPorSystemIn(String[] porSystemIn) {
        this.porSystemIn = porSystemIn;
    }

    public String getPorSystemLike() {
        return this.porSystemLike;
    }

    public void setPorSystemLike(String porSystemLike) {
        this.porSystemLike = porSystemLike;
    }

    public String[] getPorSystemInstanceIn() {
        return this.porSystemInstanceIn;
    }

    public void setPorSystemInstanceIn(String[] porSystemInstanceIn) {
        this.porSystemInstanceIn = porSystemInstanceIn;
    }

    public String getPorSystemInstanceLike() {
        return this.porSystemInstanceLike;
    }

    public void setPorSystemInstanceLike(String porSystemInstanceLike) {
        this.porSystemInstanceLike = porSystemInstanceLike;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public void setPorTypeIn(String[] porTypeIn) {
        this.porTypeIn = porTypeIn;
    }

    public String getPorTypeLike() {
        return this.porTypeLike;
    }

    public void setPorTypeLike(String porTypeLike) {
        this.porTypeLike = porTypeLike;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public void setPorValueIn(String[] porValueIn) {
        this.porValueIn = porValueIn;
    }

    public String getPorValueLike() {
        return this.porValueLike;
    }

    public void setPorValueLike(String porValueLike) {
        this.porValueLike = porValueLike;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskQueryImpl [taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", states=");
        builder.append(Arrays.toString((Object[])this.states));
        builder.append(", classificationQuery=");
        builder.append(this.classificationQuery);
        builder.append(", workbasketKey=");
        builder.append(Arrays.toString(this.workbasketKey));
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append(", isRead=");
        builder.append(this.isRead);
        builder.append(", isTransferred=");
        builder.append(this.isTransferred);
        builder.append(", customFields=");
        builder.append(Arrays.toString(this.customFields));
        builder.append(", porCompanyIn=");
        builder.append(Arrays.toString(this.porCompanyIn));
        builder.append(", porCompanyLike=");
        builder.append(this.porCompanyLike);
        builder.append(", porSystemIn=");
        builder.append(Arrays.toString(this.porSystemIn));
        builder.append(", porSystemLike=");
        builder.append(this.porSystemLike);
        builder.append(", porSystemInstanceIn=");
        builder.append(Arrays.toString(this.porSystemInstanceIn));
        builder.append(", porSystemInstanceLike=");
        builder.append(this.porSystemInstanceLike);
        builder.append(", porTypeIn=");
        builder.append(Arrays.toString(this.porTypeIn));
        builder.append(", porTypeLike=");
        builder.append(this.porTypeLike);
        builder.append(", porValueIn=");
        builder.append(Arrays.toString(this.porValueIn));
        builder.append(", porValueLike=");
        builder.append(this.porValueLike);
        builder.append("]");
        return builder.toString();
    }
}

