/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.WorkbasketAccessItem;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.DistributionTargetMapper;
import pro.taskana.model.mappings.WorkbasketAccessMapper;
import pro.taskana.model.mappings.WorkbasketMapper;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketServiceImpl
implements WorkbasketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketServiceImpl.class);
    private static final String ID_PREFIX_WORKBASKET = "WBI";
    private static final String ID_PREFIX_WORKBASKET_AUTHORIZATION = "WAI";
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineImpl taskanaEngineImpl;
    private WorkbasketMapper workbasketMapper;
    private DistributionTargetMapper distributionTargetMapper;
    private WorkbasketAccessMapper workbasketAccessMapper;

    public WorkbasketServiceImpl() {
    }

    public WorkbasketServiceImpl(TaskanaEngine taskanaEngine, WorkbasketMapper workbasketMapper, DistributionTargetMapper distributionTargetMapper, WorkbasketAccessMapper workbasketAccessMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.workbasketMapper = workbasketMapper;
        this.distributionTargetMapper = distributionTargetMapper;
        this.workbasketAccessMapper = workbasketAccessMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasket(String workbasketId) throws WorkbasketNotFoundException, InvalidWorkbasketException {
        LOGGER.debug("entry to getWorkbasket(workbasketId = {})", (Object)workbasketId);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.workbasketMapper.findById(workbasketId);
            if (result == null) {
                LOGGER.warn("Method getWorkbasket() didn't find workbasket with id {}. Throwing WorkbasketNotFoundException", (Object)workbasketId);
                throw new WorkbasketNotFoundException(workbasketId);
            }
            this.validateWorkbasket(result);
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasketByKey(String workbasketKey) throws WorkbasketNotFoundException, InvalidWorkbasketException {
        LOGGER.debug("entry to getWorkbasketByKey(workbasketKey = {})", (Object)workbasketKey);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.workbasketMapper.findByKey(workbasketKey);
            if (result == null) {
                LOGGER.warn("Method getWorkbasket() didn't find workbasket with key {}. Throwing WorkbasketNotFoundException", (Object)workbasketKey);
                throw new WorkbasketNotFoundException(workbasketKey);
            }
            this.validateWorkbasket(result);
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> getWorkbaskets(List<WorkbasketAuthorization> permissions) {
        ArrayList<WorkbasketImpl> arrayList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbaskets(permissions = {})", (Object)LoggerUtils.listToString(permissions));
        }
        ArrayList<WorkbasketImpl> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            HashSet<WorkbasketImpl> workbaskets = new HashSet<WorkbasketImpl>();
            for (String accessId : CurrentUserContext.getAccessIds()) {
                workbaskets.addAll(this.workbasketMapper.findByPermission(permissions, accessId));
            }
            result = new ArrayList<WorkbasketImpl>();
            result.addAll(workbaskets);
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Workbasket> getWorkbaskets() {
        ArrayList<Workbasket> arrayList;
        LOGGER.debug("entry to getWorkbaskets()");
        ArrayList<Workbasket> workbaskets = new ArrayList<Workbasket>();
        try {
            this.taskanaEngineImpl.openConnection();
            List<WorkbasketImpl> results = this.workbasketMapper.findAll();
            results.stream().forEach(w -> workbaskets.add((Workbasket)w));
            arrayList = workbaskets;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                LOGGER.debug("exit from getWorkbaskets(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from getWorkbaskets(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket createWorkbasket(Workbasket newWorkbasket) throws InvalidWorkbasketException, WorkbasketNotFoundException {
        WorkbasketImpl workbasketImpl;
        LOGGER.debug("entry to createtWorkbasket(workbasket)", (Object)newWorkbasket);
        WorkbasketImpl result = null;
        WorkbasketImpl workbasket = (WorkbasketImpl)newWorkbasket;
        try {
            this.taskanaEngineImpl.openConnection();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            workbasket.setCreated(now);
            workbasket.setModified(now);
            if (workbasket.getId() == null || workbasket.getId().isEmpty()) {
                workbasket.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET));
            }
            this.validateWorkbasket(workbasket);
            this.workbasketMapper.insert(workbasket);
            LOGGER.debug("Method createWorkbasket() created Workbasket '{}'", (Object)workbasket);
            if (workbasket.getDistributionTargets() != null) {
                for (Workbasket distributionTarget : workbasket.getDistributionTargets()) {
                    this.getWorkbasket(distributionTarget.getId());
                    this.distributionTargetMapper.insert(workbasket.getId(), distributionTarget.getId());
                    LOGGER.debug("Method createWorkbasket() created distributiontarget for source '{}' and target {}", (Object)workbasket.getId(), (Object)distributionTarget.getId());
                }
            }
            result = this.workbasketMapper.findById(workbasket.getId());
            workbasketImpl = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", (Object)result);
        return workbasketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket updateWorkbasket(Workbasket workbasketToUpdate) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidWorkbasketException {
        WorkbasketImpl workbasketImpl;
        LOGGER.debug("entry to updateWorkbasket(workbasket)", (Object)workbasketToUpdate);
        WorkbasketImpl result = null;
        WorkbasketImpl workbasket = (WorkbasketImpl)workbasketToUpdate;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasket.setModified(new Timestamp(System.currentTimeMillis()));
            this.workbasketMapper.update(workbasket);
            LOGGER.debug("Method updateWorkbasket() updated workbasket '{}'", (Object)workbasket.getId());
            List<String> oldDistributionTargets = this.distributionTargetMapper.findBySourceId(workbasket.getId());
            List<Workbasket> newDistributionTargets = workbasket.getDistributionTargets();
            for (Workbasket distributionTarget : newDistributionTargets) {
                if (!oldDistributionTargets.contains(distributionTarget.getId())) {
                    this.getWorkbasket(distributionTarget.getId());
                    this.distributionTargetMapper.insert(workbasket.getId(), distributionTarget.getId());
                    LOGGER.debug("Method updateWorkbasket() created distributionTarget for '{}' and '{}'", (Object)workbasket.getId(), (Object)distributionTarget.getId());
                    continue;
                }
                oldDistributionTargets.remove(distributionTarget.getId());
            }
            this.distributionTargetMapper.deleteMultiple(workbasket.getId(), oldDistributionTargets);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.debug("Method updateWorkbasket() deleted distributionTargets for '{}' and old distribution targets {}", (Object)workbasket.getId(), (Object)LoggerUtils.listToString(oldDistributionTargets));
            }
            result = this.workbasketMapper.findById(workbasket.getId());
            workbasketImpl = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", (Object)result);
        return workbasketImpl;
    }

    @Override
    public WorkbasketAccessItem createWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) {
        LOGGER.debug("entry to createWorkbasketAuthorization(workbasketAccessItem = {})", (Object)workbasketAccessItem);
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketAccessItem.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET_AUTHORIZATION));
            this.workbasketAccessMapper.insert(workbasketAccessItem);
            LOGGER.debug("Method createWorkbasketAuthorization() created workbaskteAccessItem {}", (Object)workbasketAccessItem);
            WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
            return workbasketAccessItem2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createWorkbasketAuthorization(workbasketAccessItem). Returning result {}", (Object)workbasketAccessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem getWorkbasketAuthorization(String id) {
        LOGGER.debug("entry to getWorkbasketAuthorization(id = {})", (Object)id);
        WorkbasketAccessItem result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            WorkbasketAccessItem workbasketAccessItem = result = this.workbasketAccessMapper.findById(id);
            return workbasketAccessItem;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasketAuthorization(id). Returning result {}", (Object)result);
        }
    }

    @Override
    public void deleteWorkbasketAuthorization(String id) {
        LOGGER.debug("entry to deleteWorkbasketAuthorization(id = {})", (Object)id);
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketAccessMapper.delete(id);
            LOGGER.debug("Method deleteWorkbasketAuthorization() deleted workbasketAccessItem wit Id {}", (Object)id);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from deleteWorkbasketAuthorization(id).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getAllAuthorizations() {
        List<WorkbasketAccessItem> list;
        LOGGER.debug("entry to getAllAuthorizations()");
        List<WorkbasketAccessItem> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.workbasketAccessMapper.findAll();
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getAllAuthorizations(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getAllAuthorizations(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAuthorization(String workbasketKey, WorkbasketAuthorization workbasketAuthorization) throws NotAuthorizedException {
        LOGGER.debug("entry to checkAuthorization(workbasketId = {}, workbasketAuthorization = {})", (Object)workbasketKey, (Object)workbasketAuthorization);
        boolean isAuthorized = false;
        try {
            this.taskanaEngineImpl.openConnection();
            if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
                LOGGER.debug("Skipping permissions check since security is disabled.");
                isAuthorized = true;
                return;
            }
            List<String> accessIds = CurrentUserContext.getAccessIds();
            LOGGER.debug("checkAuthorization: Verifying that {} has the permission {} on workbasket {}", new Object[]{CurrentUserContext.getUserid(), workbasketAuthorization.name(), workbasketKey});
            List<WorkbasketAccessItem> accessItems = this.workbasketAccessMapper.findByWorkbasketAndAccessIdAndAuthorizations(workbasketKey, accessIds, workbasketAuthorization.name());
            if (accessItems.size() <= 0) {
                throw new NotAuthorizedException("Not authorized. Authorization '" + workbasketAuthorization.name() + "' on workbasket '" + workbasketKey + "' is needed.");
            }
            isAuthorized = true;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from checkAuthorization(). User is authorized = {}.", (Object)isAuthorized);
        }
    }

    @Override
    public WorkbasketAccessItem updateWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) {
        LOGGER.debug("entry to updateWorkbasketAuthorization(workbasketAccessItem = {}", (Object)workbasketAccessItem);
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketAccessMapper.update(workbasketAccessItem);
            LOGGER.debug("Method updateWorkbasketAuthorization() updated workbasketAccessItem {}", (Object)workbasketAccessItem);
            WorkbasketAccessItem workbasketAccessItem2 = workbasketAccessItem;
            return workbasketAccessItem2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateWorkbasketAuthorization(workbasketAccessItem). Returning {}", (Object)workbasketAccessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getWorkbasketAuthorizations(String workbasketKey) {
        List<WorkbasketAccessItem> list;
        LOGGER.debug("entry to getWorkbasketAuthorizations(workbasketId = {})", (Object)workbasketKey);
        List<WorkbasketAccessItem> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.workbasketAccessMapper.findByWorkbasketKey(workbasketKey);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public WorkbasketQuery createWorkbasketQuery() {
        return new WorkbasketQueryImpl(this.taskanaEngine);
    }

    private void validateWorkbasket(Workbasket workbasket) throws InvalidWorkbasketException {
        if (workbasket.getId() == null || workbasket.getId().length() == 0) {
            throw new InvalidWorkbasketException("Id must not be null for " + workbasket);
        }
        if (workbasket.getKey() == null || workbasket.getKey().length() == 0) {
            throw new InvalidWorkbasketException("Key must not be null for " + workbasket);
        }
        if (workbasket.getName() == null || workbasket.getName().length() == 0) {
            throw new InvalidWorkbasketException("Name must not be null for " + workbasket);
        }
        if (workbasket.getDomain() == null) {
            throw new InvalidWorkbasketException("Domain must not be null for " + workbasket);
        }
        if (workbasket.getType() == null) {
            throw new InvalidWorkbasketException("Type must not be null for " + workbasket);
        }
    }

    @Override
    public Workbasket newWorkbasket() {
        return new WorkbasketImpl();
    }
}

