/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.ClassificationSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.impl.ClassificationQueryImpl;
import pro.taskana.impl.ClassificationSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.mappings.ClassificationMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    private static final String ID_PREFIX_CLASSIFICATION = "CLI";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    private ClassificationMapper classificationMapper;
    private TaskanaEngineImpl taskanaEngineImpl;

    public ClassificationServiceImpl(TaskanaEngine taskanaEngine, ClassificationMapper classificationMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.classificationMapper = classificationMapper;
    }

    @Override
    public List<ClassificationSummary> getClassificationTree() {
        List<ClassificationSummary> list;
        LOGGER.debug("entry to getClassificationTree()");
        List<ClassificationSummary> rootClassificationSumamries = null;
        try {
            this.taskanaEngineImpl.openConnection();
            rootClassificationSumamries = this.createClassificationQuery().parentClassificationKey("").list();
            list = rootClassificationSumamries = this.populateChildClassifications(rootClassificationSumamries);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (NotAuthorizedException ex) {
            try {
                LOGGER.debug("getClassificationTree() caught NotAuthorizedException. Throwing SystemException");
                throw new SystemException("ClassificationService.getClassificationTree caught unexpected NotAuthorizedException");
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = rootClassificationSumamries == null ? 0 : rootClassificationSumamries.size();
                    LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(rootClassificationSumamries));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = rootClassificationSumamries == null ? 0 : rootClassificationSumamries.size();
            LOGGER.debug("exit from getClassificationTree(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(rootClassificationSumamries));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClassificationSummary> populateChildClassifications(List<ClassificationSummary> classificationSumamries) throws NotAuthorizedException {
        try {
            this.taskanaEngineImpl.openConnection();
            ArrayList<ClassificationSummary> children = new ArrayList<ClassificationSummary>();
            for (ClassificationSummary classification : classificationSumamries) {
                List<ClassificationSummary> childClassifications = this.createClassificationQuery().parentClassificationKey(classification.getKey()).list();
                children.addAll(this.populateChildClassifications(childClassifications));
            }
            classificationSumamries.addAll(children);
            List<ClassificationSummary> list = classificationSumamries;
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification createClassification(Classification classification) throws ClassificationAlreadyExistException {
        ClassificationImpl classificationImpl;
        LOGGER.debug("entry to createClassification(classification = {})", (Object)classification);
        try {
            this.taskanaEngineImpl.openConnection();
            boolean isClassificationExisting = this.doesClassificationExist(classification.getKey(), classification.getDomain());
            if (isClassificationExisting) {
                throw new ClassificationAlreadyExistException(classification);
            }
            classificationImpl = (ClassificationImpl)classification;
            this.initDefaultClassificationValues(classificationImpl);
            this.classificationMapper.insert(classificationImpl);
            LOGGER.debug("Method createClassification created classification {}.", (Object)classification);
            this.addClassificationToRootDomain(classificationImpl);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createClassification()");
        }
        return classificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassificationToRootDomain(ClassificationImpl classificationImpl) {
        if (classificationImpl.getDomain() != "") {
            boolean doesExist = true;
            String idBackup = classificationImpl.getId();
            String domainBackup = classificationImpl.getDomain();
            classificationImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
            classificationImpl.setDomain("");
            try {
                this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                throw new ClassificationAlreadyExistException(classificationImpl);
            }
            catch (ClassificationNotFoundException e) {
                doesExist = false;
                LOGGER.debug("Method createClassification: Classification does not exist in root domain. Classification {}.", (Object)classificationImpl);
                if (!doesExist) {
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                }
                classificationImpl.setId(idBackup);
                classificationImpl.setDomain(domainBackup);
            }
            catch (ClassificationAlreadyExistException ex) {
                try {
                    LOGGER.warn("Method createClassification: Classification does already exist in root domain. Classification {}.", (Object)classificationImpl);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!doesExist) {
                        this.classificationMapper.insert(classificationImpl);
                        LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                    }
                    classificationImpl.setId(idBackup);
                    classificationImpl.setDomain(domainBackup);
                }
            }
        }
    }

    @Override
    public Classification updateClassification(Classification classification) {
        LOGGER.debug("entry to updateClassification(Classification = {})", (Object)classification);
        ClassificationImpl classificationImpl = null;
        try {
            this.taskanaEngineImpl.openConnection();
            classificationImpl = (ClassificationImpl)classification;
            this.initDefaultClassificationValues(classificationImpl);
            try {
                this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                this.classificationMapper.update(classificationImpl);
                LOGGER.debug("Method updateClassification() updated the classification {}.", (Object)classificationImpl);
            }
            catch (ClassificationNotFoundException e) {
                classificationImpl.setCreated(Instant.now());
                this.classificationMapper.insert(classificationImpl);
                LOGGER.debug("Method updateClassification() inserted a unpersisted classification which was wanted to be updated {}.", (Object)classificationImpl);
            }
            try {
                Classification updatedClassification;
                Classification classification2 = updatedClassification = this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                return classification2;
            }
            catch (ClassificationNotFoundException e) {
                LOGGER.debug("Throwing SystemException because updateClassification didn't find new classification {} after update", (Object)classification);
                throw new SystemException("updateClassification didn't find new classification after update");
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateClassification().");
        }
    }

    private void initDefaultClassificationValues(ClassificationImpl classification) throws IllegalStateException {
        if (classification.getId() == null) {
            classification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
        }
        if (classification.getCreated() == null) {
            classification.setCreated(Instant.now());
        }
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() != null) {
            try {
                Duration.parse(classification.getServiceLevel());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid duration. Please use the format defined by ISO 8601");
            }
        }
        if (classification.getKey() == null) {
            throw new IllegalStateException("Classification must contain a key");
        }
        if (classification.getParentClassificationKey() == null) {
            classification.setParentClassificationKey("");
        }
        if (classification.getDomain() == null) {
            classification.setDomain("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassificationSummary> getAllClassifications(String key, String domain) {
        ArrayList<ClassificationSummary> arrayList;
        LOGGER.debug("entry to getAllClassificationsWithKey(key = {}, domain = {})", (Object)key, (Object)domain);
        ArrayList<ClassificationSummary> results = new ArrayList<ClassificationSummary>();
        try {
            this.taskanaEngineImpl.openConnection();
            List<ClassificationSummaryImpl> classificationSummaries = this.classificationMapper.getAllClassificationsWithKey(key, domain);
            classificationSummaries.stream().forEach(c -> results.add((ClassificationSummary)c));
            arrayList = results;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = results == null ? 0 : results.size();
                LOGGER.debug("exit from getAllClassificationsWithKey(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = results == null ? 0 : results.size();
            LOGGER.debug("exit from getAllClassificationsWithKey(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String key, String domain) throws ClassificationNotFoundException {
        if (key == null) {
            throw new ClassificationNotFoundException("Classification for key " + key + " and domain " + domain + " was not found.");
        }
        LOGGER.debug("entry to getClassification(key = {}, domain = {})", (Object)key, (Object)domain);
        ClassificationImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.classificationMapper.findByKeyAndDomain(key, domain);
            if (result == null && (result = this.classificationMapper.findByKeyAndDomain(key, "")) == null) {
                throw new ClassificationNotFoundException("Classification for key " + key + " was not found");
            }
            ClassificationImpl classificationImpl = result;
            return classificationImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        }
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        return new ClassificationQueryImpl(this.taskanaEngineImpl);
    }

    @Override
    public Classification newClassification(String domain, String key, String type) {
        ClassificationImpl classification = new ClassificationImpl();
        classification.setKey(key);
        classification.setDomain(domain);
        classification.setType(type);
        return classification;
    }

    private boolean doesClassificationExist(String key, String domain) {
        boolean isExisting = false;
        try {
            if (this.classificationMapper.findByKeyAndDomain(key, domain) != null) {
                isExisting = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Classification-Service throwed Exception while calling mapper and searching for classification. EX={}", (Throwable)ex);
        }
        return isExisting;
    }
}

