/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Attachment;
import pro.taskana.Classification;
import pro.taskana.ClassificationSummary;
import pro.taskana.Task;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.AttachmentImpl;
import pro.taskana.impl.AttachmentSummaryImpl;
import pro.taskana.impl.ClassificationServiceImpl;
import pro.taskana.impl.TaskImpl;
import pro.taskana.impl.TaskQueryImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.ObjectReference;
import pro.taskana.model.TaskState;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.AttachmentMapper;
import pro.taskana.model.mappings.ObjectReferenceMapper;
import pro.taskana.model.mappings.TaskMapper;
import pro.taskana.security.CurrentUserContext;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final String ID_PREFIX_ATTACHMENT = "TAI";
    private static final String ID_PREFIX_TASK = "TKI";
    private static final String ID_PREFIX_BUSINESS_PROCESS = "BPI";
    private TaskanaEngine taskanaEngine;
    private TaskanaEngineImpl taskanaEngineImpl;
    private WorkbasketService workbasketService;
    private ClassificationServiceImpl classificationService;
    private TaskMapper taskMapper;
    private AttachmentMapper attachmentMapper;

    public TaskServiceImpl(TaskanaEngine taskanaEngine, TaskMapper taskMapper, ObjectReferenceMapper objectReferenceMapper, AttachmentMapper attachmentMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = this.taskanaEngineImpl.getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.classificationService = (ClassificationServiceImpl)this.taskanaEngineImpl.getClassificationService();
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        return this.claim(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to claim(id = {}, forceClaim = {}, userId = {})", new Object[]{taskId, forceClaim, userId});
        TaskImpl task = null;
        try {
            this.taskanaEngineImpl.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                LOGGER.warn("Method claim() found that task {} is already completed. Throwing InvalidStateException", (Object)taskId);
                throw new InvalidStateException("Task is already completed");
            }
            if (state == TaskState.CLAIMED && !forceClaim) {
                LOGGER.warn("Method claim() found that task {} is claimed by {} and forceClaim is false. Throwing InvalidOwnerException", (Object)taskId, (Object)task.getOwner());
                throw new InvalidOwnerException("Task is already claimed by user " + task.getOwner());
            }
            Instant now = Instant.now();
            task.setOwner(userId);
            task.setModified(now);
            task.setClaimed(now);
            task.setRead(true);
            task.setState(TaskState.CLAIMED);
            this.taskMapper.update(task);
            LOGGER.debug("Method claim() claimed task '{}' for user '{}'.", (Object)taskId, (Object)userId);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        return this.completeTask(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        LOGGER.debug("entry to completeTask(id = {}, isForced {})", (Object)taskId, (Object)isForced);
        TaskImpl task = null;
        try {
            this.taskanaEngineImpl.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            if (!isForced) {
                if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                    LOGGER.warn("Method completeTask() does expect a task which need to be CLAIMED before. TaskId={}", (Object)taskId);
                    throw new InvalidStateException(taskId);
                }
                if (CurrentUserContext.getUserid() != task.getOwner()) {
                    LOGGER.warn("Method completeTask() does expect to be invoced by the task-owner or a administrator. TaskId={}, TaskOwner={}, CurrentUser={}", new Object[]{taskId, task.getOwner(), CurrentUserContext.getUserid()});
                    throw new InvalidOwnerException("TaskOwner is" + task.getOwner() + ", but current User is " + CurrentUserContext.getUserid());
                }
            } else if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                task = (TaskImpl)this.claim(taskId, true);
            }
            Instant now = Instant.now();
            task.setCompleted(now);
            task.setModified(now);
            task.setState(TaskState.COMPLETED);
            this.taskMapper.update(task);
            LOGGER.debug("Method completeTask() completed Task '{}'.", (Object)taskId);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from completeTask()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidWorkbasketException, InvalidArgumentException {
        LOGGER.debug("entry to createTask(task = {})", (Object)taskToCreate);
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task = (TaskImpl)taskToCreate;
            if (task.getId() != "" && task.getId() != null) {
                throw new TaskAlreadyExistException(taskToCreate.getId());
            }
            LOGGER.debug("Task {} cannot be be found, so it can be created.", (Object)taskToCreate.getId());
            Workbasket workbasket = this.workbasketService.getWorkbasketByKey(task.getWorkbasketKey());
            this.workbasketService.checkAuthorization(task.getWorkbasketKey(), WorkbasketAuthorization.APPEND);
            String classificationKey = task.getClassificationKey();
            if (classificationKey == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task.setClassificationSummary(classification.asSummary());
            task.setWorkbasketSummary(workbasket.asSummary());
            this.validateObjectReference(task.getPrimaryObjRef(), "primary ObjectReference", "Task");
            this.validateAttachments(task);
            task.setDomain(workbasket.getDomain());
            this.standardSettings(task, classification);
            this.taskMapper.insert(task);
            LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createTask(task = {})");
        }
    }

    @Override
    public Task getTask(String id) throws TaskNotFoundException, SystemException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        TaskImpl resultTask = null;
        try {
            this.taskanaEngineImpl.openConnection();
            resultTask = this.taskMapper.findById(id);
            if (resultTask != null) {
                Classification classification;
                List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                List<Attachment> attachments = this.addClassificationSummariesToAttachments(resultTask, attachmentImpls);
                resultTask.setAttachments(attachments);
                try {
                    classification = this.classificationService.getClassification(resultTask.getClassificationKey(), resultTask.getDomain());
                }
                catch (ClassificationNotFoundException e) {
                    LOGGER.debug("getTask(taskId = {}) caught a ClassificationNotFoundException when attemptin to get the classification for the task. Throwing a SystemException ", (Object)id);
                    throw new SystemException("TaskService.getTask could not find the classification associated to " + id);
                }
                resultTask.setClassificationSummary(classification.asSummary());
                TaskImpl taskImpl = resultTask;
                return taskImpl;
            }
            LOGGER.warn("Method getTaskById() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
            throw new TaskNotFoundException(id);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)resultTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task transfer(String taskId, String destinationWorkbasketKey) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        Task task;
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketKey = {})", (Object)taskId, (Object)destinationWorkbasketKey);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task2 = (TaskImpl)this.getTask(taskId);
            this.workbasketService.checkAuthorization(destinationWorkbasketKey, WorkbasketAuthorization.APPEND);
            this.workbasketService.checkAuthorization(task2.getWorkbasketKey(), WorkbasketAuthorization.TRANSFER);
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasketByKey(destinationWorkbasketKey);
            task2.setRead(false);
            task2.setTransferred(true);
            task2.setWorkbasketKey(destinationWorkbasketKey);
            task2.setWorkbasketSummary(destinationWorkbasket.asSummary());
            task2.setDomain(destinationWorkbasket.getDomain());
            task2.setModified(Instant.now());
            this.taskMapper.update(task2);
            result = this.getTask(taskId);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasketKey);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from transfer(). Returning result {} ", (Object)result);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException {
        Task task;
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        Task result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            TaskImpl task2 = (TaskImpl)this.getTask(taskId);
            task2.setRead(true);
            task2.setModified(Instant.now());
            this.taskMapper.update(task2);
            result = this.getTask(taskId);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)result, (Object)isRead);
            task = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)result);
        return task;
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> getTasksByWorkbasketKeyAndState(String workbasketKey, TaskState taskState) throws WorkbasketNotFoundException, NotAuthorizedException, ClassificationNotFoundException {
        LOGGER.debug("entry to getTasksByWorkbasketKeyAndState(workbasketKey = {}, taskState = {})", (Object)workbasketKey, (Object)taskState);
        List<Object> results = new ArrayList();
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketService.checkAuthorization(workbasketKey, WorkbasketAuthorization.READ);
            List<TaskSummaryImpl> tasks = this.taskMapper.findTasksByWorkbasketIdAndState(workbasketKey, taskState);
            results = this.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = results == null ? 0 : results.size();
                LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = results == null ? 0 : results.size();
            LOGGER.debug("exit from getTasksByWorkbasketIdAndState(workbasketId, taskState). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
        }
        return results == null ? new ArrayList() : results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, WorkbasketNotFoundException, ClassificationNotFoundException, InvalidWorkbasketException, NotAuthorizedException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to updateTask(task = {}, userId = {})", (Object)task, (Object)userId);
        TaskImpl newTaskImpl = (TaskImpl)task;
        TaskImpl oldTaskImpl = null;
        try {
            this.taskanaEngineImpl.openConnection();
            oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            this.standardUpdateActions(oldTaskImpl, newTaskImpl);
            this.taskMapper.update(newTaskImpl);
            LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    private void standardSettings(TaskImpl task, Classification classification) {
        List<Attachment> attachments;
        Instant now = Instant.now();
        task.setId(IdGenerator.generateWithPrefix(ID_PREFIX_TASK));
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        if (task.getPlanned() == null) {
            task.setPlanned(now);
        }
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix(ID_PREFIX_BUSINESS_PROCESS));
        }
        if (classification != null) {
            if (classification.getServiceLevel() != null) {
                Duration serviceLevel = Duration.parse(classification.getServiceLevel());
                Instant due = task.getPlanned().plus(serviceLevel);
                task.setDue(due);
            }
            if (task.getName() == null) {
                task.setName(classification.getName());
            }
            if (task.getDescription() == null) {
                task.setDescription(classification.getDescription());
            }
            if (task.getPriority() == 0) {
                task.setPriority(classification.getPriority());
            }
        }
        if ((attachments = task.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                AttachmentImpl attImpl = (AttachmentImpl)attachment;
                attImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_ATTACHMENT));
                attImpl.setTaskId(task.getId());
                attImpl.setCreated(now);
                attImpl.setModified(now);
                this.attachmentMapper.insert(attImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> getTaskSummariesByWorkbasketKey(String workbasketKey) throws WorkbasketNotFoundException, InvalidWorkbasketException, NotAuthorizedException {
        LOGGER.debug("entry to getTaskSummariesByWorkbasketId(workbasketId = {}", (Object)workbasketKey);
        List<TaskSummary> results = new ArrayList<TaskSummary>();
        try {
            this.taskanaEngineImpl.openConnection();
            this.workbasketService.getWorkbasketByKey(workbasketKey);
            List<TaskSummaryImpl> taskSummaries = this.taskMapper.findTaskSummariesByWorkbasketKey(workbasketKey);
            results = this.augmentTaskSummariesByContainedSummaries(taskSummaries);
        }
        catch (WorkbasketNotFoundException ex) {
            throw ex;
        }
        catch (NotAuthorizedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Getting TASKSUMMARY failed internally.", (Throwable)ex);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = results.size();
                LOGGER.debug("exit from getTaskSummariesByWorkbasketId(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(results));
            }
        }
        return results;
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummaries(List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        ArrayList<TaskSummary> result = new ArrayList<TaskSummary>();
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return result;
        }
        this.addClassificationSummariesToTaskSummaries(taskSummaries);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries);
        result.addAll(taskSummaries);
        return result;
    }

    void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks) throws NotAuthorizedException {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        HashSet<String> classificationDomainSet = new HashSet<String>();
        HashSet<String> classificationKeySet = new HashSet<String>();
        for (TaskSummaryImpl task : tasks) {
            classificationDomainSet.add(task.getDomain());
            classificationKeySet.add(task.getClassificationSummary().getKey());
        }
        String[] classificationDomainArray = classificationDomainSet.toArray(new String[0]);
        String[] classificationKeyArray = classificationKeySet.toArray(new String[0]);
        List classifications = this.classificationService.createClassificationQuery().domain(classificationDomainArray).key(classificationKeyArray).list();
        for (TaskSummaryImpl task : tasks) {
            String taskClassKey = task.getClassificationSummary().getKey();
            String taskDomain = task.getDomain();
            ClassificationSummary aClassification = classifications.stream().filter(x -> taskClassKey != null && taskClassKey.equals(x.getKey()) && taskDomain != null && taskDomain.equals(x.getDomain())).findFirst().orElse(null);
            if (aClassification == null) {
                LOGGER.error("Could not find a Classification for task {}.", (Object)task.getTaskId());
                throw new SystemException("Could not find a Classification for task " + task.getTaskId());
            }
            task.setClassificationSummary(aClassification);
        }
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        Set<String> workbasketKeySet = taskSummaries.stream().map(t -> t.getWorkbasketSummary().getKey()).collect(Collectors.toSet());
        String[] workbasketKeyArray = workbasketKeySet.toArray(new String[0]);
        List workbaskets = this.workbasketService.createWorkbasketQuery().keyIn(workbasketKeyArray).list();
        for (TaskSummaryImpl task : taskSummaries) {
            String workbasketKey = task.getWorkbasketSummaryImpl().getKey();
            WorkbasketSummary aWorkbasket = workbaskets.stream().filter(x -> workbasketKey != null && workbasketKey.equals(x.getKey())).findFirst().orElse(null);
            if (aWorkbasket == null) {
                LOGGER.error("Could not find a Workbasket for task {}.", (Object)task.getTaskId());
                throw new SystemException("Could not find a Workbasket for task " + task.getTaskId());
            }
            task.setWorkbasketSummary(aWorkbasket);
        }
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        Set<String> taskIdSet = taskSummaries.stream().map(t -> t.getTaskId()).collect(Collectors.toSet());
        String[] taskIdArray = taskIdSet.toArray(new String[0]);
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIdArray);
        this.addClassificationSummariesToAttachmentSummaries(attachmentSummaries, taskSummaries);
        for (TaskSummaryImpl task : taskSummaries) {
            for (AttachmentSummaryImpl attachment : attachmentSummaries) {
                if (attachment.getTaskId() == null || !attachment.getTaskId().equals(task.getTaskId())) continue;
                task.addAttachmentSummary(attachment);
            }
        }
    }

    private void addClassificationSummariesToAttachmentSummaries(List<AttachmentSummaryImpl> attachmentSummaries, List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        if (attachmentSummaries == null || attachmentSummaries.isEmpty() || taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        Set<String> classificationDomainSet = taskSummaries.stream().map(t -> t.getDomain()).collect(Collectors.toSet());
        Set<String> classificationKeySet = attachmentSummaries.stream().map(t -> t.getClassificationSummary().getKey()).collect(Collectors.toSet());
        String[] classificationDomainArray = classificationDomainSet.toArray(new String[0]);
        String[] classificationKeyArray = classificationKeySet.toArray(new String[0]);
        List classifications = this.classificationService.createClassificationQuery().domain(classificationDomainArray).key(classificationKeyArray).list();
        for (AttachmentSummaryImpl att : attachmentSummaries) {
            TaskSummaryImpl aTaskSummary = taskSummaries.stream().filter(x -> x.getTaskId().equals(att.getTaskId())).findFirst().orElse(null);
            if (aTaskSummary == null) {
                LOGGER.error("Could not find a Task associated to attachment {}.", (Object)att);
                throw new SystemException("Could not find a Task associated to attachment " + att);
            }
            String domain = aTaskSummary.getDomain();
            String classificationKey = att.getClassificationSummary().getKey();
            ClassificationSummary aClassification = classifications.stream().filter(x -> classificationKey != null && classificationKey.equals(x.getKey()) && domain != null && domain.equals(x.getDomain())).findFirst().orElse(null);
            if (aClassification == null) {
                LOGGER.error("Could not find a Classification for attachment {}.", (Object)att);
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(aClassification);
        }
    }

    private List<Attachment> addClassificationSummariesToAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) {
        List classifications;
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            return null;
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        Set<String> classificationKeySet = attachmentImpls.stream().map(t -> t.getClassificationSummary().getKey()).collect(Collectors.toSet());
        String[] classificationKeyArray = classificationKeySet.toArray(new String[0]);
        try {
            classifications = this.classificationService.createClassificationQuery().domain(task.getDomain()).key(classificationKeyArray).list();
        }
        catch (NotAuthorizedException e) {
            LOGGER.error("ClassificationQuery unexpectedly returned NotauthorizedException. Throwing SystemException ");
            throw new SystemException("ClassificationQuery unexpectedly returned NotauthorizedException.");
        }
        for (AttachmentImpl att : attachmentImpls) {
            String domain = task.getDomain();
            String classificationKey = att.getClassificationSummary().getKey();
            ClassificationSummary aClassification = classifications.stream().filter(x -> classificationKey != null && classificationKey.equals(x.getKey()) && domain != null && domain.equals(x.getDomain())).findFirst().orElse(null);
            if (aClassification == null) {
                LOGGER.error("Could not find a Classification for attachment {}.", (Object)att);
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(aClassification);
            result.add(att);
        }
        return result;
    }

    @Override
    public Task newTask() {
        return new TaskImpl();
    }

    @Override
    public Attachment newAttachment() {
        return new AttachmentImpl();
    }

    private void validateObjectReference(ObjectReference objRef, String objRefType, String objName) throws InvalidArgumentException {
        if (objRef == null) {
            throw new InvalidArgumentException(objRefType + " of " + objName + " must not be null");
        }
        if (objRef.getCompany() == null || objRef.getCompany().length() == 0) {
            throw new InvalidArgumentException("Company of " + objRefType + " of " + objName + " must not be empty");
        }
        if (objRef.getSystem() == null || objRef.getSystem().length() == 0) {
            throw new InvalidArgumentException("System of " + objRefType + " of " + objName + " must not be empty");
        }
        if (objRef.getSystemInstance() == null || objRef.getSystemInstance().length() == 0) {
            throw new InvalidArgumentException("SystemInstance of " + objRefType + " of " + objName + " must not be empty");
        }
        if (objRef.getType() == null || objRef.getType().length() == 0) {
            throw new InvalidArgumentException("Type of " + objRefType + " of " + objName + " must not be empty");
        }
        if (objRef.getValue() == null || objRef.getValue().length() == 0) {
            throw new InvalidArgumentException("Value of" + objRefType + " of " + objName + " must not be empty");
        }
    }

    private void validateAttachments(TaskImpl task) throws InvalidArgumentException {
        List<Attachment> attachments = task.getAttachments();
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        for (Attachment attachment : attachments) {
            ObjectReference objRef = attachment.getObjectReference();
            this.validateObjectReference(objRef, "ObjectReference", "Attachment");
            if (attachment.getClassificationSummary() != null) continue;
            throw new InvalidArgumentException("Classification of attachment " + attachment + " must not be null");
        }
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws InvalidArgumentException, ConcurrencyException, WorkbasketNotFoundException, InvalidWorkbasketException, ClassificationNotFoundException, NotAuthorizedException {
        ClassificationSummary oldClassificationSummary;
        this.validateObjectReference(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException("The task has already been updated by another user");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getPlanned() == null) {
            newTaskImpl.setPlanned(oldTaskImpl.getPlanned());
        }
        if (newTaskImpl.getBusinessProcessId() == null) {
            newTaskImpl.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        ClassificationSummary newClassificationSummary = oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        String newClassificationKey = newTaskImpl.getClassificationKey();
        Classification newClassification = null;
        if (newClassificationKey != null && !newClassificationKey.equals(oldClassificationSummary.getKey())) {
            Workbasket workbasket = this.workbasketService.getWorkbasketByKey(newTaskImpl.getWorkbasketSummary().getKey());
            newClassification = this.classificationService.getClassification(newClassificationKey, workbasket.getDomain());
            newClassificationSummary = newClassification.asSummary();
        }
        newTaskImpl.setClassificationSummary(newClassificationSummary);
        if (newClassification != null) {
            if (newClassification.getServiceLevel() != null) {
                Duration serviceLevel = Duration.parse(newClassification.getServiceLevel());
                Instant due = newTaskImpl.getPlanned().plus(serviceLevel);
                newTaskImpl.setDue(due);
            }
            if (newTaskImpl.getName() == null) {
                newTaskImpl.setName(newClassification.getName());
            }
            if (newTaskImpl.getDescription() == null) {
                newTaskImpl.setDescription(newClassification.getDescription());
            }
            if (newTaskImpl.getPriority() == 0) {
                newTaskImpl.setPriority(newClassification.getPriority());
            }
        }
        newTaskImpl.setModified(Instant.now());
    }

    AttachmentMapper getAttachmentMapper() {
        return this.attachmentMapper;
    }
}

