/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketSummary;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.WorkbasketType;
import pro.taskana.model.mappings.WorkbasketAccessMapper;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketQueryImpl
implements WorkbasketQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryWorkbasket";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String[] accessId;
    private WorkbasketAuthorization authorization;
    private String[] name;
    private String[] key;
    private String[] domain;
    private WorkbasketType[] type;
    private Instant createdAfter;
    private Instant createdBefore;
    private Instant modifiedAfter;
    private Instant modifiedBefore;
    private String description;
    private String[] owner;
    private TaskanaEngineImpl taskanaEngineImpl;

    public WorkbasketQueryImpl(TaskanaEngine taskanaEngine, WorkbasketAccessMapper workbasketAccessMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
    }

    @Override
    public WorkbasketQuery keyIn(String ... key) {
        this.key = key;
        return this;
    }

    @Override
    public WorkbasketQuery domainIn(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public WorkbasketQuery typeIn(WorkbasketType ... type) {
        this.type = type;
        return this;
    }

    @Override
    public WorkbasketQuery nameIn(String ... names) {
        this.name = names;
        return this;
    }

    @Override
    public WorkbasketQuery createdAfter(Instant createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    @Override
    public WorkbasketQuery createdBefore(Instant createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedAfter(Instant modifiedAfter) {
        this.modifiedAfter = modifiedAfter;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedBefore(Instant modifiedBefore) {
        this.modifiedBefore = modifiedBefore;
        return this;
    }

    @Override
    public WorkbasketQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public WorkbasketQuery ownerIn(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public WorkbasketQuery accessIdsHavePersmission(WorkbasketAuthorization permission, String ... accessIds) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("Permission can\u00b4t be null.");
        }
        if (accessIds == null || accessIds.length == 0) {
            throw new InvalidArgumentException("accessIds can\u00b4t be NULL or empty.");
        }
        this.authorization = permission;
        this.accessId = accessIds;
        this.lowercaseAccessIds();
        return this;
    }

    @Override
    public WorkbasketQuery callerHasPermission(WorkbasketAuthorization permission) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("Permission cannot be null.");
        }
        List<String> ucAccessIds = CurrentUserContext.getAccessIds();
        if (ucAccessIds == null || ucAccessIds.size() <= 0) {
            throw new InvalidArgumentException("CurrentUserContext need to have at least one accessId.");
        }
        String[] accessIds = new String[ucAccessIds.size()];
        accessIds = ucAccessIds.toArray(accessIds);
        this.authorization = permission;
        this.accessId = accessIds;
        this.lowercaseAccessIds();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> list() {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List workbaskets = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = workbaskets = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> list(int offset, int limit) {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List workbaskets = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = workbaskets = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return list;
    }

    @Override
    public WorkbasketSummary single() {
        WorkbasketSummary workbasketSummary;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketSummary workbasket = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketSummary = workbasket = (WorkbasketSummary)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", workbasket);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)workbasket);
        return workbasketSummary;
    }

    public String[] getAccessId() {
        return this.accessId;
    }

    public WorkbasketAuthorization getAuthorization() {
        return this.authorization;
    }

    public String[] getName() {
        return this.name;
    }

    public String[] getKey() {
        return this.key;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public WorkbasketType[] getType() {
        return this.type;
    }

    public Instant getCreatedAfter() {
        return this.createdAfter;
    }

    public Instant getCreatedBefore() {
        return this.createdBefore;
    }

    public Instant getModifiedAfter() {
        return this.modifiedAfter;
    }

    public Instant getModifiedBefore() {
        return this.modifiedBefore;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketQueryImpl [accessId=");
        builder.append(Arrays.toString(this.accessId));
        builder.append(", authorization=");
        builder.append((Object)this.authorization);
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", key=");
        builder.append(Arrays.toString(this.key));
        builder.append(", domain=");
        builder.append(Arrays.toString(this.domain));
        builder.append(", type=");
        builder.append(Arrays.toString((Object[])this.type));
        builder.append(", createdAfter=");
        builder.append(this.createdAfter);
        builder.append(", createdBefore=");
        builder.append(this.createdBefore);
        builder.append(", modifiedAfter=");
        builder.append(this.modifiedAfter);
        builder.append(", modifiedBefore=");
        builder.append(this.modifiedBefore);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append("]");
        return builder.toString();
    }

    private void lowercaseAccessIds() {
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            for (int i = 0; i < this.accessId.length; ++i) {
                String id = this.accessId[i];
                if (id == null) continue;
                this.accessId[i] = id.toLowerCase();
            }
        }
    }
}

