/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.util;

import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LoggerUtils {
    private LoggerUtils() {
    }

    public static <T> String listToString(List<T> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (T t : list) {
            builder.append(t.toString());
            builder.append(";\n");
        }
        builder.append("]");
        return builder.toString();
    }

    public static <K, V> String mapToString(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        for (Map.Entry<K, V> entry : entrySet) {
            builder.append("(");
            builder.append(entry.getKey());
            builder.append(" , ");
            builder.append(entry.getValue());
            builder.append(")");
            builder.append(" , ");
        }
        builder.append("]");
        return builder.toString();
    }
}

