/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.DueWorkbasketCounter;
import pro.taskana.model.MonitorQueryItem;
import pro.taskana.model.Report;
import pro.taskana.model.ReportLine;
import pro.taskana.model.ReportLineItem;
import pro.taskana.model.ReportLineItemDefinition;
import pro.taskana.model.TaskState;
import pro.taskana.model.TaskStateCounter;
import pro.taskana.model.mappings.TaskMonitorMapper;

public class TaskMonitorServiceImpl
implements TaskMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMonitorMapper taskMonitorMapper;

    public TaskMonitorServiceImpl(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskStateCounter> getTaskCountForState(List<TaskState> states) {
        List<TaskStateCounter> list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountForState(states = {})", (Object)LoggerUtils.listToString(states));
        }
        List<TaskStateCounter> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = result = this.taskMonitorMapper.getTaskCountForState(states);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getTaskCountForState(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getTaskCountForState(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTaskCountForWorkbasketByDaysInPastAndState(String workbasketId, long daysInPast, List<TaskState> states) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountForWorkbasketByDaysInPastAndState(workbasketId {}, daysInPast={}, states = {})", new Object[]{workbasketId, daysInPast, LoggerUtils.listToString(states)});
        }
        long result = -1L;
        try {
            this.taskanaEngineImpl.openConnection();
            Instant fromDate = Instant.now().minus(Duration.ofDays(daysInPast));
            long l = result = this.taskMonitorMapper.getTaskCountForWorkbasketByDaysInPastAndState(workbasketId, fromDate, states);
            return l;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskCountForWorkbasketByDaysInPastAndState(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DueWorkbasketCounter> getTaskCountByWorkbasketAndDaysInPastAndState(long daysInPast, List<TaskState> states) {
        List<DueWorkbasketCounter> list;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast = {}, states = {})", (Object)daysInPast, (Object)LoggerUtils.listToString(states));
        }
        List<DueWorkbasketCounter> result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            Instant fromDate = Instant.now().minus(Duration.ofDays(daysInPast));
            list = result = this.taskMonitorMapper.getTaskCountByWorkbasketIdAndDaysInPastAndState(fromDate, states);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast,states). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getTaskCountByWorkbasketAndDaysInPastAndState(daysInPast,states). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public Report getWorkbasketLevelReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getWorkbasketLevelReport(workbaskets, states, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getWorkbasketLevelReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbasketLevelReport(workbaskets = {}, states = {}, reportLineItemDefinitions = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions)});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            Report report = new Report();
            report.setDetailLines(this.createEmptyDetailLinesForWorkbaskets(workbaskets, reportLineItemDefinitions));
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfWorkbasketsByWorkbasketsAndStates(workbaskets, states);
            for (MonitorQueryItem item : monitorQueryItems) {
                report.getDetailLines().get(item.getKey()).addNumberOfTasks(item);
            }
            report.setSumLine(this.createEmptyReportLine(reportLineItemDefinitions));
            report.generateSumLine();
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from getWorkbasketLevelReport().");
            }
        }
    }

    @Override
    public Report getCategoryReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getCategoryReport(workbaskets, states, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getCategoryReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCategoryReport(workbaskets = {}, states = {}, reportLineItemDefinitions = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions)});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCategoriesByWorkbasketsAndStates(workbaskets, states);
            for (MonitorQueryItem item : monitorQueryItems) {
                if (!report.getDetailLines().containsKey(item.getKey())) {
                    report.getDetailLines().put(item.getKey(), this.createEmptyReportLine(reportLineItemDefinitions));
                }
                report.getDetailLines().get(item.getKey()).addNumberOfTasks(item);
            }
            report.setSumLine(this.createEmptyReportLine(reportLineItemDefinitions));
            report.generateSumLine();
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from getCategoryReport().");
            }
        }
    }

    private ReportLine createEmptyReportLine(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        ReportLine reportLine = new ReportLine();
        if (reportLineItemDefinitions != null) {
            for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
                ReportLineItem reportLineItem = new ReportLineItem();
                reportLineItem.setReportLineItemDefinition(reportLineItemDefinition);
                reportLine.getLineItems().add(reportLineItem);
            }
        }
        return reportLine;
    }

    private Map<String, ReportLine> createEmptyDetailLinesForWorkbaskets(List<Workbasket> workbaskets, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        LinkedHashMap<String, ReportLine> detailLines = new LinkedHashMap<String, ReportLine>();
        for (Workbasket workbasket : workbaskets) {
            ReportLine reportLine = this.createEmptyReportLine(reportLineItemDefinitions);
            detailLines.put(workbasket.getKey(), reportLine);
        }
        return detailLines;
    }
}

