/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.TaskQuery;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.ObjectReferenceQueryImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.TaskState;
import pro.taskana.model.WorkbasketAuthorization;

public class TaskQueryImpl
implements TaskQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryTasks";
    private static final String LINK_TO_COUNTER = "pro.taskana.model.mappings.QueryMapper.countQueryTasks";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueryImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskServiceImpl taskService;
    private String[] name;
    private String description;
    private String note;
    private int[] priority;
    private TaskState[] states;
    private String[] classificationKey;
    private String[] workbasketKey;
    private String[] domain;
    private String[] owner;
    private Boolean isRead;
    private Boolean isTransferred;
    private String[] customFields;
    private String[] porCompanyIn;
    private String porCompanyLike;
    private String[] porSystemIn;
    private String porSystemLike;
    private String[] porSystemInstanceIn;
    private String porSystemInstanceLike;
    private String[] porTypeIn;
    private String porTypeLike;
    private String[] porValueIn;
    private String porValueLike;

    public TaskQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
    }

    @Override
    public TaskQuery nameIn(String ... names) {
        this.name = names;
        return this;
    }

    @Override
    public TaskQuery descriptionLike(String description) {
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery noteLike(String note) {
        this.note = note;
        return this;
    }

    @Override
    public TaskQuery priorityIn(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public TaskQuery stateIn(TaskState ... states) {
        this.states = states;
        return this;
    }

    @Override
    public TaskQuery classificationKeyIn(String ... classificationKey) {
        this.classificationKey = classificationKey;
        return this;
    }

    @Override
    public TaskQuery workbasketKeyIn(String ... workbasketKeys) {
        this.workbasketKey = workbasketKeys;
        return this;
    }

    @Override
    public TaskQuery domainIn(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public TaskQuery ownerIn(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyIn(String ... companies) {
        this.porCompanyIn = companies;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyLike(String company) {
        this.porCompanyLike = company;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemIn(String ... systems) {
        this.porSystemIn = systems;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemLike(String system) {
        this.porSystemLike = system;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceIn(String ... systemInstances) {
        this.porSystemInstanceIn = systemInstances;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceLike(String systemInstance) {
        this.porSystemInstanceLike = systemInstance;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeIn(String ... types) {
        this.porTypeIn = types;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeLike(String type) {
        this.porTypeLike = type;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueIn(String ... values) {
        this.porValueIn = values;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueLike(String value) {
        this.porValueLike = value;
        return this;
    }

    @Override
    public TaskQuery readEquals(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    @Override
    public TaskQuery transferredEquals(Boolean isTransferred) {
        this.isTransferred = isTransferred;
        return this;
    }

    @Override
    public TaskQuery customFieldsIn(String ... customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    public ObjectReferenceQuery createObjectReferenceQuery() {
        return new ObjectReferenceQueryImpl(this.taskanaEngineImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> list() throws NotAuthorizedException {
        ArrayList<TaskSummary> arrayList;
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            LOGGER.debug("entry to list(), this = {}", (Object)this);
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            ArrayList<TaskSummaryImpl> tasks = new ArrayList();
            tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<TaskSummary> list(int offset, int limit) throws NotAuthorizedException {
        ArrayList<TaskSummary> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Exception e) {
            try {
                if (e instanceof PersistenceException && e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskSummary single() throws NotAuthorizedException {
        TaskSummaryImpl taskSummaryImpl;
        TaskSummary result;
        block3: {
            TaskSummary taskSummary;
            LOGGER.debug("entry to single(), this = {}", (Object)this);
            result = null;
            try {
                this.taskanaEngineImpl.openConnection();
                this.checkOpenPermissionForWorkbasketKey();
                taskSummaryImpl = (TaskSummaryImpl)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
                if (taskSummaryImpl != null) break block3;
                taskSummary = null;
                this.taskanaEngineImpl.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                LOGGER.debug("exit from single(). Returning result {} ", result);
                throw throwable;
            }
            LOGGER.debug("exit from single(). Returning result {} ", result);
            return taskSummary;
        }
        ArrayList<TaskSummaryImpl> tasks = new ArrayList<TaskSummaryImpl>();
        tasks.add(taskSummaryImpl);
        List<TaskSummary> augmentedList = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
        TaskSummary taskSummary = result = augmentedList.get(0);
        this.taskanaEngineImpl.returnConnection();
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws NotAuthorizedException {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            rowCount = (Long)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private void checkOpenPermissionForWorkbasketKey() throws NotAuthorizedException {
        if (this.workbasketKey != null && this.workbasketKey.length > 0) {
            for (String wbKey : this.workbasketKey) {
                this.taskanaEngineImpl.getWorkbasketService().checkAuthorization(wbKey, WorkbasketAuthorization.OPEN);
            }
        }
    }

    public TaskanaEngineImpl getTaskanaEngine() {
        return this.taskanaEngineImpl;
    }

    public void setTaskanaEngine(TaskanaEngineImpl taskanaEngine) {
        this.taskanaEngineImpl = taskanaEngine;
    }

    public String[] getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public TaskState[] getStates() {
        return this.states;
    }

    public String[] getClassificationKey() {
        return this.classificationKey;
    }

    public String[] getWorkbasketKey() {
        return this.workbasketKey;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public Boolean getIsTransferred() {
        return this.isTransferred;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public String getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public String getPorSystemLike() {
        return this.porSystemLike;
    }

    public String[] getPorSystemInstanceIn() {
        return this.porSystemInstanceIn;
    }

    public String getPorSystemInstanceLike() {
        return this.porSystemInstanceLike;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public String getPorTypeLike() {
        return this.porTypeLike;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public String getPorValueLike() {
        return this.porValueLike;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskQueryImpl [taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append(", name=");
        builder.append(Arrays.toString(this.name));
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", note=");
        builder.append(this.note);
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", states=");
        builder.append(Arrays.toString((Object[])this.states));
        builder.append(", classificationKey=");
        builder.append(Arrays.toString(this.classificationKey));
        builder.append(", workbasketKey=");
        builder.append(Arrays.toString(this.workbasketKey));
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append(", isRead=");
        builder.append(this.isRead);
        builder.append(", isTransferred=");
        builder.append(this.isTransferred);
        builder.append(", customFields=");
        builder.append(Arrays.toString(this.customFields));
        builder.append(", porCompanyIn=");
        builder.append(Arrays.toString(this.porCompanyIn));
        builder.append(", porCompanyLike=");
        builder.append(this.porCompanyLike);
        builder.append(", porSystemIn=");
        builder.append(Arrays.toString(this.porSystemIn));
        builder.append(", porSystemLike=");
        builder.append(this.porSystemLike);
        builder.append(", porSystemInstanceIn=");
        builder.append(Arrays.toString(this.porSystemInstanceIn));
        builder.append(", porSystemInstanceLike=");
        builder.append(this.porSystemInstanceLike);
        builder.append(", porTypeIn=");
        builder.append(Arrays.toString(this.porTypeIn));
        builder.append(", porTypeLike=");
        builder.append(this.porTypeLike);
        builder.append(", porValueIn=");
        builder.append(Arrays.toString(this.porValueIn));
        builder.append(", porValueLike=");
        builder.append(this.porValueLike);
        builder.append("]");
        return builder.toString();
    }
}

