/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketSummary;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidRequestException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.WorkbasketType;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketQueryImpl
implements WorkbasketQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.model.mappings.QueryMapper.queryWorkbasket";
    private static final String LINK_TO_COUNTER = "pro.taskana.model.mappings.QueryMapper.countQueryWorkbaskets";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private static final String KEY_COL_NAME = "KEY";
    private static final String NAME_COL_NAME = "NAME";
    private static final String ASCENDING = " ASC";
    private static final String DESCENDING = " DESC";
    private static final String ORDER_BY = "ORDER BY ";
    private String[] accessId;
    private WorkbasketAuthorization authorization;
    private String[] nameIn;
    private String[] nameLike;
    private String[] keyIn;
    private String[] keyLike;
    private String[] keyOrNameLike;
    private String[] domain;
    private WorkbasketType[] type;
    private Instant createdAfter;
    private Instant createdBefore;
    private Instant modifiedAfter;
    private Instant modifiedBefore;
    private String descriptionLike;
    private String[] owner;
    private String orderClause;
    private TaskanaEngineImpl taskanaEngineImpl;

    public WorkbasketQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.orderClause = "";
    }

    @Override
    public WorkbasketQuery keyIn(String ... key) {
        this.keyIn = this.toUpperCopy(key);
        return this;
    }

    @Override
    public WorkbasketQuery domainIn(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public WorkbasketQuery typeIn(WorkbasketType ... type) {
        this.type = type;
        return this;
    }

    @Override
    public WorkbasketQuery nameIn(String ... names) {
        this.nameIn = this.toUpperCopy(names);
        return this;
    }

    @Override
    public WorkbasketQuery nameLike(String ... names) {
        this.nameLike = this.toUpperCopy(names);
        return this;
    }

    @Override
    public WorkbasketQuery keyLike(String ... keys) {
        this.keyLike = this.toUpperCopy(keys);
        return this;
    }

    @Override
    public WorkbasketQuery keyOrNameLike(String ... keysOrNames) {
        this.keyOrNameLike = this.toUpperCopy(keysOrNames);
        return this;
    }

    @Override
    public WorkbasketQuery createdAfter(Instant createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    @Override
    public WorkbasketQuery createdBefore(Instant createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedAfter(Instant modifiedAfter) {
        this.modifiedAfter = modifiedAfter;
        return this;
    }

    @Override
    public WorkbasketQuery modifiedBefore(Instant modifiedBefore) {
        this.modifiedBefore = modifiedBefore;
        return this;
    }

    @Override
    public WorkbasketQuery descriptionLike(String description) {
        this.descriptionLike = description.toUpperCase();
        return this;
    }

    @Override
    public WorkbasketQuery ownerIn(String ... owners) {
        this.owner = owners;
        return this;
    }

    @Override
    public WorkbasketQuery orderByName() throws InvalidRequestException {
        if (this.orderClause.contains(NAME_COL_NAME)) {
            throw new InvalidRequestException("orderByName() has already been called");
        }
        if (this.orderClause.isEmpty()) {
            this.orderClause = "ORDER BY NAME";
        } else if (this.orderClause.contains(ORDER_BY)) {
            this.orderClause = this.orderClause + ", NAME";
        } else {
            throw new SystemException("orderByName() was called, but orderClause is unexpectedly: " + this.orderClause);
        }
        return this;
    }

    @Override
    public WorkbasketQuery orderByKey() throws InvalidRequestException {
        if (this.orderClause.contains(KEY_COL_NAME)) {
            throw new InvalidRequestException("orderByKey() has already been called");
        }
        if (this.orderClause.isEmpty()) {
            this.orderClause = "ORDER BY KEY";
        } else if (this.orderClause.contains(ORDER_BY)) {
            this.orderClause = this.orderClause + ", KEY";
        } else {
            throw new SystemException("orderByKey() was called, but orderClause is unexpectedly: " + this.orderClause);
        }
        return this;
    }

    @Override
    public WorkbasketQuery ascending() throws InvalidRequestException {
        if (!this.orderClause.startsWith(ORDER_BY)) {
            throw new InvalidRequestException("ascending() has been called before orderByKey() or orderByName() was called");
        }
        if (!this.orderClause.endsWith(KEY_COL_NAME) && !this.orderClause.endsWith(NAME_COL_NAME)) {
            if (this.orderClause.endsWith(ASCENDING) || this.orderClause.endsWith(DESCENDING)) {
                throw new InvalidRequestException("ascending() has been called immediately after ascending() or descending()");
            }
            throw new SystemException("ascending() was called, but orderClause is unexpectedly: " + this.orderClause);
        }
        this.orderClause = this.orderClause + ASCENDING;
        return this;
    }

    @Override
    public WorkbasketQuery descending() throws InvalidRequestException {
        if (!this.orderClause.startsWith(ORDER_BY)) {
            throw new InvalidRequestException("descending() has been called before orderByKey or orderByName was called");
        }
        if (!this.orderClause.endsWith(KEY_COL_NAME) && !this.orderClause.endsWith(NAME_COL_NAME)) {
            if (this.orderClause.endsWith(ASCENDING) || this.orderClause.endsWith(DESCENDING)) {
                throw new InvalidRequestException("descending() has been called immediately after ascending() or descending()");
            }
            throw new SystemException("descending() was called, but orderClause is unexpectedly: " + this.orderClause);
        }
        this.orderClause = this.orderClause + DESCENDING;
        return this;
    }

    @Override
    public WorkbasketQuery accessIdsHavePermission(WorkbasketAuthorization permission, String ... accessIds) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("Permission can\u00b4t be null.");
        }
        if (accessIds == null || accessIds.length == 0) {
            throw new InvalidArgumentException("accessIds can\u00b4t be NULL or empty.");
        }
        this.authorization = permission;
        this.accessId = accessIds;
        this.lowercaseAccessIds();
        return this;
    }

    @Override
    public WorkbasketQuery callerHasPermission(WorkbasketAuthorization permission) throws InvalidArgumentException {
        if (permission == null) {
            throw new InvalidArgumentException("Permission cannot be null.");
        }
        List<String> ucAccessIds = CurrentUserContext.getAccessIds();
        if (ucAccessIds == null || ucAccessIds.isEmpty()) {
            throw new InvalidArgumentException("CurrentUserContext need to have at least one accessId.");
        }
        String[] accessIds = new String[ucAccessIds.size()];
        accessIds = ucAccessIds.toArray(accessIds);
        this.authorization = permission;
        this.accessId = accessIds;
        this.lowercaseAccessIds();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> list() {
        List list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List workbaskets = null;
        try {
            this.taskanaEngineImpl.openConnection();
            list = workbaskets = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return list;
    }

    @Override
    public List<WorkbasketSummary> list(int offset, int limit) {
        List list;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        List workbaskets = null;
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            list = workbaskets = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Exception e) {
            try {
                if (e instanceof PersistenceException && e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return list;
    }

    @Override
    public WorkbasketSummary single() {
        WorkbasketSummary workbasketSummary;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketSummary workbasket = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketSummary = workbasket = (WorkbasketSummary)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", workbasket);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)workbasket);
        return workbasketSummary;
    }

    public String[] getAccessId() {
        return this.accessId;
    }

    public WorkbasketAuthorization getAuthorization() {
        return this.authorization;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getKeyIn() {
        return this.keyIn;
    }

    public String[] getKeyLike() {
        return this.keyLike;
    }

    public String[] getKeyOrNameLike() {
        return this.keyOrNameLike;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public WorkbasketType[] getType() {
        return this.type;
    }

    public Instant getCreatedAfter() {
        return this.createdAfter;
    }

    public Instant getCreatedBefore() {
        return this.createdBefore;
    }

    public Instant getModifiedAfter() {
        return this.modifiedAfter;
    }

    public Instant getModifiedBefore() {
        return this.modifiedBefore;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public String[] getOwner() {
        return this.owner;
    }

    public String getOrderClause() {
        return this.orderClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws NotAuthorizedException {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngineImpl.openConnection();
            rowCount = (Long)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketQueryImpl [accessId=");
        builder.append(Arrays.toString(this.accessId));
        builder.append(", authorization=");
        builder.append((Object)this.authorization);
        builder.append(", nameIn=");
        builder.append(Arrays.toString(this.nameIn));
        builder.append(", nameLike=");
        builder.append(Arrays.toString(this.nameLike));
        builder.append(", keyIn=");
        builder.append(Arrays.toString(this.keyIn));
        builder.append(", keyLike=");
        builder.append(Arrays.toString(this.keyLike));
        builder.append(", keyOrNameLike=");
        builder.append(Arrays.toString(this.keyOrNameLike));
        builder.append(", domain=");
        builder.append(Arrays.toString(this.domain));
        builder.append(", type=");
        builder.append(Arrays.toString((Object[])this.type));
        builder.append(", createdAfter=");
        builder.append(this.createdAfter);
        builder.append(", createdBefore=");
        builder.append(this.createdBefore);
        builder.append(", modifiedAfter=");
        builder.append(this.modifiedAfter);
        builder.append(", modifiedBefore=");
        builder.append(this.modifiedBefore);
        builder.append(", descriptionLike=");
        builder.append(this.descriptionLike);
        builder.append(", owner=");
        builder.append(Arrays.toString(this.owner));
        builder.append(", taskanaEngineImpl=");
        builder.append(this.taskanaEngineImpl);
        builder.append("]");
        return builder.toString();
    }

    private void lowercaseAccessIds() {
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            for (int i = 0; i < this.accessId.length; ++i) {
                String id = this.accessId[i];
                if (id == null) continue;
                this.accessId[i] = id.toLowerCase();
            }
        }
    }

    private String[] toUpperCopy(String ... source) {
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }
}

