/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketAccessItemImpl;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.WorkbasketSummaryImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.model.WorkbasketAuthorization;
import pro.taskana.model.mappings.DistributionTargetMapper;
import pro.taskana.model.mappings.WorkbasketAccessMapper;
import pro.taskana.model.mappings.WorkbasketMapper;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketServiceImpl
implements WorkbasketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketServiceImpl.class);
    private static final String ID_PREFIX_WORKBASKET = "WBI";
    private static final String ID_PREFIX_WORKBASKET_AUTHORIZATION = "WAI";
    private TaskanaEngineImpl taskanaEngine;
    private WorkbasketMapper workbasketMapper;
    private DistributionTargetMapper distributionTargetMapper;
    private WorkbasketAccessMapper workbasketAccessMapper;

    public WorkbasketServiceImpl() {
    }

    public WorkbasketServiceImpl(TaskanaEngine taskanaEngine, WorkbasketMapper workbasketMapper, DistributionTargetMapper distributionTargetMapper, WorkbasketAccessMapper workbasketAccessMapper) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.workbasketMapper = workbasketMapper;
        this.distributionTargetMapper = distributionTargetMapper;
        this.workbasketAccessMapper = workbasketAccessMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasket(String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getWorkbasket(workbasketId = {})", (Object)workbasketId);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.workbasketMapper.findById(workbasketId);
            if (result == null) {
                LOGGER.error("Method getWorkbasket() didn't find workbasket with ID {}. Throwing WorkbasketNotFoundException", (Object)workbasketId);
                throw new WorkbasketNotFoundException(workbasketId);
            }
            this.checkAuthorization(result.getKey(), WorkbasketAuthorization.READ);
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasketByKey(String workbasketKey) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getWorkbasketByKey(workbasketKey = {})", (Object)workbasketKey);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.workbasketMapper.findByKey(workbasketKey);
            if (result == null) {
                LOGGER.error("Method getWorkbasketByKey() didn't find workbasket with key {}. Throwing WorkbasketNotFoundException", (Object)workbasketKey);
                throw new WorkbasketNotFoundException(workbasketKey);
            }
            this.checkAuthorization(workbasketKey, WorkbasketAuthorization.READ);
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getWorkbaskets(List<WorkbasketAuthorization> permissions) {
        ArrayList<WorkbasketSummaryImpl> arrayList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbaskets(permissions = {})", (Object)LoggerUtils.listToString(permissions));
        }
        ArrayList<WorkbasketSummaryImpl> result = null;
        try {
            this.taskanaEngine.openConnection();
            HashSet<WorkbasketSummaryImpl> workbaskets = new HashSet<WorkbasketSummaryImpl>();
            for (String accessId : CurrentUserContext.getAccessIds()) {
                workbaskets.addAll(this.workbasketMapper.findByPermission(permissions, accessId));
            }
            result = new ArrayList<WorkbasketSummaryImpl>();
            result.addAll(workbaskets);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getWorkbaskets() {
        LOGGER.debug("entry to getWorkbaskets()");
        ArrayList<WorkbasketSummaryImpl> workbaskets = new ArrayList<WorkbasketSummaryImpl>();
        try {
            this.taskanaEngine.openConnection();
            List<WorkbasketSummaryImpl> workbasketImpls = this.workbasketMapper.findAll();
            for (WorkbasketSummaryImpl workbasketSummaryImpl : workbasketImpls) {
                workbaskets.add(workbasketSummaryImpl);
            }
            ArrayList<WorkbasketSummaryImpl> arrayList = workbaskets;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets.size();
                LOGGER.debug("exit from getWorkbaskets(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket createWorkbasket(Workbasket newWorkbasket) throws InvalidWorkbasketException {
        WorkbasketImpl workbasketImpl;
        LOGGER.debug("entry to createtWorkbasket(workbasket)", (Object)newWorkbasket);
        WorkbasketImpl result = null;
        WorkbasketImpl workbasket = (WorkbasketImpl)newWorkbasket;
        try {
            this.taskanaEngine.openConnection();
            Instant now = Instant.now();
            workbasket.setCreated(now);
            workbasket.setModified(now);
            if (workbasket.getId() == null || workbasket.getId().isEmpty()) {
                workbasket.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET));
            }
            this.validateWorkbasket(workbasket);
            this.workbasketMapper.insert(workbasket);
            LOGGER.debug("Method createWorkbasket() created Workbasket '{}'", (Object)workbasket);
            workbasketImpl = result = this.workbasketMapper.findById(workbasket.getId());
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", (Object)result);
        return workbasketImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket updateWorkbasket(Workbasket workbasketToUpdate) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidWorkbasketException {
        WorkbasketImpl workbasketImpl;
        LOGGER.debug("entry to updateWorkbasket(workbasket)", (Object)workbasketToUpdate);
        WorkbasketImpl result = null;
        WorkbasketImpl workbasket = (WorkbasketImpl)workbasketToUpdate;
        try {
            this.taskanaEngine.openConnection();
            workbasket.setModified(Instant.now());
            this.workbasketMapper.update(workbasket);
            LOGGER.debug("Method updateWorkbasket() updated workbasket '{}'", (Object)workbasket.getId());
            workbasketImpl = result = this.workbasketMapper.findById(workbasket.getId());
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", (Object)result);
        return workbasketImpl;
    }

    @Override
    public WorkbasketAccessItem newWorkbasketAccessItem(String workbasketKey, String accessId) {
        WorkbasketAccessItemImpl accessItem = new WorkbasketAccessItemImpl();
        accessItem.setWorkbasketKey(workbasketKey);
        accessItem.setAccessId(accessId);
        return accessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem createWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) {
        LOGGER.debug("entry to createWorkbasketAuthorization(workbasketAccessItem = {})", (Object)workbasketAccessItem);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.taskanaEngine.openConnection();
            accessItem.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET_AUTHORIZATION));
            this.workbasketAccessMapper.insert(accessItem);
            LOGGER.debug("Method createWorkbasketAuthorization() created workbaskteAccessItem {}", (Object)accessItem);
            WorkbasketAccessItemImpl workbasketAccessItemImpl = accessItem;
            return workbasketAccessItemImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createWorkbasketAuthorization(workbasketAccessItem). Returning result {}", (Object)accessItem);
        }
    }

    @Override
    public void deleteWorkbasketAuthorization(String id) {
        LOGGER.debug("entry to deleteWorkbasketAuthorization(id = {})", (Object)id);
        try {
            this.taskanaEngine.openConnection();
            this.workbasketAccessMapper.delete(id);
            LOGGER.debug("Method deleteWorkbasketAuthorization() deleted workbasketAccessItem wit Id {}", (Object)id);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteWorkbasketAuthorization(id).");
        }
    }

    @Override
    public void checkAuthorization(String workbasketKey, WorkbasketAuthorization workbasketAuthorization) throws NotAuthorizedException {
        this.checkAuthorization(workbasketKey, null, workbasketAuthorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem updateWorkbasketAuthorization(WorkbasketAccessItem workbasketAccessItem) throws InvalidArgumentException {
        LOGGER.debug("entry to updateWorkbasketAuthorization(workbasketAccessItem = {}", (Object)workbasketAccessItem);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.taskanaEngine.openConnection();
            WorkbasketAccessItemImpl originalItem = this.workbasketAccessMapper.findById(accessItem.getId());
            if (originalItem.getAccessId() != null && !originalItem.getAccessId().equals(accessItem.getAccessId()) || originalItem.getWorkbasketKey() != null && !originalItem.getWorkbasketKey().equals(accessItem.getWorkbasketKey())) {
                throw new InvalidArgumentException("AccessId and Workbasketkey must not be changed in updateWorkbasketAuthorization calls");
            }
            this.workbasketAccessMapper.update(accessItem);
            LOGGER.debug("Method updateWorkbasketAuthorization() updated workbasketAccessItem {}", (Object)accessItem);
            WorkbasketAccessItemImpl workbasketAccessItemImpl = accessItem;
            return workbasketAccessItemImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from updateWorkbasketAuthorization(workbasketAccessItem). Returning {}", (Object)accessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getWorkbasketAuthorizations(String workbasketKey) {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to getWorkbasketAuthorizations(workbasketId = {})", (Object)workbasketKey);
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngine.openConnection();
            List<WorkbasketAccessItemImpl> queryResult = this.workbasketAccessMapper.findByWorkbasketKey(workbasketKey);
            result.addAll(queryResult);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbasketAuthorizations(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<WorkbasketAuthorization> getPermissionsForWorkbasket(String workbasketKey) {
        ArrayList<WorkbasketAuthorization> permissions = new ArrayList<WorkbasketAuthorization>();
        WorkbasketAccessItemImpl wbAcc = this.workbasketAccessMapper.findByWorkbasketAndAccessId(workbasketKey, CurrentUserContext.getAccessIds());
        this.addWorkbasketAccessItemValuesToPermissionSet(wbAcc, permissions);
        return permissions;
    }

    @Override
    public WorkbasketQuery createWorkbasketQuery() {
        return new WorkbasketQueryImpl(this.taskanaEngine);
    }

    private void validateWorkbasket(Workbasket workbasket) throws InvalidWorkbasketException {
        if (workbasket.getId() == null || workbasket.getId().length() == 0) {
            throw new InvalidWorkbasketException("Id must not be null for " + workbasket);
        }
        if (workbasket.getKey() == null || workbasket.getKey().length() == 0) {
            throw new InvalidWorkbasketException("Key must not be null for " + workbasket);
        }
        if (workbasket.getName() == null || workbasket.getName().length() == 0) {
            throw new InvalidWorkbasketException("Name must not be null for " + workbasket);
        }
        if (workbasket.getDomain() == null) {
            throw new InvalidWorkbasketException("Domain must not be null for " + workbasket);
        }
        if (workbasket.getType() == null) {
            throw new InvalidWorkbasketException("Type must not be null for " + workbasket);
        }
    }

    private void addWorkbasketAccessItemValuesToPermissionSet(WorkbasketAccessItem workbasketAccessItem, List<WorkbasketAuthorization> permissions) {
        if (workbasketAccessItem.isPermOpen()) {
            permissions.add(WorkbasketAuthorization.OPEN);
        }
        if (workbasketAccessItem.isPermRead()) {
            permissions.add(WorkbasketAuthorization.READ);
        }
        if (workbasketAccessItem.isPermAppend()) {
            permissions.add(WorkbasketAuthorization.APPEND);
        }
        if (workbasketAccessItem.isPermTransfer()) {
            permissions.add(WorkbasketAuthorization.TRANSFER);
        }
        if (workbasketAccessItem.isPermDistribute()) {
            permissions.add(WorkbasketAuthorization.DISTRIBUTE);
        }
        if (workbasketAccessItem.isPermCustom1()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_1);
        }
        if (workbasketAccessItem.isPermCustom2()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_2);
        }
        if (workbasketAccessItem.isPermCustom3()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_3);
        }
        if (workbasketAccessItem.isPermCustom4()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_4);
        }
        if (workbasketAccessItem.isPermCustom5()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_5);
        }
        if (workbasketAccessItem.isPermCustom6()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_6);
        }
        if (workbasketAccessItem.isPermCustom7()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_7);
        }
        if (workbasketAccessItem.isPermCustom8()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_8);
        }
        if (workbasketAccessItem.isPermCustom9()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_9);
        }
        if (workbasketAccessItem.isPermCustom10()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_10);
        }
        if (workbasketAccessItem.isPermCustom11()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_11);
        }
        if (workbasketAccessItem.isPermCustom12()) {
            permissions.add(WorkbasketAuthorization.CUSTOM_12);
        }
    }

    @Override
    public Workbasket newWorkbasket(String key) {
        WorkbasketImpl wb = new WorkbasketImpl();
        wb.setKey(key);
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getDistributionTargets(String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to getDistributionTargets(workbasketId = {})", (Object)workbasketId);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.taskanaEngine.openConnection();
            this.getWorkbasket(workbasketId);
            this.checkAuthorizationByWorkbasketId(workbasketId, WorkbasketAuthorization.READ);
            List<WorkbasketSummaryImpl> distributionTargets = this.workbasketMapper.findByDistributionTargets(workbasketId);
            result.addAll(distributionTargets);
            ArrayList<WorkbasketSummary> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result.size();
                LOGGER.debug("exit from getDistributionTargets(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDistributionTargets(String sourceWorkbasketId, List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setDistributionTargets(sourceWorkbasketId = {}, targetWorkazketIds = {})", (Object)sourceWorkbasketId, (Object)LoggerUtils.listToString(targetWorkbasketIds));
        }
        try {
            this.taskanaEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            this.checkAuthorizationByWorkbasketId(sourceWorkbasketId, WorkbasketAuthorization.READ);
            this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(sourceWorkbasketId);
            sourceWorkbasket.setModified(Instant.now());
            this.workbasketMapper.update(sourceWorkbasket);
            if (targetWorkbasketIds != null) {
                for (String targetId : targetWorkbasketIds) {
                    this.getWorkbasket(targetId);
                    this.distributionTargetMapper.insert(sourceWorkbasketId, targetId);
                    LOGGER.debug("Method setDistributionTargets() created distributiontarget for source '{}' and target {}", (Object)sourceWorkbasketId, (Object)targetId);
                }
            }
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to addDistributionTarget(sourceWorkbasketId = {}, targetWorkbasketId = {})", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
        try {
            this.taskanaEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            this.getWorkbasket(targetWorkbasketId);
            this.checkAuthorizationByWorkbasketId(sourceWorkbasketId, WorkbasketAuthorization.READ);
            int numOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numOfDistTargets > 0) {
                LOGGER.debug("addDistributionTarget detected that the specified distribution target exists already. Doing nothing...");
            } else {
                this.distributionTargetMapper.insert(sourceWorkbasketId, targetWorkbasketId);
                LOGGER.debug("addDistributionTarget inserted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                sourceWorkbasket.setModified(Instant.now());
                this.workbasketMapper.update(sourceWorkbasket);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from addDistributionTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws NotAuthorizedException {
        LOGGER.debug("entry to removeDistributionTarget(sourceWorkbasketId = {}, targetWorkbasketId = {})", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
        try {
            this.taskanaEngine.openConnection();
            this.checkAuthorizationByWorkbasketId(sourceWorkbasketId, WorkbasketAuthorization.READ);
            int numberOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numberOfDistTargets > 0) {
                this.distributionTargetMapper.delete(sourceWorkbasketId, targetWorkbasketId);
                LOGGER.debug("removeDistributionTarget deleted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                try {
                    WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
                    sourceWorkbasket.setModified(Instant.now());
                    this.workbasketMapper.update(sourceWorkbasket);
                }
                catch (WorkbasketNotFoundException e) {
                    LOGGER.debug("removeDistributionTarget found that the source workbasket {} doesn't exist. Ignoring the request... ", (Object)sourceWorkbasketId);
                }
            } else {
                LOGGER.debug("removeDistributionTarget detected that the specified distribution target doesn't exist. Doing nothing...");
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from addDistributionTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWorkbasket(String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException {
        LOGGER.debug("entry to deleteWorkbasket(workbasketId = {})", (Object)workbasketId);
        try {
            this.taskanaEngine.openConnection();
            if (workbasketId == null || workbasketId.isEmpty()) {
                throw new InvalidArgumentException("The WorkbasketId can\u00b4t be NULL or EMPTY for deleteWorkbasket()");
            }
            Workbasket wb = this.getWorkbasket(workbasketId);
            List taskUsages = this.taskanaEngine.getTaskService().createTaskQuery().workbasketKeyIn(wb.getKey()).list();
            if (taskUsages == null || taskUsages.size() > 0) {
                throw new WorkbasketInUseException("Workbasket is used on tasks and can\u00b4t be deleted. WorkbasketId=" + workbasketId);
            }
            this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(wb.getId());
            this.distributionTargetMapper.deleteAllDistributionTargetsByTargetId(wb.getId());
            this.workbasketAccessMapper.deleteAllForWorkbasketkey(wb.getKey());
            this.workbasketMapper.delete(workbasketId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteWorkbasket(workbasketId = {})", (Object)workbasketId);
        }
    }

    private void checkAuthorizationByWorkbasketId(String workbasketId, WorkbasketAuthorization workbasketAuthorization) throws NotAuthorizedException {
        this.checkAuthorization(null, workbasketId, workbasketAuthorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuthorization(String workbasketKey, String workbasketId, WorkbasketAuthorization workbasketAuthorization) throws NotAuthorizedException {
        LOGGER.debug("entry to checkAuthorization(workbasketId = {}, workbasketAuthorization = {})", (Object)workbasketKey, (Object)workbasketAuthorization);
        if (workbasketAuthorization == null && workbasketKey == null || workbasketAuthorization == null) {
            throw new SystemException("checkAuthorization was called with an invalid parameter combination");
        }
        boolean isAuthorized = false;
        try {
            List<WorkbasketAccessItemImpl> accessItems;
            this.taskanaEngine.openConnection();
            if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
                LOGGER.debug("Skipping permissions check since security is disabled.");
                isAuthorized = true;
                return;
            }
            List<String> accessIds = CurrentUserContext.getAccessIds();
            LOGGER.debug("checkAuthorization: Verifying that {} has the permission {} on workbasket {}", new Object[]{CurrentUserContext.getUserid(), workbasketAuthorization == null ? "null" : workbasketAuthorization.name(), workbasketKey});
            if (workbasketKey != null) {
                accessItems = this.workbasketAccessMapper.findByWorkbasketAndAccessIdAndAuthorization(workbasketKey, accessIds, workbasketAuthorization.name());
            } else if (workbasketId != null) {
                accessItems = this.workbasketAccessMapper.findByWorkbasketAndAccessIdAndAuthorizationsById(workbasketId, accessIds, workbasketAuthorization.name());
            } else {
                throw new SystemException("checkAuthorizationImpl was called with both workbasketKey and workbasketId set to null");
            }
            if (accessItems.isEmpty()) {
                throw new NotAuthorizedException("Not authorized. Authorization '" + workbasketAuthorization.name() + "' on workbasket '" + workbasketKey + "' is needed.");
            }
            isAuthorized = true;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from checkAuthorization(). User is authorized = {}.", (Object)isAuthorized);
        }
    }
}

