/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/taskana-schema.sql";
    private static final String DB_SCHEMA_DETECTION = "/sql/schema-detection.sql";
    private DataSource dataSource;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public DbSchemaCreator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void run() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        ScriptRunner runner = new ScriptRunner(connection);
        LOGGER.debug(connection.getMetaData().toString());
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        try {
            if (!this.isSchemaPreexisting(runner)) {
                runner.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DB_SCHEMA)));
            }
        }
        finally {
            runner.closeConnection();
        }
        LOGGER.debug(this.outWriter.toString());
        if (!this.errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(this.errorWriter.toString());
        }
    }

    private boolean isSchemaPreexisting(ScriptRunner runner) {
        try {
            runner.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DB_SCHEMA_DETECTION)));
        }
        catch (Exception e) {
            LOGGER.debug("Schema does not exist.");
            return false;
        }
        LOGGER.debug("Schema does exist.");
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

