/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Classification;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationService;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.ClassificationAlreadyExistException;
import pro.taskana.exceptions.ClassificationInUseException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.ClassificationImpl;
import pro.taskana.impl.ClassificationQueryImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.mappings.ClassificationMapper;
import pro.taskana.mappings.TaskMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    private static final String ID_PREFIX_CLASSIFICATION = "CLI";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    private ClassificationMapper classificationMapper;
    private TaskMapper taskMapper;
    private TaskanaEngineImpl taskanaEngineImpl;

    ClassificationServiceImpl(TaskanaEngine taskanaEngine, ClassificationMapper classificationMapper, TaskMapper taskMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.classificationMapper = classificationMapper;
        this.taskMapper = taskMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification createClassification(Classification classification) throws ClassificationAlreadyExistException {
        ClassificationImpl classificationImpl;
        LOGGER.debug("entry to createClassification(classification = {})", (Object)classification);
        try {
            this.taskanaEngineImpl.openConnection();
            boolean isClassificationExisting = this.doesClassificationExist(classification.getKey(), classification.getDomain());
            if (isClassificationExisting) {
                throw new ClassificationAlreadyExistException(classification);
            }
            classificationImpl = (ClassificationImpl)classification;
            this.initDefaultClassificationValues(classificationImpl);
            this.classificationMapper.insert(classificationImpl);
            LOGGER.debug("Method createClassification created classification {}.", (Object)classification);
            this.addClassificationToRootDomain(classificationImpl);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from createClassification()");
        }
        return classificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassificationToRootDomain(ClassificationImpl classificationImpl) {
        if (classificationImpl.getDomain() != "") {
            boolean doesExist = true;
            String idBackup = classificationImpl.getId();
            String domainBackup = classificationImpl.getDomain();
            classificationImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
            classificationImpl.setDomain("");
            try {
                this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                throw new ClassificationAlreadyExistException(classificationImpl);
            }
            catch (ClassificationNotFoundException e) {
                doesExist = false;
                LOGGER.debug("Method createClassification: Classification does not exist in root domain. Classification {}.", (Object)classificationImpl);
                if (!doesExist) {
                    this.classificationMapper.insert(classificationImpl);
                    LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                }
                classificationImpl.setId(idBackup);
                classificationImpl.setDomain(domainBackup);
            }
            catch (ClassificationAlreadyExistException ex) {
                try {
                    LOGGER.warn("Method createClassification: Classification does already exist in root domain. Classification {}.", (Object)classificationImpl);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!doesExist) {
                        this.classificationMapper.insert(classificationImpl);
                        LOGGER.debug("Method createClassification: Classification created in root-domain, too. Classification {}.", (Object)classificationImpl);
                    }
                    classificationImpl.setId(idBackup);
                    classificationImpl.setDomain(domainBackup);
                }
            }
        }
    }

    @Override
    public Classification updateClassification(Classification classification) throws NotAuthorizedException {
        LOGGER.debug("entry to updateClassification(Classification = {})", (Object)classification);
        ClassificationImpl classificationImpl = null;
        try {
            this.taskanaEngineImpl.openConnection();
            classificationImpl = (ClassificationImpl)classification;
            this.initDefaultClassificationValues(classificationImpl);
            try {
                List taskSumamries;
                Classification oldClassification = this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                if (oldClassification.getCategory() != classificationImpl.getCategory() && !(taskSumamries = this.taskanaEngineImpl.getTaskService().createTaskQuery().classificationKeyIn(oldClassification.getKey()).classificationCategoryIn(oldClassification.getCategory()).list()).isEmpty()) {
                    ArrayList<String> taskIds = new ArrayList<String>();
                    taskSumamries.stream().forEach(ts -> taskIds.add(ts.getTaskId()));
                    this.taskMapper.updateClassificationCategoryOnChange(taskIds, classificationImpl.getCategory());
                }
                this.classificationMapper.update(classificationImpl);
                LOGGER.debug("Method updateClassification() updated the classification {}.", (Object)classificationImpl);
            }
            catch (ClassificationNotFoundException e) {
                classificationImpl.setCreated(Instant.now());
                this.classificationMapper.insert(classificationImpl);
                LOGGER.debug("Method updateClassification() inserted a unpersisted classification which was wanted to be updated {}.", (Object)classificationImpl);
            }
            try {
                Classification updatedClassification;
                Classification classification2 = updatedClassification = this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
                return classification2;
            }
            catch (ClassificationNotFoundException e) {
                LOGGER.debug("Throwing SystemException because updateClassification didn't find new classification {} after update", (Object)classification);
                throw new SystemException("updateClassification didn't find new classification after update");
            }
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from updateClassification().");
        }
    }

    private void initDefaultClassificationValues(ClassificationImpl classification) throws IllegalStateException {
        if (classification.getId() == null) {
            classification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
        }
        if (classification.getCreated() == null) {
            classification.setCreated(Instant.now());
        }
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() != null) {
            try {
                Duration.parse(classification.getServiceLevel());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid duration. Please use the format defined by ISO 8601");
            }
        }
        if (classification.getKey() == null) {
            throw new IllegalStateException("Classification must contain a key");
        }
        if (classification.getParentId() == null) {
            classification.setParentId("");
        }
        if (classification.getDomain() == null) {
            classification.setDomain("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String key, String domain) throws ClassificationNotFoundException {
        if (key == null) {
            throw new ClassificationNotFoundException("Classification for key " + key + " and domain " + domain + " was not found.");
        }
        LOGGER.debug("entry to getClassification(key = {}, domain = {})", (Object)key, (Object)domain);
        ClassificationImpl result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            result = this.classificationMapper.findByKeyAndDomain(key, domain);
            if (result == null && (result = this.classificationMapper.findByKeyAndDomain(key, "")) == null) {
                throw new ClassificationNotFoundException("Classification for key " + key + " was not found");
            }
            ClassificationImpl classificationImpl = result;
            return classificationImpl;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        }
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        return new ClassificationQueryImpl(this.taskanaEngineImpl);
    }

    @Override
    public Classification newClassification(String domain, String key, String type) {
        ClassificationImpl classification = new ClassificationImpl();
        classification.setKey(key);
        classification.setDomain(domain);
        classification.setType(type);
        return classification;
    }

    private boolean doesClassificationExist(String key, String domain) {
        boolean isExisting = false;
        try {
            if (this.classificationMapper.findByKeyAndDomain(key, domain) != null) {
                isExisting = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Classification-Service throwed Exception while calling mapper and searching for classification. EX={}", (Throwable)ex);
        }
        return isExisting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClassification(String classificationKey, String domain) throws ClassificationInUseException, ClassificationNotFoundException {
        try {
            this.taskanaEngineImpl.openConnection();
            ClassificationImpl classification = this.classificationMapper.findByKeyAndDomain(classificationKey, domain);
            if (classification == null) {
                throw new ClassificationNotFoundException("The classification " + classificationKey + "wasn't found in the domain " + domain);
            }
            if (domain.equals("")) {
                List<String> domains = this.classificationMapper.getDomainsForClassification(classificationKey);
                domains.remove("");
                for (String classificationDomain : domains) {
                    this.deleteClassification(classificationKey, classificationDomain);
                }
            }
            TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
            try {
                List classificationTasks = taskService.createTaskQuery().classificationKeyIn(classificationKey).domainIn(domain).list();
                if (!classificationTasks.isEmpty()) {
                    throw new ClassificationInUseException("There are " + classificationTasks.size() + " Tasks which belong to this classification or a child classification. Please complete them and try again.");
                }
            }
            catch (NotAuthorizedToQueryWorkbasketException e) {
                LOGGER.error("ClassificationQuery unexpectedly returned NotauthorizedException. Throwing SystemException ");
                throw new SystemException("ClassificationQuery unexpectedly returned NotauthorizedException.");
            }
            List<String> childKeys = this.classificationMapper.getChildrenOfClassification(classification.getId());
            for (String key : childKeys) {
                this.deleteClassification(key, domain);
            }
            this.classificationMapper.deleteClassificationInDomain(classificationKey, domain);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
    }
}

