/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.impl.ReportLineItemDefinition;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.util.LoggerUtils;

public final class DaysToWorkingDaysConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private static DaysToWorkingDaysConverter instance;
    private static ArrayList<Integer> positiveDaysToWorkingDays;
    private static ArrayList<Integer> negativeDaysToWorkingDays;
    private static Instant dateCreated;

    private DaysToWorkingDaysConverter(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        positiveDaysToWorkingDays = this.generatePositiveDaysToWorkingDays(reportLineItemDefinitions, referenceDate);
        negativeDaysToWorkingDays = this.generateNegativeDaysToWorkingDays(reportLineItemDefinitions, referenceDate);
        dateCreated = referenceDate;
    }

    public static DaysToWorkingDaysConverter initialize(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return DaysToWorkingDaysConverter.initialize(reportLineItemDefinitions, Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize DaysToWorkingDaysConverter with reportLineItemDefinitions: {}", (Object)LoggerUtils.listToString(reportLineItemDefinitions));
        }
        int largesLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(reportLineItemDefinitions);
        int smallestUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(reportLineItemDefinitions);
        if (!(instance != null && positiveDaysToWorkingDays.contains(largesLowerLimit) && negativeDaysToWorkingDays.contains(smallestUpperLimit) && dateCreated.truncatedTo(ChronoUnit.DAYS).equals(referenceDate.truncatedTo(ChronoUnit.DAYS)))) {
            instance = new DaysToWorkingDaysConverter(reportLineItemDefinitions, referenceDate);
            LOGGER.debug("Create new converter for the values from {} until {} for the date: {}.", new Object[]{largesLowerLimit, smallestUpperLimit, dateCreated});
        }
        return instance;
    }

    public int convertDaysToWorkingDays(int ageInDays) {
        int minWorkingDay = -(negativeDaysToWorkingDays.size() - 1);
        int maxWorkingDay = positiveDaysToWorkingDays.size() - 1;
        if (ageInDays >= minWorkingDay && ageInDays <= 0) {
            return negativeDaysToWorkingDays.get(-ageInDays);
        }
        if (ageInDays > 0 && ageInDays <= maxWorkingDay) {
            return positiveDaysToWorkingDays.get(ageInDays);
        }
        return ageInDays;
    }

    private ArrayList<Integer> generateNegativeDaysToWorkingDays(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        int minUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(reportLineItemDefinitions);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = -1;
        int workingDay = 0;
        while (workingDay > minUpperLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                --workingDay;
            }
            daysToWorkingDays.add(workingDay);
            --day;
        }
        return daysToWorkingDays;
    }

    private ArrayList<Integer> generatePositiveDaysToWorkingDays(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        int maxLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(reportLineItemDefinitions);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = 1;
        int workingDay = 0;
        while (workingDay < maxLowerLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                ++workingDay;
            }
            daysToWorkingDays.add(workingDay);
            ++day;
        }
        return daysToWorkingDays;
    }

    private static int getSmallestUpperLimit(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        int smallestUpperLimit = 0;
        for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
            if (reportLineItemDefinition.getUpperAgeLimit() >= smallestUpperLimit) continue;
            smallestUpperLimit = reportLineItemDefinition.getUpperAgeLimit();
        }
        return smallestUpperLimit;
    }

    private static int getLargestLowerLimit(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        int greatestLowerLimit = 0;
        for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
            if (reportLineItemDefinition.getUpperAgeLimit() <= greatestLowerLimit) continue;
            greatestLowerLimit = reportLineItemDefinition.getLowerAgeLimit();
        }
        return greatestLowerLimit;
    }

    private boolean isWorkingDay(int day, Instant referenceDate) {
        return !LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day).getDayOfWeek().equals(DayOfWeek.SATURDAY) && !LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day).getDayOfWeek().equals(DayOfWeek.SUNDAY);
    }
}

