/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pro.taskana.impl.DaysToWorkingDaysConverter;
import pro.taskana.impl.MonitorQueryItem;
import pro.taskana.impl.ReportLine;
import pro.taskana.impl.ReportLineItem;
import pro.taskana.impl.ReportLineItemDefinition;

public class Report {
    protected Map<String, ReportLine> reportLines = new LinkedHashMap<String, ReportLine>();
    protected ReportLine sumLine;

    public Map<String, ReportLine> getReportLines() {
        return this.reportLines;
    }

    public void setReportLines(Map<String, ReportLine> reportLines) {
        this.reportLines = reportLines;
    }

    public ReportLine getSumLine() {
        return this.sumLine;
    }

    public void setSumLine(ReportLine sumLine) {
        this.sumLine = sumLine;
    }

    public void addMonitoringQueryItems(List<MonitorQueryItem> monitorQueryItems, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        DaysToWorkingDaysConverter instance = null;
        if (reportLineItemDefinitions != null && inWorkingDays) {
            instance = DaysToWorkingDaysConverter.initialize(reportLineItemDefinitions);
        }
        for (MonitorQueryItem item : monitorQueryItems) {
            if (instance != null) {
                item.setAgeInDays(instance.convertDaysToWorkingDays(item.getAgeInDays()));
            }
            if (!this.reportLines.containsKey(item.getKey())) {
                ReportLine reportLine = new ReportLine();
                reportLine.create(reportLineItemDefinitions);
                this.reportLines.put(item.getKey(), reportLine);
            }
            this.reportLines.get(item.getKey()).addNumberOfTasks(item);
        }
        this.sumLine = this.createSumLine(reportLineItemDefinitions);
    }

    protected ReportLine createSumLine(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        ReportLine sumLine = new ReportLine();
        sumLine.create(reportLineItemDefinitions);
        int totalNumberOfTasks = 0;
        for (ReportLine reportLine : this.reportLines.values()) {
            Iterator<ReportLineItem> reportLineItemIterator = reportLine.getLineItems().iterator();
            Iterator<ReportLineItem> sumLineItemIterator = sumLine.getLineItems().iterator();
            while (reportLineItemIterator.hasNext() && sumLineItemIterator.hasNext()) {
                int numberOfTasks = reportLineItemIterator.next().getNumberOfTasks();
                sumLineItemIterator.next().addNumberOfTasks(numberOfTasks);
            }
            totalNumberOfTasks += reportLine.getTotalNumberOfTasks();
        }
        sumLine.setTotalNumberOfTasks(totalNumberOfTasks);
        return sumLine;
    }
}

