/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskanaEngine;
import pro.taskana.Workbasket;
import pro.taskana.impl.ClassificationReport;
import pro.taskana.impl.CustomField;
import pro.taskana.impl.DetailedClassificationReport;
import pro.taskana.impl.DetailedMonitorQueryItem;
import pro.taskana.impl.MonitorQueryItem;
import pro.taskana.impl.Report;
import pro.taskana.impl.ReportLineItemDefinition;
import pro.taskana.impl.TaskState;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.TaskMonitorMapper;

public class TaskMonitorServiceImpl
implements TaskMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMonitorMapper taskMonitorMapper;

    TaskMonitorServiceImpl(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    @Override
    public Report getWorkbasketLevelReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getWorkbasketLevelReport(workbaskets, states, null, false);
    }

    @Override
    public Report getWorkbasketLevelReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return this.getWorkbasketLevelReport(workbaskets, states, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getWorkbasketLevelReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbasketLevelReport(workbaskets = {}, states = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfWorkbasketsByWorkbasketsAndStates(workbaskets, states);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasketLevelReport().");
        }
    }

    @Override
    public Report getCategoryReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getCategoryReport(workbaskets, states, null, false);
    }

    @Override
    public Report getCategoryReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return this.getCategoryReport(workbaskets, states, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getCategoryReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCategoryReport(workbaskets = {}, states = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCategoriesByWorkbasketsAndStates(workbaskets, states);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCategoryReport().");
        }
    }

    @Override
    public ClassificationReport getClassificationReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getClassificationReport(workbaskets, states, null, false);
    }

    @Override
    public ClassificationReport getClassificationReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return this.getClassificationReport(workbaskets, states, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassificationReport getClassificationReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getClassificationReport(workbaskets = {}, states = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            ClassificationReport report = new ClassificationReport();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfClassificationsByWorkbasketsAndStates(workbaskets, states);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            ClassificationReport classificationReport = report;
            return classificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassificationReport().");
        }
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<Workbasket> workbaskets, List<TaskState> states) {
        return this.getDetailedClassificationReport(workbaskets, states, null, false);
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return this.getDetailedClassificationReport(workbaskets, states, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<Workbasket> workbaskets, List<TaskState> states, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getDetailedClassificationReport(workbaskets = {}, states = {}, customField = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            DetailedClassificationReport report = new DetailedClassificationReport();
            List<DetailedMonitorQueryItem> detailedMonitorQueryItems = this.taskMonitorMapper.getTaskCountOfDetailedClassificationsByWorkbasketsAndStates(workbaskets, states);
            report.addDetailedMonitoringQueryItems(detailedMonitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            DetailedClassificationReport detailedClassificationReport = report;
            return detailedClassificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getDetailedClassificationReport().");
        }
    }

    @Override
    public Report getCustomFieldValueReport(List<Workbasket> workbaskets, List<TaskState> states, CustomField customField) {
        return this.getCustomFieldValueReport(workbaskets, states, customField, null, false);
    }

    @Override
    public Report getCustomFieldValueReport(List<Workbasket> workbaskets, List<TaskState> states, CustomField customField, List<ReportLineItemDefinition> reportLineItemDefinitions) {
        return this.getCustomFieldValueReport(workbaskets, states, customField, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getCustomFieldValueReport(List<Workbasket> workbaskets, List<TaskState> states, CustomField customField, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCustomFieldValueReport(workbaskets = {}, states = {}, customField = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbaskets), LoggerUtils.listToString(states), customField, LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCustomFieldValuesByWorkbasketsAndStatesAndCustomField(workbaskets, states, customField);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCustomFieldValueReport().");
        }
    }
}

