/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.TaskQuery;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TimeInterval;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.ObjectReferenceQueryImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskState;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketAuthorization;
import pro.taskana.impl.util.LoggerUtils;

public class TaskQueryImpl
implements TaskQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryTasks";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryTasks";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueryImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskServiceImpl taskService;
    private String[] nameIn;
    private String[] nameLike;
    private String[] taskIds;
    private String[] description;
    private String[] note;
    private int[] priority;
    private TaskState[] states;
    private String[] classificationKeyIn;
    private String[] classificationKeyLike;
    private String[] classificationCategoryIn;
    private String[] classificationCategoryLike;
    private String[] workbasketKeyIn;
    private String[] workbasketKeyLike;
    private String[] domainIn;
    private String[] domainLike;
    private String[] ownerIn;
    private String[] ownerLike;
    private Boolean isRead;
    private Boolean isTransferred;
    private String[] customFields;
    private String[] porCompanyIn;
    private String[] porCompanyLike;
    private String[] porSystemIn;
    private String[] porSystemLike;
    private String[] porSystemInstanceIn;
    private String[] porSystemInstanceLike;
    private String[] porTypeIn;
    private String[] porTypeLike;
    private String[] porValueIn;
    private String[] porValueLike;
    private String[] parentBusinessProcessIdIn;
    private String[] parentBusinessProcessIdLike;
    private String[] businessProcessIdIn;
    private String[] businessProcessIdLike;
    private String[] custom1In;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8Like;
    private String[] custom9In;
    private String[] custom9Like;
    private String[] custom10In;
    private String[] custom10Like;
    private TimeInterval[] createdIn;
    private TimeInterval[] claimedIn;
    private TimeInterval[] completedIn;
    private TimeInterval[] modifiedIn;
    private TimeInterval[] plannedIn;
    private TimeInterval[] dueIn;
    private List<String> orderBy;

    TaskQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
        this.orderBy = new ArrayList<String>();
    }

    @Override
    public TaskQuery idIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public TaskQuery nameIn(String ... names) {
        this.nameIn = names;
        return this;
    }

    @Override
    public TaskQuery nameLike(String ... names) {
        this.nameLike = this.toUpperCopy(names);
        return this;
    }

    @Override
    public TaskQuery createdWithin(TimeInterval ... intervals) {
        this.createdIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery claimedWithin(TimeInterval ... intervals) {
        this.claimedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery completedWithin(TimeInterval ... intervals) {
        this.completedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery modifiedWithin(TimeInterval ... intervals) {
        this.modifiedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery plannedWithin(TimeInterval ... intervals) {
        this.plannedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery dueWithin(TimeInterval ... intervals) {
        this.dueIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public TaskQuery descriptionLike(String ... description) {
        this.description = this.toUpperCopy(description);
        return this;
    }

    @Override
    public TaskQuery noteLike(String ... note) {
        this.note = this.toUpperCopy(note);
        return this;
    }

    @Override
    public TaskQuery priorityIn(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public TaskQuery stateIn(TaskState ... states) {
        this.states = states;
        return this;
    }

    @Override
    public TaskQuery classificationKeyIn(String ... classificationKey) {
        this.classificationKeyIn = classificationKey;
        return this;
    }

    @Override
    public TaskQuery classificationKeyLike(String ... classificationKeys) {
        this.classificationKeyLike = this.toUpperCopy(classificationKeys);
        return this;
    }

    @Override
    public TaskQuery classificationCategoryIn(String ... classificationCategories) {
        this.classificationCategoryIn = classificationCategories;
        return this;
    }

    @Override
    public TaskQuery classificationCategoryLike(String ... classificationCategories) {
        this.classificationCategoryLike = this.toUpperCopy(classificationCategories);
        return this;
    }

    @Override
    public TaskQuery workbasketKeyIn(String ... workbasketKeys) {
        this.workbasketKeyIn = workbasketKeys;
        return this;
    }

    @Override
    public TaskQuery workbasketKeyLike(String ... workbasketKeys) {
        this.workbasketKeyLike = this.toUpperCopy(workbasketKeys);
        return this;
    }

    @Override
    public TaskQuery domainIn(String ... domain) {
        this.domainIn = domain;
        return this;
    }

    @Override
    public TaskQuery domainLike(String ... domains) {
        this.domainLike = this.toUpperCopy(domains);
        return this;
    }

    @Override
    public TaskQuery ownerIn(String ... owners) {
        this.ownerIn = owners;
        return this;
    }

    @Override
    public TaskQuery ownerLike(String ... owners) {
        this.ownerLike = this.toUpperCopy(owners);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyIn(String ... companies) {
        this.porCompanyIn = companies;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyLike(String ... company) {
        this.porCompanyLike = this.toUpperCopy(company);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemIn(String ... systems) {
        this.porSystemIn = systems;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemLike(String ... system) {
        this.porSystemLike = this.toUpperCopy(system);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceIn(String ... systemInstances) {
        this.porSystemInstanceIn = systemInstances;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceLike(String ... systemInstance) {
        this.porSystemInstanceLike = this.toUpperCopy(systemInstance);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeIn(String ... types) {
        this.porTypeIn = types;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeLike(String ... type) {
        this.porTypeLike = this.toUpperCopy(type);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueIn(String ... values) {
        this.porValueIn = values;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueLike(String ... value) {
        this.porValueLike = this.toUpperCopy(value);
        return this;
    }

    @Override
    public TaskQuery readEquals(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    @Override
    public TaskQuery transferredEquals(Boolean isTransferred) {
        this.isTransferred = isTransferred;
        return this;
    }

    @Override
    public TaskQuery customFieldsIn(String ... customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdIn(String ... parentBusinessProcessIds) {
        this.parentBusinessProcessIdIn = parentBusinessProcessIds;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdLike(String ... parentBusinessProcessId) {
        this.parentBusinessProcessIdLike = this.toUpperCopy(parentBusinessProcessId);
        return this;
    }

    @Override
    public TaskQuery businessProcessIdIn(String ... businessProcessIds) {
        this.businessProcessIdIn = businessProcessIds;
        return this;
    }

    @Override
    public TaskQuery businessProcessIdLike(String ... businessProcessIds) {
        this.businessProcessIdLike = this.toUpperCopy(businessProcessIds);
        return this;
    }

    @Override
    public TaskQuery custom1In(String ... strings) {
        this.custom1In = strings;
        return this;
    }

    @Override
    public TaskQuery custom1Like(String ... strings) {
        this.custom1Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom2In(String ... strings) {
        this.custom2In = strings;
        return this;
    }

    @Override
    public TaskQuery custom2Like(String ... strings) {
        this.custom2Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom3In(String ... strings) {
        this.custom3In = strings;
        return this;
    }

    @Override
    public TaskQuery custom3Like(String ... strings) {
        this.custom3Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom4In(String ... strings) {
        this.custom4In = strings;
        return this;
    }

    @Override
    public TaskQuery custom4Like(String ... strings) {
        this.custom4Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom5In(String ... strings) {
        this.custom5In = strings;
        return this;
    }

    @Override
    public TaskQuery custom5Like(String ... strings) {
        this.custom5Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom6In(String ... strings) {
        this.custom6In = strings;
        return this;
    }

    @Override
    public TaskQuery custom6Like(String ... strings) {
        this.custom6Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom7In(String ... strings) {
        this.custom7In = strings;
        return this;
    }

    @Override
    public TaskQuery custom7Like(String ... strings) {
        this.custom7Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom8In(String ... strings) {
        this.custom8In = strings;
        return this;
    }

    @Override
    public TaskQuery custom8Like(String ... strings) {
        this.custom8Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom9In(String ... strings) {
        this.custom9In = strings;
        return this;
    }

    @Override
    public TaskQuery custom9Like(String ... strings) {
        this.custom9Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery custom10In(String ... strings) {
        this.custom10In = strings;
        return this;
    }

    @Override
    public TaskQuery custom10Like(String ... strings) {
        this.custom10Like = this.toUpperCopy(strings);
        return this;
    }

    @Override
    public TaskQuery orderByClassificationKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public TaskQuery orderByPlanned(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PLANNED", sortDirection);
    }

    @Override
    public TaskQuery orderByDue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DUE", sortDirection);
    }

    @Override
    public TaskQuery orderByModified(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("MODIFIED", sortDirection);
    }

    @Override
    public TaskQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public TaskQuery orderByOwner(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("OWNER", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceCompany(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_COMPANY", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystem(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_SYSTEM", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystemInstance(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_INSTANCE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_TYPE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_VALUE", sortDirection);
    }

    @Override
    public TaskQuery orderByPriority(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PRIORITY", sortDirection);
    }

    @Override
    public TaskQuery orderByState(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("STATE", sortDirection);
    }

    @Override
    public TaskQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByNote(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NOTE", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom1(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_1", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom2(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_2", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom3(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_3", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom4(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_4", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom5(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_5", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom6(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_6", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom7(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_7", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom8(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_8", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom9(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_9", sortDirection);
    }

    @Override
    public TaskQuery orderByCustom10(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_10", sortDirection);
    }

    @Override
    public TaskQuery orderByBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByClaimed(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CLAIMED", sortDirection);
    }

    @Override
    public TaskQuery orderByCompleted(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("COMPLETED", sortDirection);
    }

    @Override
    public TaskQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public TaskQuery orderByParentBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public ObjectReferenceQuery createObjectReferenceQuery() {
        return new ObjectReferenceQueryImpl(this.taskanaEngineImpl);
    }

    @Override
    public List<TaskSummary> list() {
        ArrayList<TaskSummary> arrayList;
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            LOGGER.debug("entry to list(), this = {}", (Object)this);
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            ArrayList<TaskSummaryImpl> tasks = new ArrayList();
            tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (NotAuthorizedException e) {
            try {
                throw new NotAuthorizedToQueryWorkbasketException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TaskSummary> list(int offset, int limit) {
        ArrayList<TaskSummary> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List tasks = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (PersistenceException e) {
            try {
                if (e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
                catch (NotAuthorizedException e2) {
                    throw new NotAuthorizedToQueryWorkbasketException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public TaskSummary single() {
        TaskSummary taskSummary;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        TaskSummary result = null;
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            TaskSummaryImpl taskSummaryImpl = (TaskSummaryImpl)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            if (taskSummaryImpl == null) {
                TaskSummary taskSummary2 = null;
                return taskSummary2;
            }
            ArrayList<TaskSummaryImpl> tasks = new ArrayList<TaskSummaryImpl>();
            tasks.add(taskSummaryImpl);
            List<TaskSummary> augmentedList = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            taskSummary = result = augmentedList.get(0);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (NotAuthorizedException e) {
            throw new NotAuthorizedToQueryWorkbasketException(e.getMessage());
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngineImpl.openConnection();
            this.checkOpenPermissionForWorkbasketKey();
            rowCount = (Long)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private void checkOpenPermissionForWorkbasketKey() {
        try {
            if (this.workbasketKeyIn != null && this.workbasketKeyIn.length > 0) {
                for (String wbKey : this.workbasketKeyIn) {
                    this.taskanaEngineImpl.getWorkbasketService().checkAuthorization(wbKey, WorkbasketAuthorization.OPEN);
                }
            }
        }
        catch (NotAuthorizedException e) {
            throw new NotAuthorizedToQueryWorkbasketException(e.getMessage());
        }
    }

    public TaskanaEngineImpl getTaskanaEngine() {
        return this.taskanaEngineImpl;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getDescription() {
        return this.description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public TaskState[] getStates() {
        return this.states;
    }

    public String[] getOwnerIn() {
        return this.ownerIn;
    }

    public String[] getOwnerLike() {
        return this.ownerLike;
    }

    public String[] getCustomFields() {
        return this.customFields;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public Boolean getIsTransferred() {
        return this.isTransferred;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public String[] getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public String[] getPorSystemLike() {
        return this.porSystemLike;
    }

    public String[] getPorSystemInstanceIn() {
        return this.porSystemInstanceIn;
    }

    public String[] getPorSystemInstanceLike() {
        return this.porSystemInstanceLike;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public String[] getPorTypeLike() {
        return this.porTypeLike;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public String[] getPorValueLike() {
        return this.porValueLike;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public TaskServiceImpl getTaskService() {
        return this.taskService;
    }

    public String[] getNote() {
        return this.note;
    }

    public String[] getParentBusinessProcessIdIn() {
        return this.parentBusinessProcessIdIn;
    }

    public String[] getParentBusinessProcessIdLike() {
        return this.parentBusinessProcessIdLike;
    }

    public String[] getBusinessProcessIdIn() {
        return this.businessProcessIdIn;
    }

    public String[] getBusinessProcessIdLike() {
        return this.businessProcessIdLike;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getCustom5In() {
        return this.custom5In;
    }

    public String[] getCustom5Like() {
        return this.custom5Like;
    }

    public String[] getCustom6In() {
        return this.custom6In;
    }

    public String[] getCustom6Like() {
        return this.custom6Like;
    }

    public String[] getCustom7In() {
        return this.custom7In;
    }

    public String[] getCustom7Like() {
        return this.custom7Like;
    }

    public String[] getCustom8In() {
        return this.custom8In;
    }

    public String[] getCustom8Like() {
        return this.custom8Like;
    }

    public String[] getCustom9In() {
        return this.custom9In;
    }

    public String[] getCustom9Like() {
        return this.custom9Like;
    }

    public String[] getCustom10In() {
        return this.custom10In;
    }

    public String[] getCustom10Like() {
        return this.custom10Like;
    }

    public TimeInterval[] getClaimedIn() {
        return this.claimedIn;
    }

    public TimeInterval[] getCompletedIn() {
        return this.completedIn;
    }

    public TimeInterval[] getModifiedIn() {
        return this.modifiedIn;
    }

    public TimeInterval[] getPlannedIn() {
        return this.plannedIn;
    }

    public TimeInterval[] getDueIn() {
        return this.dueIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getClassificationKeyIn() {
        return this.classificationKeyIn;
    }

    public String[] getClassificationKeyLike() {
        return this.classificationKeyLike;
    }

    public String[] getWorkbasketKeyIn() {
        return this.workbasketKeyIn;
    }

    public String[] getWorkbasketKeyLike() {
        return this.workbasketKeyLike;
    }

    public String[] getDomainIn() {
        return this.domainIn;
    }

    public String[] getDomainLike() {
        return this.domainLike;
    }

    private TaskQuery addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " ASC";
        if (sortDirection != null && BaseQuery.SortDirection.DESCENDING.equals((Object)sortDirection)) {
            orderByDirection = " DESC";
        }
        this.orderBy.add(columnName + orderByDirection);
        return this;
    }

    private String[] toUpperCopy(String ... source) {
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskQueryImpl [nameIn=");
        builder.append(Arrays.toString(this.nameIn));
        builder.append(", nameLike=");
        builder.append(Arrays.toString(this.nameLike));
        builder.append(", taskIds=");
        builder.append(Arrays.toString(this.taskIds));
        builder.append(", description=");
        builder.append(Arrays.toString(this.description));
        builder.append(", note=");
        builder.append(Arrays.toString(this.note));
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", states=");
        builder.append(Arrays.toString((Object[])this.states));
        builder.append(", classificationKeyIn=");
        builder.append(Arrays.toString(this.classificationKeyIn));
        builder.append(", classificationKeyLike=");
        builder.append(Arrays.toString(this.classificationKeyLike));
        builder.append(", classificationCategoryIn=");
        builder.append(Arrays.toString(this.classificationCategoryIn));
        builder.append(", classificationCategoryLike=");
        builder.append(Arrays.toString(this.classificationCategoryLike));
        builder.append(", workbasketKeyIn=");
        builder.append(Arrays.toString(this.workbasketKeyIn));
        builder.append(", workbasketKeyLike=");
        builder.append(Arrays.toString(this.workbasketKeyLike));
        builder.append(", domainIn=");
        builder.append(Arrays.toString(this.domainIn));
        builder.append(", domainLike=");
        builder.append(Arrays.toString(this.domainLike));
        builder.append(", ownerIn=");
        builder.append(Arrays.toString(this.ownerIn));
        builder.append(", ownerLike=");
        builder.append(Arrays.toString(this.ownerLike));
        builder.append(", isRead=");
        builder.append(this.isRead);
        builder.append(", isTransferred=");
        builder.append(this.isTransferred);
        builder.append(", customFields=");
        builder.append(Arrays.toString(this.customFields));
        builder.append(", porCompanyIn=");
        builder.append(Arrays.toString(this.porCompanyIn));
        builder.append(", porCompanyLike=");
        builder.append(Arrays.toString(this.porCompanyLike));
        builder.append(", porSystemIn=");
        builder.append(Arrays.toString(this.porSystemIn));
        builder.append(", porSystemLike=");
        builder.append(Arrays.toString(this.porSystemLike));
        builder.append(", porSystemInstanceIn=");
        builder.append(Arrays.toString(this.porSystemInstanceIn));
        builder.append(", porSystemInstanceLike=");
        builder.append(Arrays.toString(this.porSystemInstanceLike));
        builder.append(", porTypeIn=");
        builder.append(Arrays.toString(this.porTypeIn));
        builder.append(", porTypeLike=");
        builder.append(Arrays.toString(this.porTypeLike));
        builder.append(", porValueIn=");
        builder.append(Arrays.toString(this.porValueIn));
        builder.append(", porValueLike=");
        builder.append(Arrays.toString(this.porValueLike));
        builder.append(", parentBusinessProcessIdIn=");
        builder.append(Arrays.toString(this.parentBusinessProcessIdIn));
        builder.append(", parentBusinessProcessIdLike=");
        builder.append(Arrays.toString(this.parentBusinessProcessIdLike));
        builder.append(", businessProcessIdIn=");
        builder.append(Arrays.toString(this.businessProcessIdIn));
        builder.append(", businessProcessIdLike=");
        builder.append(Arrays.toString(this.businessProcessIdLike));
        builder.append(", custom1In=");
        builder.append(Arrays.toString(this.custom1In));
        builder.append(", custom1Like=");
        builder.append(Arrays.toString(this.custom1Like));
        builder.append(", custom2In=");
        builder.append(Arrays.toString(this.custom2In));
        builder.append(", custom2Like=");
        builder.append(Arrays.toString(this.custom2Like));
        builder.append(", custom3In=");
        builder.append(Arrays.toString(this.custom3In));
        builder.append(", custom3Like=");
        builder.append(Arrays.toString(this.custom3Like));
        builder.append(", custom4In=");
        builder.append(Arrays.toString(this.custom4In));
        builder.append(", custom4Like=");
        builder.append(Arrays.toString(this.custom4Like));
        builder.append(", custom5In=");
        builder.append(Arrays.toString(this.custom5In));
        builder.append(", custom5Like=");
        builder.append(Arrays.toString(this.custom5Like));
        builder.append(", custom6In=");
        builder.append(Arrays.toString(this.custom6In));
        builder.append(", custom6Like=");
        builder.append(Arrays.toString(this.custom6Like));
        builder.append(", custom7In=");
        builder.append(Arrays.toString(this.custom7In));
        builder.append(", custom7Like=");
        builder.append(Arrays.toString(this.custom7Like));
        builder.append(", custom8In=");
        builder.append(Arrays.toString(this.custom8In));
        builder.append(", custom8Like=");
        builder.append(Arrays.toString(this.custom8Like));
        builder.append(", custom9In=");
        builder.append(Arrays.toString(this.custom9In));
        builder.append(", custom9Like=");
        builder.append(Arrays.toString(this.custom9Like));
        builder.append(", custom10In=");
        builder.append(Arrays.toString(this.custom10In));
        builder.append(", custom10Like=");
        builder.append(Arrays.toString(this.custom10Like));
        builder.append(", createdIn=");
        builder.append(Arrays.toString(this.createdIn));
        builder.append(", claimedIn=");
        builder.append(Arrays.toString(this.claimedIn));
        builder.append(", completedIn=");
        builder.append(Arrays.toString(this.completedIn));
        builder.append(", modifiedIn=");
        builder.append(Arrays.toString(this.modifiedIn));
        builder.append(", plannedIn=");
        builder.append(Arrays.toString(this.plannedIn));
        builder.append(", dueIn=");
        builder.append(Arrays.toString(this.dueIn));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

