/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ClassificationService;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskService;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketService;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.AutocommitFailedException;
import pro.taskana.exceptions.ConnectionNotSetException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.UnsupportedDatabaseException;
import pro.taskana.impl.ClassificationServiceImpl;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.WorkbasketServiceImpl;
import pro.taskana.impl.persistence.MapTypeHandler;
import pro.taskana.mappings.AttachmentMapper;
import pro.taskana.mappings.ClassificationMapper;
import pro.taskana.mappings.DistributionTargetMapper;
import pro.taskana.mappings.ObjectReferenceMapper;
import pro.taskana.mappings.QueryMapper;
import pro.taskana.mappings.TaskMapper;
import pro.taskana.mappings.TaskMonitorMapper;
import pro.taskana.mappings.WorkbasketAccessMapper;
import pro.taskana.mappings.WorkbasketMapper;

public class TaskanaEngineImpl
implements TaskanaEngine {
    private static final String DEFAULT = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineImpl.class);
    protected static ThreadLocal<Deque<SqlSessionManager>> sessionStack = new ThreadLocal();
    protected TaskanaEngineConfiguration taskanaEngineConfiguration;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected SqlSessionFactory sessionFactory;
    protected TaskanaEngine.ConnectionManagementMode mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
    protected Connection connection = null;

    public static TaskanaEngine createTaskanaEngine(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        return new TaskanaEngineImpl(taskanaEngineConfiguration);
    }

    protected TaskanaEngineImpl(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.createTransactionFactory(taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
    }

    @Override
    public TaskService getTaskService() {
        SqlSessionManager session = this.sessionManager;
        return new TaskServiceImpl(this, (TaskMapper)session.getMapper(TaskMapper.class), (AttachmentMapper)session.getMapper(AttachmentMapper.class));
    }

    @Override
    public TaskMonitorService getTaskMonitorService() {
        SqlSessionManager session = this.sessionManager;
        return new TaskMonitorServiceImpl(this, (TaskMonitorMapper)session.getMapper(TaskMonitorMapper.class));
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        SqlSessionManager session = this.sessionManager;
        return new WorkbasketServiceImpl(this, (WorkbasketMapper)session.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)session.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)session.getMapper(WorkbasketAccessMapper.class));
    }

    @Override
    public ClassificationService getClassificationService() {
        SqlSessionManager session = this.sessionManager;
        return new ClassificationServiceImpl(this, (ClassificationMapper)session.getMapper(ClassificationMapper.class), (TaskMapper)session.getMapper(TaskMapper.class));
    }

    @Override
    public TaskanaEngineConfiguration getConfiguration() {
        return this.taskanaEngineConfiguration;
    }

    @Override
    public void setConnectionManagementMode(TaskanaEngine.ConnectionManagementMode mode) {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
    }

    @Override
    public void setConnection(Connection connection) {
        if (connection != null) {
            this.connection = connection;
            this.mode = TaskanaEngine.ConnectionManagementMode.EXPLICIT;
            this.sessionManager.startManagedSession(connection);
        } else if (this.connection != null) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    @Override
    public void closeConnection() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    void openConnection() {
        this.initSqlSession();
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            TaskanaEngineImpl.pushSessionToStack(this.sessionManager);
        }
    }

    void initSqlSession() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection == null) {
            throw new ConnectionNotSetException();
        }
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT && !this.sessionManager.isManagedSessionStarted()) {
            this.sessionManager.startManagedSession();
        }
    }

    void returnConnection() {
        if (this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            TaskanaEngineImpl.popSessionFromStack();
            if (TaskanaEngineImpl.getSessionStack().isEmpty() && this.sessionManager != null && this.sessionManager.isManagedSessionStarted()) {
                if (this.mode == TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT) {
                    try {
                        this.sessionManager.commit();
                    }
                    catch (Exception e) {
                        LOGGER.error("closeSession(): Tried to Autocommit and caught exception" + e);
                        throw new AutocommitFailedException(e);
                    }
                }
                this.sessionManager.close();
            }
        }
    }

    SqlSession getSqlSession() {
        return this.sessionManager;
    }

    protected SqlSessionManager createSqlSessionManager() {
        Configuration configuration;
        block16: {
            Environment environment = new Environment(DEFAULT, this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
            configuration = new Configuration(environment);
            try (Connection con = this.taskanaEngineConfiguration.getDatasource().getConnection();){
                String databaseProductName = con.getMetaData().getDatabaseProductName();
                if (databaseProductName.contains("DB2")) {
                    configuration.setDatabaseId("db2");
                    break block16;
                }
                if (databaseProductName.contains("H2")) {
                    configuration.setDatabaseId("h2");
                    break block16;
                }
                LOGGER.error("Method createSqlSessionManager() didn't find database with name {}. Throwing UnsupportedDatabaseException", (Object)databaseProductName);
                throw new UnsupportedDatabaseException(databaseProductName);
            }
            catch (SQLException e) {
                LOGGER.error("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.", (Throwable)e);
                throw new SystemException("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.");
            }
        }
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(TaskMonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(QueryMapper.class);
        configuration.addMapper(AttachmentMapper.class);
        configuration.getTypeHandlerRegistry().register(MapTypeHandler.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory);
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
    }

    protected static Deque<SqlSessionManager> getSessionStack() {
        Deque<SqlSessionManager> stack = sessionStack.get();
        if (stack == null) {
            stack = new ArrayDeque<SqlSessionManager>();
            sessionStack.set(stack);
        }
        return stack;
    }

    protected static SqlSessionManager getSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    protected static void pushSessionToStack(SqlSessionManager session) {
        TaskanaEngineImpl.getSessionStack().push(session);
    }

    protected static void popSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }
}

