/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketAccessItemQuery;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.LoggerUtils;

public class WorkbasketAccessItemQueryImpl
implements WorkbasketAccessItemQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryWorkbasketAccessItem";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryWorkbasketAccessItems";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String[] accessIdIn;
    private String[] workbasketKeyIn;
    private TaskanaEngineImpl taskanaEngineImpl;
    private List<String> orderBy;

    WorkbasketAccessItemQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.orderBy = new ArrayList<String>();
    }

    @Override
    public WorkbasketAccessItemQuery workbasketKeyIn(String ... key) {
        this.workbasketKeyIn = key;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery accessIdIn(String ... accessId) {
        this.accessIdIn = accessId;
        WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_KEY", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByAccessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ACCESS_ID", sortDirection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> list() {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngineImpl.openConnection();
            List foundAccessItms = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            result.addAll(foundAccessItms);
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<WorkbasketAccessItem> list(int offset, int limit) {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngineImpl.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List foundAccessItms = this.taskanaEngineImpl.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            result.addAll(foundAccessItms);
            arrayList = result;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (PersistenceException e) {
            try {
                if (e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngineImpl.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public WorkbasketAccessItem single() {
        WorkbasketAccessItem workbasketAccessItem;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketAccessItem accessItm = null;
        try {
            this.taskanaEngineImpl.openConnection();
            workbasketAccessItem = accessItm = (WorkbasketAccessItem)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", accessItm);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)accessItm);
        return workbasketAccessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngineImpl.openConnection();
            rowCount = (Long)this.taskanaEngineImpl.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngineImpl.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private WorkbasketAccessItemQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " ASC";
        if (sortDirection != null && BaseQuery.SortDirection.DESCENDING.equals((Object)sortDirection)) {
            orderByDirection = " DESC";
        }
        this.orderBy.add(colName + orderByDirection);
        return this;
    }

    public String[] getAccessIdIn() {
        return this.accessIdIn;
    }

    public String[] getWorkbasketKeyIn() {
        return this.workbasketKeyIn;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketAccessItemQueryImpl [accessIdIn=");
        builder.append(Arrays.toString(this.accessIdIn));
        builder.append(", workbasketKeyIn=");
        builder.append(Arrays.toString(this.workbasketKeyIn));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

