/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.configuration.DbSchemaCreator;
import pro.taskana.impl.TaskanaEngineImpl;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    private static final String USER_NAME = "sa";
    private static final String USER_PASSWORD = "sa";
    private static final String JDBC_H2_MEM_TASKANA = "jdbc:h2:~/taskana-h2-data/testdb;AUTO_SERVER=TRUE;IGNORECASE=TRUE";
    private static final String H2_DRIVER = "org.h2.Driver";
    private static final String TASKANA_ROLES_PROPERTIES = "/taskanaroles.properties";
    private static final String TASKANA_PROPERTIES_SEPARATOR = "|";
    protected DataSource dataSource;
    protected DbSchemaCreator dbScriptRunner;
    protected String propertiesFileName = "/taskanaroles.properties";
    protected String propertiesSeparator = "|";
    protected boolean securityEnabled = true;
    protected boolean useManagedTransactions;
    private boolean germanPublicHolidaysEnabled;
    private List<LocalDate> customHolidays;

    public TaskanaEngineConfiguration(boolean enableSecurity) {
        this.securityEnabled = enableSecurity;
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions) throws SQLException {
        this(dataSource, useManagedTransactions, true);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled) throws SQLException {
        this(dataSource, useManagedTransactions, securityEnabled, null, null);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String propertiesSeparator) throws SQLException {
        this.useManagedTransactions = useManagedTransactions;
        this.securityEnabled = securityEnabled;
        if (propertiesFileName != null) {
            this.propertiesFileName = propertiesFileName;
        }
        if (propertiesSeparator != null) {
            this.propertiesSeparator = propertiesSeparator;
        }
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.dbScriptRunner = new DbSchemaCreator(this.dataSource);
        this.dbScriptRunner.run();
    }

    public static DataSource createDefaultDataSource() {
        LOGGER.warn("No datasource is provided. A inmemory db is used: 'org.h2.Driver', 'jdbc:h2:mem:taskana;IGNORECASE=TRUE', 'sa', 'sa'");
        return TaskanaEngineConfiguration.createDatasource(H2_DRIVER, JDBC_H2_MEM_TASKANA, "sa", "sa");
    }

    public TaskanaEngine buildTaskanaEngine() {
        return TaskanaEngineImpl.createTaskanaEngine(this);
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public boolean getUseManagedTransactions() {
        return this.useManagedTransactions;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public String getPropertiesSeparator() {
        return this.propertiesSeparator;
    }

    public void setPropertiesSeparator(String propertiesSeparator) {
        this.propertiesSeparator = propertiesSeparator;
    }

    public boolean isGermanPublicHolidaysEnabled() {
        return this.germanPublicHolidaysEnabled;
    }

    public void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public List<LocalDate> getCustomHolidays() {
        return this.customHolidays;
    }

    public void setCustomHolidays(List<LocalDate> customHolidays) {
        this.customHolidays = customHolidays;
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        return true;
    }
}

