/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.ReportLineItemDefinition;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.util.LoggerUtils;

public final class DaysToWorkingDaysConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private static DaysToWorkingDaysConverter instance;
    private static ArrayList<Integer> positiveDaysToWorkingDays;
    private static ArrayList<Integer> negativeDaysToWorkingDays;
    private static Instant dateCreated;
    private static LocalDate easterSunday;
    private static boolean germanHolidaysEnabled;
    private static List<LocalDate> customHolidays;

    private DaysToWorkingDaysConverter(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        easterSunday = this.getEasterSunday(LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).getYear());
        dateCreated = referenceDate;
        positiveDaysToWorkingDays = this.generatePositiveDaysToWorkingDays(reportLineItemDefinitions, referenceDate);
        negativeDaysToWorkingDays = this.generateNegativeDaysToWorkingDays(reportLineItemDefinitions, referenceDate);
    }

    public static DaysToWorkingDaysConverter initialize(List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return DaysToWorkingDaysConverter.initialize(reportLineItemDefinitions, Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize DaysToWorkingDaysConverter with reportLineItemDefinitions: {}", (Object)LoggerUtils.listToString(reportLineItemDefinitions));
        }
        if (reportLineItemDefinitions == null) {
            throw new InvalidArgumentException("ReportLineItemDefinitions can\u00b4t be used as NULL-Parameter");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        int largesLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(reportLineItemDefinitions);
        int smallestUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(reportLineItemDefinitions);
        if (!(instance != null && positiveDaysToWorkingDays.contains(largesLowerLimit) && negativeDaysToWorkingDays.contains(smallestUpperLimit) && dateCreated.truncatedTo(ChronoUnit.DAYS).equals(referenceDate.truncatedTo(ChronoUnit.DAYS)))) {
            instance = new DaysToWorkingDaysConverter(reportLineItemDefinitions, referenceDate);
            LOGGER.debug("Create new converter for the values from {} until {} for the date: {}.", new Object[]{largesLowerLimit, smallestUpperLimit, dateCreated});
        }
        return instance;
    }

    public int convertDaysToWorkingDays(int ageInDays) {
        int minDay = -(negativeDaysToWorkingDays.size() - 1);
        int maxDay = positiveDaysToWorkingDays.size() - 1;
        if (ageInDays >= minDay && ageInDays <= 0) {
            return negativeDaysToWorkingDays.get(-ageInDays);
        }
        if (ageInDays > 0 && ageInDays <= maxDay) {
            return positiveDaysToWorkingDays.get(ageInDays);
        }
        return ageInDays;
    }

    public int convertWorkingDaysToDays(int ageInWorkingDays) {
        int minWorkingDay = negativeDaysToWorkingDays.get(negativeDaysToWorkingDays.size() - 1);
        int maxWorkingDay = positiveDaysToWorkingDays.get(positiveDaysToWorkingDays.size() - 1);
        int ageInDays = 0;
        if (ageInWorkingDays >= minWorkingDay && ageInWorkingDays < 0) {
            while (negativeDaysToWorkingDays.get(ageInDays) > ageInWorkingDays) {
                ++ageInDays;
            }
            return -ageInDays;
        }
        if (ageInWorkingDays > 0 && ageInWorkingDays <= maxWorkingDay) {
            while (positiveDaysToWorkingDays.get(ageInDays) < ageInWorkingDays) {
                ++ageInDays;
            }
            return ageInDays;
        }
        return ageInWorkingDays;
    }

    private ArrayList<Integer> generateNegativeDaysToWorkingDays(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        int minUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(reportLineItemDefinitions);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = -1;
        int workingDay = 0;
        while (workingDay > minUpperLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                --workingDay;
            }
            daysToWorkingDays.add(workingDay);
            --day;
        }
        return daysToWorkingDays;
    }

    private ArrayList<Integer> generatePositiveDaysToWorkingDays(List<ReportLineItemDefinition> reportLineItemDefinitions, Instant referenceDate) {
        int maxLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(reportLineItemDefinitions);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = 1;
        int workingDay = 0;
        while (workingDay < maxLowerLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                ++workingDay;
            }
            daysToWorkingDays.add(workingDay);
            ++day;
        }
        return daysToWorkingDays;
    }

    private static int getSmallestUpperLimit(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        int smallestUpperLimit = 0;
        for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
            if (reportLineItemDefinition.getUpperAgeLimit() >= smallestUpperLimit) continue;
            smallestUpperLimit = reportLineItemDefinition.getUpperAgeLimit();
        }
        return smallestUpperLimit;
    }

    private static int getLargestLowerLimit(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        int greatestLowerLimit = 0;
        for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
            if (reportLineItemDefinition.getUpperAgeLimit() <= greatestLowerLimit) continue;
            greatestLowerLimit = reportLineItemDefinition.getLowerAgeLimit();
        }
        return greatestLowerLimit;
    }

    private boolean isWorkingDay(int day, Instant referenceDate) {
        return !LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day).getDayOfWeek().equals(DayOfWeek.SATURDAY) && !LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day).getDayOfWeek().equals(DayOfWeek.SUNDAY) && !this.isHoliday(LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day).toLocalDate());
    }

    private boolean isHoliday(LocalDate date) {
        if (germanHolidaysEnabled && (date.getDayOfMonth() == 1 && date.getMonthValue() == 1 || date.getDayOfMonth() == 1 && date.getMonthValue() == 5 || date.getDayOfMonth() == 3 && date.getMonthValue() == 10 || date.getDayOfMonth() == 25 && date.getMonthValue() == 12 || date.getDayOfMonth() == 26 && date.getMonthValue() == 12 || easterSunday.minusDays(2L).equals(date) || easterSunday.plusDays(1L).equals(date) || easterSunday.plusDays(39L).equals(date) || easterSunday.plusDays(50L).equals(date))) {
            return true;
        }
        if (customHolidays != null) {
            for (LocalDate customHoliday : customHolidays) {
                if (!date.equals(customHoliday)) continue;
                return true;
            }
        }
        return false;
    }

    public LocalDate getEasterSunday(int year) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int k = year / 100;
        int p = (13 + 8 * k) / 25;
        int q = k / 4;
        int m = (15 - p + k - q) % 30;
        int n = (4 + k - q) % 7;
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        if (d == 29 && e == 6) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        if (d == 28 && e == 6 && (11 * m + 11) % 30 < 19) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        return LocalDate.of(year, 3, 22).plusDays(d + e);
    }

    public static void setCustomHolidays(List<LocalDate> holidays) {
        customHolidays = holidays;
    }

    public List<LocalDate> getCustomHolidays() {
        return customHolidays;
    }

    public static void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        germanHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public boolean isGermanPublicHolidayEnabled() {
        return germanHolidaysEnabled;
    }
}

