/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.List;
import pro.taskana.impl.MonitorQueryItem;
import pro.taskana.impl.ReportLineItem;
import pro.taskana.impl.ReportLineItemDefinition;

public class ReportLine {
    protected List<ReportLineItem> lineItems = new ArrayList<ReportLineItem>();
    protected int totalNumberOfTasks = 0;

    public List<ReportLineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<ReportLineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public int getTotalNumberOfTasks() {
        return this.totalNumberOfTasks;
    }

    public void setTotalNumberOfTasks(int totalNumberOfTasks) {
        this.totalNumberOfTasks = totalNumberOfTasks;
    }

    public void create(List<ReportLineItemDefinition> reportLineItemDefinitions) {
        if (reportLineItemDefinitions != null) {
            for (ReportLineItemDefinition reportLineItemDefinition : reportLineItemDefinitions) {
                ReportLineItem reportLineItem = new ReportLineItem();
                reportLineItem.setReportLineItemDefinition(reportLineItemDefinition);
                this.getLineItems().add(reportLineItem);
            }
        }
    }

    public void addNumberOfTasks(MonitorQueryItem item) {
        this.totalNumberOfTasks += item.getNumberOfTasks();
        for (ReportLineItem reportLineItem : this.lineItems) {
            int lowerAgeLimit = reportLineItem.getReportLineItemDefinition().getLowerAgeLimit();
            int upperAgeLimit = reportLineItem.getReportLineItemDefinition().getUpperAgeLimit();
            if (lowerAgeLimit > item.getAgeInDays() || upperAgeLimit < item.getAgeInDays()) continue;
            reportLineItem.addNumberOfTasks(item.getNumberOfTasks());
            break;
        }
    }
}

