/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.CustomField;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskState;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.ClassificationReport;
import pro.taskana.impl.DaysToWorkingDaysConverter;
import pro.taskana.impl.DetailedClassificationReport;
import pro.taskana.impl.DetailedMonitorQueryItem;
import pro.taskana.impl.MonitorQueryItem;
import pro.taskana.impl.Report;
import pro.taskana.impl.ReportLineItemDefinition;
import pro.taskana.impl.SelectedItem;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.TaskMonitorMapper;

public class TaskMonitorServiceImpl
implements TaskMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMonitorMapper taskMonitorMapper;

    TaskMonitorServiceImpl(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    @Override
    public Report getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException {
        return this.getWorkbasketLevelReport(workbasketIds, states, categories, domains, customField, customFieldValues, null, false);
    }

    @Override
    public Report getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return this.getWorkbasketLevelReport(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbasketLevelReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfWorkbaskets(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasketLevelReport().");
        }
    }

    @Override
    public Report getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException {
        return this.getCategoryReport(workbasketIds, states, categories, domains, customField, customFieldValues, null, false);
    }

    @Override
    public Report getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return this.getCategoryReport(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCategoryReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCategories(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCategoryReport().");
        }
    }

    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException {
        return this.getClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, null, false);
    }

    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return this.getClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getClassificationReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            ClassificationReport report = new ClassificationReport();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfClassifications(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            ClassificationReport classificationReport = report;
            return classificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassificationReport().");
        }
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException {
        return this.getDetailedClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, null, false);
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return this.getDetailedClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getDetailedClassificationReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            DetailedClassificationReport report = new DetailedClassificationReport();
            List<DetailedMonitorQueryItem> detailedMonitorQueryItems = this.taskMonitorMapper.getTaskCountOfDetailedClassifications(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addDetailedMonitoringQueryItems(detailedMonitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            DetailedClassificationReport detailedClassificationReport = report;
            return detailedClassificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getDetailedClassificationReport().");
        }
    }

    @Override
    public Report getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException {
        return this.getCustomFieldValueReport(workbasketIds, states, categories, domains, customField, customFieldValues, null, false);
    }

    @Override
    public Report getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        return this.getCustomFieldValueReport(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Report getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCustomFieldValueReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays});
        }
        try {
            this.taskanaEngineImpl.openConnection();
            if (customField == null) {
                throw new InvalidArgumentException("CustomField can\u00b4t be used as NULL-Parameter");
            }
            this.configureDaysToWorkingDaysConverter();
            Report report = new Report();
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCustomFieldValues(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addMonitoringQueryItems(monitorQueryItems, reportLineItemDefinitions, inWorkingDays);
            Report report2 = report;
            return report2;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCustomFieldValueReport().");
        }
    }

    @Override
    public List<String> getTaskIdsOfCategoryReportLineItems(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, List<SelectedItem> selectedItems) throws InvalidArgumentException {
        return this.getTaskIdsOfCategoryReportLineItems(workbasketIds, states, categories, domains, customField, customFieldValues, reportLineItemDefinitions, true, selectedItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTaskIdsOfCategoryReportLineItems(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<ReportLineItemDefinition> reportLineItemDefinitions, boolean inWorkingDays, List<SelectedItem> selectedItems) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskIdsOfCategoryReportLineItems(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {}, selectedItems = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(reportLineItemDefinitions), inWorkingDays, LoggerUtils.listToString(selectedItems)});
        }
        try {
            List<String> taskIds;
            this.taskanaEngineImpl.openConnection();
            if (reportLineItemDefinitions == null) {
                throw new InvalidArgumentException("ReportLineItemDefinitions can\u00b4t be used as NULL-Parameter");
            }
            if (selectedItems == null || selectedItems.size() == 0) {
                throw new InvalidArgumentException("SelectedItems can\u00b4t be used as NULL-Parameter and should not be empty");
            }
            this.configureDaysToWorkingDaysConverter();
            if (inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, reportLineItemDefinitions);
            }
            List<String> list = taskIds = this.taskMonitorMapper.getTaskIdsOfCategoriesBySelectedItems(workbasketIds, states, categories, domains, customField, customFieldValues, selectedItems);
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskIdsOfCategoryReportLineItems().");
        }
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<ReportLineItemDefinition> reportLineItemDefinitions) throws InvalidArgumentException {
        DaysToWorkingDaysConverter instance = DaysToWorkingDaysConverter.initialize(reportLineItemDefinitions);
        for (SelectedItem selectedItem : selectedItems) {
            selectedItem.setLowerAgeLimit(instance.convertWorkingDaysToDays(selectedItem.getLowerAgeLimit()));
            selectedItem.setUpperAgeLimit(instance.convertWorkingDaysToDays(selectedItem.getUpperAgeLimit()));
        }
        return selectedItems;
    }

    private void configureDaysToWorkingDaysConverter() {
        DaysToWorkingDaysConverter.setCustomHolidays(this.taskanaEngineImpl.getConfiguration().getCustomHolidays());
        DaysToWorkingDaysConverter.setGermanPublicHolidaysEnabled(this.taskanaEngineImpl.getConfiguration().isGermanPublicHolidaysEnabled());
    }
}

