/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Attachment;
import pro.taskana.Classification;
import pro.taskana.ClassificationSummary;
import pro.taskana.Task;
import pro.taskana.TaskQuery;
import pro.taskana.TaskService;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.AttachmentPersistenceException;
import pro.taskana.exceptions.ClassificationNotFoundException;
import pro.taskana.exceptions.ConcurrencyException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidOwnerException;
import pro.taskana.exceptions.InvalidStateException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.TaskAlreadyExistException;
import pro.taskana.exceptions.TaskNotFoundException;
import pro.taskana.exceptions.TaskanaException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.AttachmentImpl;
import pro.taskana.impl.AttachmentSummaryImpl;
import pro.taskana.impl.BulkOperationResults;
import pro.taskana.impl.ClassificationServiceImpl;
import pro.taskana.impl.MinimalTaskSummary;
import pro.taskana.impl.ObjectReference;
import pro.taskana.impl.TaskImpl;
import pro.taskana.impl.TaskQueryImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketSummaryImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.AttachmentMapper;
import pro.taskana.mappings.TaskMapper;
import pro.taskana.security.CurrentUserContext;

public class TaskServiceImpl
implements TaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final String ID_PREFIX_ATTACHMENT = "TAI";
    private static final String ID_PREFIX_TASK = "TKI";
    private static final String ID_PREFIX_BUSINESS_PROCESS = "BPI";
    private static final String MUST_NOT_BE_EMPTY = " must not be empty";
    private static final Duration MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private TaskanaEngineImpl taskanaEngine;
    private WorkbasketService workbasketService;
    private ClassificationServiceImpl classificationService;
    private TaskMapper taskMapper;
    private AttachmentMapper attachmentMapper;

    TaskServiceImpl(TaskanaEngine taskanaEngine, TaskMapper taskMapper, AttachmentMapper attachmentMapper) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.taskMapper = taskMapper;
        this.workbasketService = taskanaEngine.getWorkbasketService();
        this.attachmentMapper = attachmentMapper;
        this.classificationService = (ClassificationServiceImpl)taskanaEngine.getClassificationService();
    }

    @Override
    public Task claim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        return this.claim(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task claim(String taskId, boolean forceClaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to claim(id = {}, forceClaim = {}, userId = {})", new Object[]{taskId, forceClaim, userId});
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                LOGGER.warn("Method claim() found that task {} is already completed. Throwing InvalidStateException", (Object)taskId);
                throw new InvalidStateException("Task is already completed");
            }
            if (state == TaskState.CLAIMED && !forceClaim && !task.getOwner().equals(userId)) {
                LOGGER.warn("Method claim() found that task {} is claimed by {} and forceClaim is false. Throwing InvalidOwnerException", (Object)taskId, (Object)task.getOwner());
                throw new InvalidOwnerException("You\u00b4re not the owner of this task and it is already claimed by other user " + task.getOwner());
            }
            Instant now = Instant.now();
            task.setOwner(userId);
            task.setModified(now);
            task.setClaimed(now);
            task.setRead(true);
            task.setState(TaskState.CLAIMED);
            this.taskMapper.update(task);
            LOGGER.debug("Method claim() claimed task '{}' for user '{}'.", (Object)taskId, (Object)userId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    @Override
    public Task cancelClaim(String taskId) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        return this.cancelClaim(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task cancelClaim(String taskId, boolean forceUnclaim) throws TaskNotFoundException, InvalidStateException, InvalidOwnerException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to cancelClaim(taskId = {}) with userId = {}, forceFlag = {}", new Object[]{taskId, userId, forceUnclaim});
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            TaskState state = task.getState();
            if (state == TaskState.COMPLETED) {
                LOGGER.warn("Method cancelClaim() found that task {} is already completed. Throwing InvalidStateException", (Object)taskId);
                throw new InvalidStateException("Task is already completed");
            }
            if (state == TaskState.CLAIMED && !forceUnclaim && !userId.equals(task.getOwner())) {
                LOGGER.warn("Method cancelClaim() found that task {} is claimed by {} and forceClaim is false. Throwing InvalidOwnerException", (Object)taskId, (Object)task.getOwner());
                throw new InvalidOwnerException("Task is already claimed by an other user = " + task.getOwner());
            }
            Instant now = Instant.now();
            task.setOwner(null);
            task.setModified(now);
            task.setClaimed(null);
            task.setRead(true);
            task.setState(TaskState.READY);
            this.taskMapper.update(task);
            LOGGER.debug("Method cancelClaim() unclaimed task '{}' for user '{}'.", (Object)taskId, (Object)userId);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from cancelClaim(taskId = {}) with userId = {}, forceFlag = {}", new Object[]{taskId, userId, forceUnclaim});
            throw throwable;
        }
        LOGGER.debug("exit from cancelClaim(taskId = {}) with userId = {}, forceFlag = {}", new Object[]{taskId, userId, forceUnclaim});
        return task;
    }

    @Override
    public Task completeTask(String taskId) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        return this.completeTask(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task completeTask(String taskId, boolean isForced) throws TaskNotFoundException, InvalidOwnerException, InvalidStateException {
        LOGGER.debug("entry to completeTask(id = {}, isForced {})", (Object)taskId, (Object)isForced);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            if (!isForced) {
                if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                    LOGGER.warn("Method completeTask() does expect a task which need to be CLAIMED before. TaskId={}", (Object)taskId);
                    throw new InvalidStateException(taskId);
                }
                if (!CurrentUserContext.getAccessIds().contains(task.getOwner())) {
                    LOGGER.warn("Method completeTask() does expect to be invoced by the task-owner or a administrator. TaskId={}, TaskOwner={}, CurrentUser={}", new Object[]{taskId, task.getOwner(), CurrentUserContext.getUserid()});
                    throw new InvalidOwnerException("TaskOwner is" + task.getOwner() + ", but current User is " + CurrentUserContext.getUserid());
                }
            } else if (task.getClaimed() == null || task.getState() != TaskState.CLAIMED) {
                task = (TaskImpl)this.claim(taskId, true);
            }
            Instant now = Instant.now();
            task.setCompleted(now);
            task.setModified(now);
            task.setState(TaskState.COMPLETED);
            task.setOwner(CurrentUserContext.getUserid());
            this.taskMapper.update(task);
            LOGGER.debug("Method completeTask() completed Task '{}'.", (Object)taskId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from completeTask()");
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> completeTasks(List<String> taskIds) throws InvalidArgumentException {
        try {
            LOGGER.debug("entry to completeTasks(taskIds = {})", taskIds);
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can\u00b4t be used as NULL-Parameter.");
            }
            BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
            if (!taskIds.isEmpty()) {
                Iterator<String> taskIdIterator = taskIds.iterator();
                while (taskIdIterator.hasNext()) {
                    String currentTaskId = taskIdIterator.next();
                    if (currentTaskId != null && !currentTaskId.isEmpty()) continue;
                    bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed and invalid."));
                    taskIdIterator.remove();
                }
                List taskSummaries = this.createTaskQuery().idIn(taskIds.toArray(new String[0])).list();
                Instant now = Instant.now();
                taskIdIterator = taskIds.iterator();
                while (taskIdIterator.hasNext()) {
                    String currentTaskId = taskIdIterator.next();
                    TaskSummaryImpl taskSummary = taskSummaries.stream().filter(ts -> currentTaskId.equals(ts.getTaskId())).findFirst().orElse(null);
                    if (taskSummary == null) {
                        bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, "task with id " + currentTaskId + " was not found."));
                        taskIdIterator.remove();
                        continue;
                    }
                    if (taskSummary.getClaimed() == null || taskSummary.getState() != TaskState.CLAIMED) {
                        bulkLog.addError(currentTaskId, new InvalidStateException(currentTaskId));
                        taskIdIterator.remove();
                        continue;
                    }
                    if (!CurrentUserContext.getAccessIds().contains(taskSummary.getOwner())) {
                        bulkLog.addError(currentTaskId, new InvalidOwnerException("TaskOwner is" + taskSummary.getOwner() + ", but current User is " + CurrentUserContext.getUserid()));
                        taskIdIterator.remove();
                        continue;
                    }
                    taskSummary.setCompleted(now);
                    taskSummary.setModified(now);
                    taskSummary.setState(TaskState.COMPLETED);
                }
                if (!taskIds.isEmpty() && !taskSummaries.isEmpty()) {
                    this.taskMapper.updateCompleted(taskIds, (TaskSummaryImpl)taskSummaries.get(0));
                }
            }
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from to completeTasks(taskIds = {})", taskIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task createTask(Task taskToCreate) throws NotAuthorizedException, WorkbasketNotFoundException, ClassificationNotFoundException, TaskAlreadyExistException, InvalidWorkbasketException, InvalidArgumentException {
        LOGGER.debug("entry to createTask(task = {})", (Object)taskToCreate);
        try {
            Workbasket workbasket;
            this.taskanaEngine.openConnection();
            TaskImpl task = (TaskImpl)taskToCreate;
            if (task.getId() != "" && task.getId() != null) {
                throw new TaskAlreadyExistException(taskToCreate.getId());
            }
            LOGGER.debug("Task {} cannot be be found, so it can be created.", (Object)taskToCreate.getId());
            if (taskToCreate.getWorkbasketSummary().getId() != null) {
                workbasket = this.workbasketService.getWorkbasket(taskToCreate.getWorkbasketSummary().getId());
            } else if (taskToCreate.getWorkbasketKey() != null) {
                workbasket = this.workbasketService.getWorkbasket(task.getWorkbasketKey(), task.getDomain());
            } else {
                throw new InvalidArgumentException("Cannot create a task outside a workbasket");
            }
            task.setWorkbasketSummary(workbasket.asSummary());
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.APPEND);
            String classificationKey = task.getClassificationKey();
            if (classificationKey == null || classificationKey.length() == 0) {
                throw new InvalidArgumentException("classificationKey of task must not be empty");
            }
            Classification classification = this.classificationService.getClassification(classificationKey, workbasket.getDomain());
            task.setClassificationSummary(classification.asSummary());
            this.validateObjectReference(task.getPrimaryObjRef(), "primary ObjectReference", "Task");
            PrioDurationHolder prioDurationFromAttachments = this.handleAttachments(task);
            task.setDomain(workbasket.getDomain());
            this.standardSettings(task, classification, prioDurationFromAttachments);
            this.taskMapper.insert(task);
            LOGGER.debug("Method createTask() created Task '{}'.", (Object)task.getId());
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createTask(task = {})");
        }
    }

    @Override
    public Task getTask(String id) throws TaskNotFoundException {
        LOGGER.debug("entry to getTaskById(id = {})", (Object)id);
        TaskImpl resultTask = null;
        try {
            this.taskanaEngine.openConnection();
            resultTask = this.taskMapper.findById(id);
            if (resultTask != null) {
                List<ClassificationSummary> classifications;
                List<AttachmentImpl> attachmentImpls = this.attachmentMapper.findAttachmentsByTaskId(resultTask.getId());
                if (attachmentImpls == null) {
                    attachmentImpls = new ArrayList<AttachmentImpl>();
                }
                try {
                    classifications = this.findClassificationForTaskImplAndAttachments(resultTask, attachmentImpls);
                }
                catch (NotAuthorizedException e1) {
                    LOGGER.error("ClassificationQuery unexpectedly returned NotauthorizedException. Throwing SystemException ");
                    throw new SystemException("ClassificationQuery unexpectedly returned NotauthorizedException.");
                }
                List<Attachment> attachments = this.addClassificationSummariesToAttachments(resultTask, attachmentImpls, classifications);
                resultTask.setAttachments(attachments);
                ClassificationSummary classification = this.getMatchingClassificationFromList(classifications, resultTask.getClassificationSummary().getKey(), resultTask.getDomain());
                resultTask.setClassificationSummary(classification);
                TaskImpl taskImpl = resultTask;
                return taskImpl;
            }
            LOGGER.warn("Method getTaskById() didn't find task with id {}. Throwing TaskNotFoundException", (Object)id);
            throw new TaskNotFoundException(id, "Task with id " + id + " was not found");
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getTaskById(). Returning result {} ", (Object)resultTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task transfer(String taskId, String destinationWorkbasketId) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketId = {})", (Object)taskId, (Object)destinationWorkbasketId);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            this.workbasketService.checkAuthorization(destinationWorkbasketId, WorkbasketPermission.APPEND);
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId);
            task.setRead(false);
            task.setTransferred(true);
            task.setWorkbasketSummary(destinationWorkbasket.asSummary());
            task.setModified(Instant.now());
            task.setState(TaskState.READY);
            task.setOwner(null);
            this.taskMapper.update(task);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasketId);
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task transfer(String taskId, String destinationWorkbasketKey, String domain) throws TaskNotFoundException, WorkbasketNotFoundException, NotAuthorizedException, InvalidWorkbasketException {
        LOGGER.debug("entry to transfer(taskId = {}, destinationWorkbasketKey = {}, domain = {})", new Object[]{taskId, destinationWorkbasketKey, domain});
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            this.workbasketService.checkAuthorization(destinationWorkbasketKey, domain, WorkbasketPermission.APPEND);
            this.workbasketService.checkAuthorization(task.getWorkbasketSummary().getId(), WorkbasketPermission.TRANSFER);
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, domain);
            task.setRead(false);
            task.setTransferred(true);
            task.setWorkbasketSummary(destinationWorkbasket.asSummary());
            task.setModified(Instant.now());
            task.setState(TaskState.READY);
            task.setOwner(null);
            this.taskMapper.update(task);
            LOGGER.debug("Method transfer() transferred Task '{}' to destination workbasket {}", (Object)taskId, (Object)destinationWorkbasket.getId());
            TaskImpl taskImpl = task;
            return taskImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from transfer(). Returning result {} ", (Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketId, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        try {
            this.taskanaEngine.openConnection();
            LOGGER.debug("entry to transferBulk(targetWbId = {}, taskIds = {})", (Object)destinationWorkbasketId, taskIds);
            if (destinationWorkbasketId == null || taskIds == null) {
                throw new InvalidArgumentException("DestinationWorkbasketId or TaskIds can\u00b4t be used as NULL-Parameter.");
            }
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketId);
            BulkOperationResults<String, TaskanaException> bulkOperationResults = this.transferTasks(taskIds, destinationWorkbasket);
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from transferBulk(targetWbKey = {}, taskIds = {})", (Object)destinationWorkbasketId, taskIds);
            this.taskanaEngine.returnConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> transferTasks(String destinationWorkbasketKey, String destinationWorkbasketDomain, List<String> taskIds) throws NotAuthorizedException, InvalidArgumentException, WorkbasketNotFoundException {
        BulkOperationResults<String, TaskanaException> bulkOperationResults;
        try {
            this.taskanaEngine.openConnection();
            LOGGER.debug("entry to transferBulk(targetWbKey = {}, domain = {}, taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
            if (destinationWorkbasketKey == null || destinationWorkbasketDomain == null || taskIds == null) {
                throw new InvalidArgumentException("DestinationWorkbasketKey or domain or TaskIds can\u00b4t be used as NULL-Parameter.");
            }
            Workbasket destinationWorkbasket = this.workbasketService.getWorkbasket(destinationWorkbasketKey, destinationWorkbasketDomain);
            bulkOperationResults = this.transferTasks(taskIds, destinationWorkbasket);
        }
        catch (Throwable throwable) {
            LOGGER.debug("exit from transferBulk(targetWbKey = {}, taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
            this.taskanaEngine.returnConnection();
            throw throwable;
        }
        LOGGER.debug("exit from transferBulk(targetWbKey = {}, taskIds = {})", new Object[]{destinationWorkbasketKey, destinationWorkbasketDomain, taskIds});
        this.taskanaEngine.returnConnection();
        return bulkOperationResults;
    }

    private BulkOperationResults<String, TaskanaException> transferTasks(List<String> taskIds, Workbasket destinationWorkbasket) throws InvalidArgumentException {
        BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
        Iterator<String> taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            if (currentTaskId != null && !currentTaskId.equals("")) continue;
            bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
            taskIdIterator.remove();
        }
        List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds);
        HashSet workbasketKeys = new HashSet();
        taskSummaries.stream().forEach(t -> workbasketKeys.add(t.getWorkbasketKey()));
        List sourceWorkbaskets = this.workbasketService.createWorkbasketQuery().callerHasPermission(WorkbasketPermission.TRANSFER).keyIn(workbasketKeys.toArray(new String[0])).list();
        taskIdIterator = taskIds.iterator();
        while (taskIdIterator.hasNext()) {
            String currentTaskId = taskIdIterator.next();
            MinimalTaskSummary taskSummary = taskSummaries.stream().filter(t -> currentTaskId.equals(t.getTaskId())).findFirst().orElse(null);
            if (taskSummary == null) {
                bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, "Task with id " + currentTaskId + " was not found."));
                taskIdIterator.remove();
                continue;
            }
            if (sourceWorkbaskets.stream().anyMatch(wb -> taskSummary.getWorkbasketKey().equals(wb.getKey()))) continue;
            bulkLog.addError(currentTaskId, new NotAuthorizedException("The workbasket of this task got not TRANSFER permissions. TaskId=" + currentTaskId));
            taskIdIterator.remove();
        }
        if (!(taskSummaries = taskSummaries.stream().filter(ts -> taskIds.contains(ts.getTaskId())).collect(Collectors.toList())).isEmpty()) {
            Instant now = Instant.now();
            TaskSummaryImpl updateObject = new TaskSummaryImpl();
            updateObject.setRead(false);
            updateObject.setTransferred(true);
            updateObject.setWorkbasketSummary(destinationWorkbasket.asSummary());
            updateObject.setDomain(destinationWorkbasket.getDomain());
            updateObject.setModified(now);
            updateObject.setState(TaskState.READY);
            updateObject.setOwner(null);
            this.taskMapper.updateTransfered(taskIds, updateObject);
        }
        return bulkLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task setTaskRead(String taskId, boolean isRead) throws TaskNotFoundException {
        Task task;
        LOGGER.debug("entry to setTaskRead(taskId = {}, isRead = {})", (Object)taskId, (Object)isRead);
        Task result = null;
        try {
            this.taskanaEngine.openConnection();
            TaskImpl task2 = (TaskImpl)this.getTask(taskId);
            task2.setRead(true);
            task2.setModified(Instant.now());
            this.taskMapper.update(task2);
            result = this.getTask(taskId);
            LOGGER.debug("Method setTaskRead() set read property of Task '{}' to {} ", (Object)result, (Object)isRead);
            task = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from setTaskRead(taskId, isRead). Returning result {} ", (Object)result);
        return task;
    }

    @Override
    public TaskQuery createTaskQuery() {
        return new TaskQueryImpl(this.taskanaEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task updateTask(Task task) throws InvalidArgumentException, TaskNotFoundException, ConcurrencyException, WorkbasketNotFoundException, ClassificationNotFoundException, InvalidWorkbasketException, NotAuthorizedException, AttachmentPersistenceException {
        String userId = CurrentUserContext.getUserid();
        LOGGER.debug("entry to updateTask(task = {}, userId = {})", (Object)task, (Object)userId);
        TaskImpl newTaskImpl = (TaskImpl)task;
        TaskImpl oldTaskImpl = null;
        try {
            this.taskanaEngine.openConnection();
            oldTaskImpl = (TaskImpl)this.getTask(newTaskImpl.getId());
            PrioDurationHolder prioDurationFromAttachments = this.handleAttachmentsOnTaskUpdate(oldTaskImpl, newTaskImpl);
            this.standardUpdateActions(oldTaskImpl, newTaskImpl, prioDurationFromAttachments);
            newTaskImpl.setModified(Instant.now());
            this.taskMapper.update(newTaskImpl);
            LOGGER.debug("Method updateTask() updated task '{}' for user '{}'.", (Object)task.getId(), (Object)userId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from claim()");
        }
        return task;
    }

    private void standardSettings(TaskImpl task, Classification classification, PrioDurationHolder prioDurationFromAttachments) {
        List<Attachment> attachments;
        Instant now = Instant.now();
        task.setId(IdGenerator.generateWithPrefix(ID_PREFIX_TASK));
        task.setState(TaskState.READY);
        task.setCreated(now);
        task.setModified(now);
        task.setRead(false);
        task.setTransferred(false);
        String creator = CurrentUserContext.getUserid();
        if (this.taskanaEngine.getConfiguration().isSecurityEnabled() && creator == null) {
            throw new SystemException("TaskanaSecurity is enabled, but the current UserId is NULL while creating a Task.");
        }
        task.setCreator(creator);
        if (task.getPlanned() == null) {
            task.setPlanned(now);
        }
        if (task.getBusinessProcessId() == null) {
            task.setBusinessProcessId(IdGenerator.generateWithPrefix(ID_PREFIX_BUSINESS_PROCESS));
        }
        if (classification != null) {
            PrioDurationHolder finalPrioDuration = this.getNewPrioDuration(prioDurationFromAttachments.getPrio(), prioDurationFromAttachments.getDuration(), classification.getPriority(), classification.getServiceLevel());
            Duration finalDuration = finalPrioDuration.getDuration();
            if (finalDuration != null && !MAX_DURATION.equals(finalDuration)) {
                Instant due = task.getPlanned().plus(finalDuration);
                task.setDue(due);
            }
            task.setPriority(finalPrioDuration.getPrio());
        }
        if (task.getName() == null) {
            task.setName(classification.getName());
        }
        if (task.getDescription() == null) {
            task.setDescription(classification.getDescription());
        }
        if ((attachments = task.getAttachments()) != null) {
            for (Attachment attachment : attachments) {
                AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
                attachmentImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_ATTACHMENT));
                attachmentImpl.setTaskId(task.getId());
                attachmentImpl.setCreated(now);
                attachmentImpl.setModified(now);
                this.attachmentMapper.insert(attachmentImpl);
            }
        }
    }

    List<TaskSummary> augmentTaskSummariesByContainedSummaries(List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        LOGGER.debug("entry to augmentTaskSummariesByContainedSummaries()");
        ArrayList<TaskSummary> result = new ArrayList<TaskSummary>();
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return result;
        }
        Set<String> taskIdSet = taskSummaries.stream().map(TaskSummaryImpl::getTaskId).collect(Collectors.toSet());
        String[] taskIdArray = taskIdSet.toArray(new String[0]);
        LOGGER.debug("augmentTaskSummariesByContainedSummaries() about to query for attachments ");
        List<AttachmentSummaryImpl> attachmentSummaries = this.attachmentMapper.findAttachmentSummariesByTaskIds(taskIdArray);
        List<ClassificationSummary> classifications = this.findClassificationsForTasksAndAttachments(taskSummaries, attachmentSummaries);
        this.addClassificationSummariesToTaskSummaries(taskSummaries, classifications);
        this.addWorkbasketSummariesToTaskSummaries(taskSummaries);
        this.addAttachmentSummariesToTaskSummaries(taskSummaries, attachmentSummaries, classifications);
        result.addAll(taskSummaries);
        LOGGER.debug("exit from to augmentTaskSummariesByContainedSummaries()");
        return result;
    }

    private void addClassificationSummariesToTaskSummaries(List<TaskSummaryImpl> tasks, List<ClassificationSummary> classifications) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        for (TaskSummaryImpl task : tasks) {
            ClassificationSummary aClassification = this.getMatchingClassificationFromList(classifications, task.getClassificationSummary().getKey(), task.getDomain());
            task.setClassificationSummary(aClassification);
        }
    }

    private ClassificationSummary getMatchingClassificationFromList(List<ClassificationSummary> classifications, String taskClassKey, String taskDomain) {
        ClassificationSummary aClassification = classifications.stream().filter(x -> taskClassKey != null && taskClassKey.equals(x.getKey()) && taskDomain != null && taskDomain.equals(x.getDomain())).findFirst().orElse(null);
        if (aClassification == null && (aClassification = (ClassificationSummary)classifications.stream().filter(x -> taskClassKey != null && taskClassKey.equals(x.getKey()) && "".equals(x.getDomain())).findFirst().orElse(null)) == null) {
            LOGGER.error("Could not find a Classification for task ");
            throw new SystemException("Could not find a Classification for task (key=" + taskClassKey + ",domain=" + taskDomain + ")");
        }
        return aClassification;
    }

    private List<ClassificationSummary> findClassificationsForTasksAndAttachments(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries) throws NotAuthorizedException {
        LOGGER.debug("entry to getClassificationsForTasksAndAttachments()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return new ArrayList<ClassificationSummary>();
        }
        Set<String> classificationDomainSet = taskSummaries.stream().map(TaskSummaryImpl::getDomain).collect(Collectors.toSet());
        classificationDomainSet.add("");
        Set<String> classificationKeySet = taskSummaries.stream().map(t -> t.getClassificationSummary().getKey()).collect(Collectors.toSet());
        if (attachmentSummaries != null && !attachmentSummaries.isEmpty()) {
            Set classificationKeysFromAttachments = attachmentSummaries.stream().map(t -> t.getClassificationSummary().getKey()).collect(Collectors.toSet());
            classificationKeySet.addAll(classificationKeysFromAttachments);
        }
        return this.queryClassificationsForTasksAndAttachments(classificationDomainSet, classificationKeySet);
    }

    private List<ClassificationSummary> findClassificationForTaskImplAndAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls) throws NotAuthorizedException {
        HashSet<String> classificationDomainSet = new HashSet<String>(Arrays.asList(task.getDomain(), ""));
        HashSet<String> classificationKeySet = new HashSet<String>(Arrays.asList(task.getClassificationKey()));
        if (attachmentImpls != null && !attachmentImpls.isEmpty()) {
            Set classificationKeysFromAttachments = attachmentImpls.stream().map(t -> t.getClassificationSummary().getKey()).collect(Collectors.toSet());
            classificationKeySet.addAll(classificationKeysFromAttachments);
        }
        return this.queryClassificationsForTasksAndAttachments(classificationDomainSet, classificationKeySet);
    }

    private List<ClassificationSummary> queryClassificationsForTasksAndAttachments(Set<String> classificationDomainSet, Set<String> classificationKeySet) throws NotAuthorizedException {
        String[] classificationDomainArray = classificationDomainSet.toArray(new String[0]);
        String[] classificationKeyArray = classificationKeySet.toArray(new String[0]);
        LOGGER.debug("getClassificationsForTasksAndAttachments() about to query classifications and exit");
        return this.classificationService.createClassificationQuery().domainIn(classificationDomainArray).keyIn(classificationKeyArray).list();
    }

    private void addWorkbasketSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries) throws NotAuthorizedException {
        LOGGER.debug("entry to addWorkbasketSummariesToTaskSummaries()");
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        Set<String> workbasketKeySet = taskSummaries.stream().map(t -> t.getWorkbasketSummary().getKey()).collect(Collectors.toSet());
        String[] workbasketKeyArray = workbasketKeySet.toArray(new String[0]);
        LOGGER.debug("addWorkbasketSummariesToTaskSummaries() about to query workbaskets");
        List workbaskets = this.workbasketService.createWorkbasketQuery().keyIn(workbasketKeyArray).list();
        for (TaskSummaryImpl task : taskSummaries) {
            String workbasketKey = task.getWorkbasketSummaryImpl().getKey();
            WorkbasketSummary aWorkbasket = workbaskets.stream().filter(x -> workbasketKey != null && workbasketKey.equals(x.getKey())).findFirst().orElse(null);
            if (aWorkbasket == null) {
                LOGGER.error("Could not find a Workbasket for task {}.", (Object)task.getTaskId());
                throw new SystemException("Could not find a Workbasket for task " + task.getTaskId());
            }
            task.setWorkbasketSummary(aWorkbasket);
        }
        LOGGER.debug("exit from addWorkbasketSummariesToTaskSummaries()");
    }

    private void addAttachmentSummariesToTaskSummaries(List<TaskSummaryImpl> taskSummaries, List<AttachmentSummaryImpl> attachmentSummaries, List<ClassificationSummary> classifications) {
        if (taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        this.addClassificationSummariesToAttachmentSummaries(attachmentSummaries, taskSummaries, classifications);
        for (TaskSummaryImpl task : taskSummaries) {
            for (AttachmentSummaryImpl attachment : attachmentSummaries) {
                if (attachment.getTaskId() == null || !attachment.getTaskId().equals(task.getTaskId())) continue;
                task.addAttachmentSummary(attachment);
            }
        }
    }

    private void addClassificationSummariesToAttachmentSummaries(List<AttachmentSummaryImpl> attachmentSummaries, List<TaskSummaryImpl> taskSummaries, List<ClassificationSummary> classifications) {
        if (attachmentSummaries == null || attachmentSummaries.isEmpty() || taskSummaries == null || taskSummaries.isEmpty()) {
            return;
        }
        for (AttachmentSummaryImpl att : attachmentSummaries) {
            TaskSummaryImpl aTaskSummary = taskSummaries.stream().filter(x -> x.getTaskId().equals(att.getTaskId())).findFirst().orElse(null);
            if (aTaskSummary == null) {
                LOGGER.error("Could not find a Task associated to attachment {}.", (Object)att);
                throw new SystemException("Could not find a Task associated to attachment " + att);
            }
            String domain = aTaskSummary.getDomain();
            String classificationKey = att.getClassificationSummary().getKey();
            ClassificationSummary aClassification = classifications.stream().filter(x -> classificationKey != null && classificationKey.equals(x.getKey()) && domain != null && domain.equals(x.getDomain())).findFirst().orElse(null);
            if (aClassification == null) {
                LOGGER.error("Could not find a Classification for attachment {}.", (Object)att);
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(aClassification);
        }
    }

    private List<Attachment> addClassificationSummariesToAttachments(TaskImpl task, List<AttachmentImpl> attachmentImpls, List<ClassificationSummary> classifications) {
        if (attachmentImpls == null || attachmentImpls.isEmpty()) {
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (AttachmentImpl att : attachmentImpls) {
            String domain = task.getDomain();
            String classificationKey = att.getClassificationSummary().getKey();
            ClassificationSummary aClassification = classifications.stream().filter(x -> classificationKey != null && classificationKey.equals(x.getKey()) && domain != null && domain.equals(x.getDomain())).findFirst().orElse(null);
            if (aClassification == null) {
                LOGGER.error("Could not find a Classification for attachment {}.", (Object)att);
                throw new SystemException("Could not find a Classification for attachment " + att);
            }
            att.setClassificationSummary(aClassification);
            result.add(att);
        }
        return result;
    }

    @Override
    public Task newTask(String workbasketId) {
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setId(workbasketId);
        task.setWorkbasketSummary(wb);
        return task;
    }

    @Override
    public Task newTask(String workbasketKey, String domain) {
        TaskImpl task = new TaskImpl();
        WorkbasketSummaryImpl wb = new WorkbasketSummaryImpl();
        wb.setKey(workbasketKey);
        wb.setDomain(domain);
        task.setWorkbasketSummary(wb);
        return task;
    }

    @Override
    public Attachment newAttachment() {
        return new AttachmentImpl();
    }

    @Override
    public void deleteTask(String taskId) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        this.deleteTask(taskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTask(String taskId, boolean forceDelete) throws TaskNotFoundException, InvalidStateException, NotAuthorizedException {
        LOGGER.debug("entry to deleteTask(taskId = {} , forceDelete = {} )", (Object)taskId, (Object)forceDelete);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.ADMIN);
        TaskImpl task = null;
        try {
            this.taskanaEngine.openConnection();
            task = (TaskImpl)this.getTask(taskId);
            if (!TaskState.COMPLETED.equals((Object)task.getState()) && !forceDelete) {
                LOGGER.warn("Method deleteTask() found that task {} is not completed and forceDelete is false. Throwing InvalidStateException", (Object)task);
                throw new InvalidStateException("Cannot delete Task " + taskId + " because it is not completed");
            }
            this.taskMapper.delete(taskId);
            LOGGER.debug("Method deleteTask() deleted Task {}", (Object)taskId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteTask(). ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkOperationResults<String, TaskanaException> deleteTasks(List<String> taskIds) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteTasks(tasks = {})", (Object)LoggerUtils.listToString(taskIds));
        }
        try {
            this.taskanaEngine.openConnection();
            if (taskIds == null) {
                throw new InvalidArgumentException("TaskIds can\u00b4t be NULL as parameter for deleteTasks().");
            }
            BulkOperationResults<String, TaskanaException> bulkLog = new BulkOperationResults<String, TaskanaException>();
            List<MinimalTaskSummary> taskSummaries = this.taskMapper.findExistingTasks(taskIds);
            Iterator<String> taskIdIterator = taskIds.iterator();
            while (taskIdIterator.hasNext()) {
                String currentTaskId = taskIdIterator.next();
                if (currentTaskId == null || currentTaskId.equals("")) {
                    bulkLog.addError("", new InvalidArgumentException("IDs with EMPTY or NULL value are not allowed."));
                    taskIdIterator.remove();
                    continue;
                }
                MinimalTaskSummary foundSummary = taskSummaries.stream().filter(taskState -> currentTaskId.equals(taskState.getTaskId())).findFirst().orElse(null);
                if (foundSummary == null) {
                    bulkLog.addError(currentTaskId, new TaskNotFoundException(currentTaskId, "Task with id " + currentTaskId + " was not found."));
                    taskIdIterator.remove();
                    continue;
                }
                if (TaskState.COMPLETED.equals((Object)foundSummary.getTaskState())) continue;
                bulkLog.addError(currentTaskId, new InvalidStateException(currentTaskId));
                taskIdIterator.remove();
            }
            if (!taskIds.isEmpty()) {
                this.taskMapper.deleteMultiple(taskIds);
            }
            BulkOperationResults<String, TaskanaException> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            LOGGER.debug("exit from deleteTasks()");
            this.taskanaEngine.returnConnection();
        }
    }

    private void validateObjectReference(ObjectReference objRef, String objRefType, String objName) throws InvalidArgumentException {
        if (objRef == null) {
            throw new InvalidArgumentException(objRefType + " of " + objName + " must not be null");
        }
        if (objRef.getCompany() == null || objRef.getCompany().length() == 0) {
            throw new InvalidArgumentException("Company of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getSystem() == null || objRef.getSystem().length() == 0) {
            throw new InvalidArgumentException("System of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getSystemInstance() == null || objRef.getSystemInstance().length() == 0) {
            throw new InvalidArgumentException("SystemInstance of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getType() == null || objRef.getType().length() == 0) {
            throw new InvalidArgumentException("Type of " + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
        if (objRef.getValue() == null || objRef.getValue().length() == 0) {
            throw new InvalidArgumentException("Value of" + objRefType + " of " + objName + MUST_NOT_BE_EMPTY);
        }
    }

    private PrioDurationHolder handleAttachments(TaskImpl task) throws InvalidArgumentException {
        List<Attachment> attachments = task.getAttachments();
        if (attachments == null || attachments.isEmpty()) {
            return new PrioDurationHolder(null, Integer.MIN_VALUE);
        }
        Duration minDuration = MAX_DURATION;
        int maxPrio = Integer.MIN_VALUE;
        Iterator<Attachment> i = attachments.iterator();
        while (i.hasNext()) {
            Attachment attachment = i.next();
            if (attachment == null) {
                i.remove();
                continue;
            }
            ObjectReference objRef = attachment.getObjectReference();
            this.validateObjectReference(objRef, "ObjectReference", "Attachment");
            if (attachment.getClassificationSummary() == null) {
                throw new InvalidArgumentException("Classification of attachment " + attachment + " must not be null");
            }
            ClassificationSummary classificationSummary = attachment.getClassificationSummary();
            if (classificationSummary == null) continue;
            PrioDurationHolder newPrioDuraton = this.getNewPrioDuration(maxPrio, minDuration, classificationSummary.getPriority(), classificationSummary.getServiceLevel());
            maxPrio = newPrioDuraton.getPrio();
            minDuration = newPrioDuraton.getDuration();
        }
        if (minDuration != null && MAX_DURATION.equals(minDuration)) {
            minDuration = null;
        }
        return new PrioDurationHolder(minDuration, maxPrio);
    }

    private void standardUpdateActions(TaskImpl oldTaskImpl, TaskImpl newTaskImpl, PrioDurationHolder prioDurationFromAttachments) throws InvalidArgumentException, ConcurrencyException, WorkbasketNotFoundException, ClassificationNotFoundException, NotAuthorizedException {
        this.validateObjectReference(newTaskImpl.getPrimaryObjRef(), "primary ObjectReference", "Task");
        if (oldTaskImpl.getModified() != null && !oldTaskImpl.getModified().equals(newTaskImpl.getModified()) || oldTaskImpl.getClaimed() != null && !oldTaskImpl.getClaimed().equals(newTaskImpl.getClaimed()) || oldTaskImpl.getState() != null && !oldTaskImpl.getState().equals((Object)newTaskImpl.getState())) {
            throw new ConcurrencyException("The task has already been updated by another user");
        }
        String newWorkbasketKey = newTaskImpl.getWorkbasketKey();
        if (newWorkbasketKey != null && !newWorkbasketKey.equals(oldTaskImpl.getWorkbasketKey())) {
            throw new InvalidArgumentException("A task's Workbasket cannot be changed via update of the task");
        }
        if (newTaskImpl.getPlanned() == null) {
            newTaskImpl.setPlanned(oldTaskImpl.getPlanned());
        }
        if (newTaskImpl.getBusinessProcessId() == null) {
            newTaskImpl.setBusinessProcessId(oldTaskImpl.getBusinessProcessId());
        }
        this.updateClassificationRelatedProperties(oldTaskImpl, newTaskImpl, prioDurationFromAttachments);
        newTaskImpl.setModified(Instant.now());
    }

    private void updateClassificationRelatedProperties(TaskImpl oldTaskImpl, TaskImpl newTaskImpl, PrioDurationHolder prioDurationFromAttachments) throws WorkbasketNotFoundException, NotAuthorizedException, ClassificationNotFoundException {
        ClassificationSummary oldClassificationSummary = oldTaskImpl.getClassificationSummary();
        ClassificationSummary newClassificationSummary = newTaskImpl.getClassificationSummary();
        if (newClassificationSummary == null) {
            newClassificationSummary = oldClassificationSummary;
        }
        if (newClassificationSummary == null) {
            if (prioDurationFromAttachments.getDuration() != null) {
                Instant due = newTaskImpl.getPlanned().plus(prioDurationFromAttachments.getDuration());
                newTaskImpl.setDue(due);
            }
            if (prioDurationFromAttachments.getPrio() > Integer.MIN_VALUE) {
                newTaskImpl.setPriority(prioDurationFromAttachments.getPrio());
            }
        } else {
            Classification newClassification = null;
            if (!oldClassificationSummary.getKey().equals(newClassificationSummary.getKey())) {
                newClassification = this.classificationService.getClassification(newClassificationSummary.getKey(), newTaskImpl.getWorkbasketSummary().getDomain());
                newClassificationSummary = newClassification.asSummary();
                newTaskImpl.setClassificationSummary(newClassificationSummary);
            }
            if (newClassificationSummary.getServiceLevel() != null) {
                Duration durationFromClassification = Duration.parse(newClassificationSummary.getServiceLevel());
                Duration minDuration = prioDurationFromAttachments.getDuration();
                if (minDuration != null) {
                    if (minDuration.compareTo(durationFromClassification) > 0) {
                        minDuration = durationFromClassification;
                    }
                } else {
                    minDuration = durationFromClassification;
                }
                Instant due = newTaskImpl.getPlanned().plus(minDuration);
                newTaskImpl.setDue(due);
            }
            if (newTaskImpl.getName() == null) {
                newTaskImpl.setName(newClassificationSummary.getName());
            }
            if (newTaskImpl.getDescription() == null && newClassification != null) {
                newTaskImpl.setDescription(newClassification.getDescription());
            }
            int newPriority = Math.max(newClassificationSummary.getPriority(), prioDurationFromAttachments.getPrio());
            newTaskImpl.setPriority(newPriority);
        }
    }

    private PrioDurationHolder handleAttachmentsOnTaskUpdate(TaskImpl oldTaskImpl, TaskImpl newTaskImpl) throws AttachmentPersistenceException {
        Duration minDuration = MAX_DURATION;
        int maxPrio = Integer.MIN_VALUE;
        Iterator<Attachment> i = newTaskImpl.getAttachments().iterator();
        while (i.hasNext()) {
            Attachment attachment = i.next();
            if (attachment != null) {
                boolean wasAlreadyPresent = false;
                if (attachment.getId() != null) {
                    for (Attachment oldAttachment : oldTaskImpl.getAttachments()) {
                        if (oldAttachment == null || !attachment.getId().equals(oldAttachment.getId())) continue;
                        wasAlreadyPresent = true;
                        if (attachment.equals(oldAttachment)) continue;
                        AttachmentImpl temp = (AttachmentImpl)attachment;
                        ClassificationSummary classification = attachment.getClassificationSummary();
                        if (classification != null) {
                            PrioDurationHolder newPrioDuration = this.getNewPrioDuration(maxPrio, minDuration, classification.getPriority(), classification.getServiceLevel());
                            maxPrio = newPrioDuration.getPrio();
                            minDuration = newPrioDuration.getDuration();
                        }
                        temp.setModified(Instant.now());
                        this.attachmentMapper.update(temp);
                        LOGGER.debug("TaskService.updateTask() for TaskId={} UPDATED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachment);
                        break;
                    }
                }
                if (wasAlreadyPresent) continue;
                AttachmentImpl attachmentImpl = (AttachmentImpl)attachment;
                this.initAttachment(attachmentImpl, newTaskImpl);
                ClassificationSummary classification = attachment.getClassificationSummary();
                if (classification != null) {
                    PrioDurationHolder newPrioDuration = this.getNewPrioDuration(maxPrio, minDuration, classification.getPriority(), classification.getServiceLevel());
                    maxPrio = newPrioDuration.getPrio();
                    minDuration = newPrioDuration.getDuration();
                }
                try {
                    this.attachmentMapper.insert(attachmentImpl);
                    LOGGER.debug("TaskService.updateTask() for TaskId={} INSERTED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)attachmentImpl);
                    continue;
                }
                catch (PersistenceException e) {
                    LOGGER.error("TaskService.updateTask() for TaskId={} can NOT INSERT the current Attachment, because it was added fored multiple times and wasn\u00b4t persisted before. ID={}", (Object)newTaskImpl.getId(), (Object)attachmentImpl.getId());
                    throw new AttachmentPersistenceException(attachmentImpl.getId());
                }
            }
            i.remove();
        }
        for (Attachment oldAttachment : oldTaskImpl.getAttachments()) {
            if (oldAttachment == null) continue;
            boolean isRepresented = false;
            for (Attachment newAttachment : newTaskImpl.getAttachments()) {
                if (newAttachment == null || !oldAttachment.getId().equals(newAttachment.getId())) continue;
                isRepresented = true;
                break;
            }
            if (isRepresented) continue;
            this.attachmentMapper.deleteAttachment(oldAttachment.getId());
            LOGGER.debug("TaskService.updateTask() for TaskId={} DELETED an Attachment={}.", (Object)newTaskImpl.getId(), (Object)oldAttachment);
        }
        if (minDuration != null && MAX_DURATION.equals(minDuration)) {
            minDuration = null;
        }
        return new PrioDurationHolder(minDuration, maxPrio);
    }

    private PrioDurationHolder getNewPrioDuration(int prio, Duration duration, int prioFromClassification, String serviceLevelFromClassification) {
        Duration minDuration = duration;
        int maxPrio = prio;
        if (serviceLevelFromClassification != null) {
            Duration currentDuration = Duration.parse(serviceLevelFromClassification);
            if (duration != null) {
                if (duration.compareTo(currentDuration) > 0) {
                    minDuration = currentDuration;
                }
            } else {
                minDuration = currentDuration;
            }
        }
        if (prioFromClassification > maxPrio) {
            maxPrio = prioFromClassification;
        }
        return new PrioDurationHolder(minDuration, maxPrio);
    }

    private void initAttachment(AttachmentImpl attachment, Task newTask) {
        if (attachment.getId() == null) {
            attachment.setId(IdGenerator.generateWithPrefix(ID_PREFIX_ATTACHMENT));
        }
        if (attachment.getCreated() == null) {
            attachment.setCreated(Instant.now());
        }
        if (attachment.getModified() == null) {
            attachment.setModified(attachment.getCreated());
        }
        if (attachment.getTaskId() == null) {
            attachment.setTaskId(newTask.getId());
        }
    }

    static class PrioDurationHolder {
        private Duration duration;
        private int prio;

        PrioDurationHolder(Duration duration, int prio) {
            this.duration = duration;
            this.prio = prio;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public int getPrio() {
            return this.prio;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PrioDurationHolder [duration=");
            builder.append(this.duration);
            builder.append(", prio=");
            builder.append(this.prio);
            builder.append("]");
            return builder.toString();
        }
    }
}

